/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.handler;

import java.math.BigDecimal;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.helper.DataChangeHelper;
import kd.qmc.mobqc.business.helper.QmcBillCalculateHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.pojo.ChangedField;

public abstract class AbstractQmcBillChangedHandler
implements IPropertyChangedHandler {
    private ICaleFiedMap iCaleFiedMap = null;
    private static String[] fixFields = new String[]{"materialid", "qty", "baseqty", "unit", "baseunit"};

    public final void initChangedHandler(ICaleFiedMap iCaleFiedMap) {
        this.iCaleFiedMap = iCaleFiedMap;
    }

    public void onPropertyChanged(PropertyChangedContext context) {
        boolean main = context.isMain();
        if (main) {
            return;
        }
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        String fixFieldKey = "";
        if (this.iCaleFiedMap != null) {
            fixFieldKey = this.iCaleFiedMap.getFieldByCalcF(pcFieldName);
        }
        if (fixFieldKey == null || StringUtils.isBlank((CharSequence)fixFieldKey)) {
            return;
        }
        String pcEntryKey = context.getPcEntryName();
        DynamicObject pcEntityData = context.getCalculatedResult();
        int rowIndex = context.getRowIndex();
        DynamicObject entryData = null;
        if (StringUtils.isNotBlank((CharSequence)pcEntryKey)) {
            DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(context.getPcEntryName());
            entryData = (DynamicObject)entryDatas.get(rowIndex);
        }
        switch (fixFieldKey) {
            case "materialcfg": {
                this.changeMaterialCFG(entryData);
                break;
            }
            case "qty": {
                this.changeQty(context);
                break;
            }
            case "unit": {
                this.changeUnit(context, entryData);
                break;
            }
        }
    }

    private void changeQty(PropertyChangedContext context) {
        DynamicObject calculatedResult = context.getCalculatedResult();
        String pcFieldName = context.getPcFieldName();
        BigDecimal newValue = (BigDecimal)context.getNewValue();
        BigDecimal oldValue = (BigDecimal)context.getOldValue();
        int rowIndex = context.getRowIndex();
        DynamicObjectCollection entryList = calculatedResult.getDynamicObjectCollection(context.getPcEntryName());
        DynamicObject changeEntry = (DynamicObject)entryList.get(context.getRowIndex());
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(newValue) > 0) {
            changeEntry.set(pcFieldName, (Object)oldValue);
            context.setNewValue((Object)oldValue);
        } else {
            changeEntry.set(pcFieldName, (Object)newValue);
            ChangedField entryPropArgs = new ChangedField(pcFieldName, rowIndex);
            calculatedResult = QmcBillCalculateHelper.calcMainEntry((String)context.getPcEntryName(), (DynamicObject)calculatedResult, Collections.singletonList(entryPropArgs), (ICaleFiedMap)this.iCaleFiedMap);
            context.setCalculatedResult(calculatedResult);
        }
    }

    private void changeMaterialCFG(DynamicObject entryData) {
        if (entryData == null) {
            return;
        }
        this.clearChangeMaterialVal(entryData);
        this.setMaterialDef(entryData);
    }

    private void changeUnit(PropertyChangedContext context, DynamicObject entryData) {
        if (entryData == null) {
            return;
        }
        DynamicObject calculatedResult = context.getCalculatedResult();
        int rowIndex = context.getRowIndex();
        String pcQtyField = this.iCaleFiedMap.getFieldByFixF("qty");
        if (StringUtils.isNotBlank((CharSequence)pcQtyField)) {
            ChangedField entryPropArgs = new ChangedField(pcQtyField, rowIndex);
            calculatedResult = QmcBillCalculateHelper.calcMainEntry((String)context.getPcEntryName(), (DynamicObject)calculatedResult, Collections.singletonList(entryPropArgs), (ICaleFiedMap)this.iCaleFiedMap);
            context.setCalculatedResult(calculatedResult);
        }
    }

    private void clearChangeMaterialVal(DynamicObject entryData) {
        for (String fixField : fixFields) {
            String pcfield = this.iCaleFiedMap.getFieldByFixF(fixField);
            if (!StringUtils.isNotBlank((CharSequence)pcfield)) continue;
            entryData.set(pcfield, null);
        }
    }

    private void setMaterialDef(DynamicObject entryData) {
        String pcMaterialcfg = this.iCaleFiedMap.getFieldByFixF("materialcfg");
        DynamicObject pcMaterialcfgObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)pcMaterialcfg);
        if (pcMaterialcfgObj == null) {
            return;
        }
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)pcMaterialcfgObj, (String)"masterid");
        if (materialidObj == null) {
            return;
        }
        String pcMaterialid = this.iCaleFiedMap.getFieldByFixF("materialid");
        if (pcMaterialid != null) {
            entryData.set(pcMaterialid, (Object)materialidObj);
        }
        String pcUnit = this.iCaleFiedMap.getFieldByFixF("unit");
        DynamicObject unitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)materialidObj, (String)"baseunit");
        if (unitObj != null) {
            entryData.set(pcUnit, (Object)unitObj);
        }
        String pcBaseUnit = this.iCaleFiedMap.getFieldByFixF("baseunit");
        if (unitObj != null) {
            entryData.set(pcBaseUnit, (Object)unitObj);
        }
    }
}

