/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.handler.inspect;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.mobqc.common.util.DynamicObjDataOpUtils;
import kd.qmc.mobqc.formplugin.handler.AbstractQmcBillChangedHandler;
import kd.qmc.qcbd.business.commonmodel.helper.InspectProMatchServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.SampleSchemServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectServiceHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class InspectBillChangedHandler
extends AbstractQmcBillChangedHandler {
    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        String pcFieldName = context.getPcFieldName();
        int rowIndex = context.getRowIndex();
        String pcEntryKey = context.getPcEntryName();
        DynamicObject pcEntityData = context.getCalculatedResult();
        DynamicObject entryData = new DynamicObject();
        boolean srcByApply = false;
        if (StringUtils.isNotBlank((CharSequence)pcEntryKey)) {
            DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(context.getPcEntryName());
            List applyBillEntityNames = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_inspecapplypbill"});
            srcByApply = entryDatas.stream().anyMatch(o -> applyBillEntityNames.contains(o.getString("srcbillentity")));
            entryData = (DynamicObject)entryDatas.get(rowIndex);
            if (InspectProDimenHelper.getBillFieldByType((String)context.getPcEntityName(), (DynamicObject)pcEntityData.getDynamicObject("transactype")).contains(pcFieldName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)pcFieldName)) {
                HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
                rowIndexSet.add(rowIndex);
                InspectProMatchServiceHelper.matchBillPro((String)"inspect", (DynamicObject)pcEntityData, rowIndexSet);
                this.afterMatchBillPro(pcEntityData, entryData, rowIndex, srcByApply);
            }
        }
        switch (pcFieldName) {
            case "materialcfg": {
                this.changeMaterialcfg(context, pcEntityData, entryData, srcByApply);
                break;
            }
            case "materialqty": {
                this.changeMaterialQty(context, entryData);
                break;
            }
            case "unitfield": {
                this.unitChange(entryData);
                break;
            }
            case "sampscheme": {
                SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)entryData);
                break;
            }
            case "qualiqty": 
            case "unqualiqty": {
                this.changeJudQty(context, entryData);
                break;
            }
            case "inspectionstd": {
                InspectStdHelper.inspectionstdChange((DynamicObject)pcEntityData, null, (Object)entryData.get("inspectionstd"), (int)rowIndex);
                break;
            }
            case "rinsqty": {
                InspectServiceHelper.rinsQtyPropChange((DynamicObject)pcEntityData, (Object)entryData.get("rinsqty"), (int)rowIndex);
                break;
            }
            case "sampqualqty": {
                InspectServiceHelper.setBaseqty((String)"sampqualqty", (String)"basesampqlyqty", (DynamicObject)entryData, new HashMap(16));
                InspectServiceHelper.refreshSamplingResult((DynamicObject)entryData);
                break;
            }
            case "samunqualqty": {
                InspectServiceHelper.setBaseqty((String)"samunqualqty", (String)"basesampuqlyqty", (DynamicObject)entryData, new HashMap(16));
                InspectServiceHelper.refreshSamplingResult((DynamicObject)entryData);
                break;
            }
            case "transactype": {
                this.transacTypeChanged(context, pcEntityData);
                break;
            }
        }
    }

    private void transacTypeChanged(PropertyChangedContext context, DynamicObject pcEntityData) {
        DynamicObjectCollection matEntrys = pcEntityData.getDynamicObjectCollection("matintoentity");
        int size = matEntrys.size();
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            rowIndexSet.add(i);
        }
        if (TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)((DynamicObject)context.getOldValue()), (DynamicObject)((DynamicObject)context.getNewValue()))) {
            InspectProMatchServiceHelper.matchBillPro((String)"inspect", (DynamicObject)pcEntityData, rowIndexSet);
            List applyBillEntityNames = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_inspecapplypbill"});
            boolean srcByApply = matEntrys.stream().anyMatch(o -> applyBillEntityNames.contains(o.getString("srcbillentity")));
            for (Integer rowIndex : rowIndexSet) {
                this.afterMatchBillPro(pcEntityData, (DynamicObject)matEntrys.get(rowIndex.intValue()), rowIndex, srcByApply);
            }
        }
        for (Integer matRowIndex : rowIndexSet) {
            SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)((DynamicObject)matEntrys.get(matRowIndex.intValue())));
        }
    }

    private void changeMaterialcfg(PropertyChangedContext context, DynamicObject pcEntityData, DynamicObject entryData, boolean srcByApply) {
        int rowIndex = context.getRowIndex();
        if (entryData == null) {
            return;
        }
        this.clearChangeMaterialVal(entryData);
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
        rowIndexSet.add(rowIndex);
        InspectProMatchServiceHelper.matchBillPro((String)"inspect", (DynamicObject)pcEntityData, rowIndexSet);
        this.afterMatchBillPro(pcEntityData, entryData, rowIndex, srcByApply);
    }

    private void afterMatchBillPro(DynamicObject pcEntityData, DynamicObject entryData, int rowIndex, boolean srcByApply) {
        if (!srcByApply || !pcEntityData.getBoolean("joininspectflag")) {
            InspectStdHelper.inspectionstdChange((DynamicObject)pcEntityData, null, (Object)entryData.get("inspectionstd"), (int)rowIndex);
        }
        DynamicObjectCollection projEntrys = entryData.getDynamicObjectCollection("inspsubentity");
        for (int i = 0; i < projEntrys.size(); ++i) {
            SampleSchemServiceHelper.updateProjSamp((int)rowIndex, (int)i, (DynamicObject)pcEntityData);
        }
        SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)entryData);
        this.caleJudQty(entryData, "qualiqty");
    }

    private void changeMaterialQty(PropertyChangedContext context, DynamicObject entryData) {
        if (entryData == null) {
            return;
        }
        DynamicObject pcEntityData = context.getCalculatedResult();
        SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)entryData);
        DynamicObjDataOpUtils.setValEmpty((DynamicObject)entryData, (String[])new String[]{"qualiqty", "basequaliqty", "unqualiqty", "baseunqlyqty"});
        BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
        entryData.set("qualiqty", (Object)materialQty);
        this.caleJudQty(entryData, "qualiqty");
        int matRowIndex = context.getRowIndex();
        BigDecimal maxSampQty = ((DynamicObject)pcEntityData.getDynamicObjectCollection("matintoentity").get(matRowIndex)).getBigDecimal("rinsqty");
        InspectServiceHelper.updateSampAndProjSampQtyCommon((int)matRowIndex, (DynamicObject)pcEntityData, (BigDecimal)maxSampQty, (Boolean)Boolean.TRUE);
    }

    private void changeJudQty(PropertyChangedContext context, DynamicObject entryData) {
        if (entryData == null) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        Boolean isReBackVal = Boolean.FALSE;
        BigDecimal newValue = (BigDecimal)context.getNewValue();
        BigDecimal oldValue = (BigDecimal)context.getOldValue();
        if (BigDecimal.ZERO.compareTo(newValue) > 0) {
            isReBackVal = Boolean.TRUE;
        }
        BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
        BigDecimal changeQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)pcFieldName);
        if (changeQty.compareTo(materialQty) > 0) {
            isReBackVal = Boolean.TRUE;
        }
        if (isReBackVal.booleanValue()) {
            entryData.set(pcFieldName, (Object)oldValue);
            context.setNewValue((Object)oldValue);
            return;
        }
        this.caleJudQty(entryData, pcFieldName);
    }

    private void caleJudQty(DynamicObject entryData, String fieldName) {
        if (entryData == null) {
            return;
        }
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"materialid");
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"unitfield");
        DynamicObject baseunitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"baseunit");
        BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
        if (materialidObj == null || unitfieldObj == null || baseunitObj == null) {
            return;
        }
        BigDecimal changeQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)fieldName);
        BigDecimal qtyVal = BigDecimalUtil.toBigDecimal((Object)changeQty);
        if (qtyVal.compareTo(materialQty) > 0) {
            changeQty = materialQty;
            entryData.set(fieldName, (Object)changeQty);
        } else if (qtyVal.compareTo(BigDecimal.ZERO) < 0) {
            changeQty = BigDecimal.ZERO;
            entryData.set(fieldName, (Object)changeQty);
        }
        switch (fieldName) {
            case "qualiqty": {
                BigDecimal unQuliQtyVal = materialQty.subtract(qtyVal);
                if (unQuliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    unQuliQtyVal = BigDecimal.ZERO;
                }
                entryData.set("unqualiqty", (Object)unQuliQtyVal);
                break;
            }
            case "unqualiqty": {
                BigDecimal quliQtyVal = materialQty.subtract(qtyVal);
                if (quliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    quliQtyVal = BigDecimal.ZERO;
                }
                entryData.set("qualiqty", (Object)quliQtyVal);
                break;
            }
        }
        this.caleBaseQty(entryData);
    }

    private void caleBaseQty(DynamicObject entryData) {
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"materialid");
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"unitfield");
        DynamicObject baseunitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"baseunit");
        BigDecimal baseqty = BigDecimal.ZERO;
        BigDecimal basequaliqty = BigDecimal.ZERO;
        BigDecimal baseunqlyqty = BigDecimal.ZERO;
        HashMap cacheCovertQtyMap = new HashMap(16);
        if (materialidObj != null && unitfieldObj != null && baseunitObj != null) {
            BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
            BigDecimal qualiqty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"qualiqty");
            BigDecimal unqualiqty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"unqualiqty");
            baseqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)materialQty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            basequaliqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)qualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            baseunqlyqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)unqualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
        }
        entryData.set("baseqty", (Object)baseqty);
        entryData.set("basequaliqty", (Object)basequaliqty);
        entryData.set("baseunqlyqty", (Object)baseunqlyqty);
    }

    private void clearChangeMaterialVal(DynamicObject entryData) {
        entryData.set("rinsqty", null);
        entryData.set("qualiqty", null);
        entryData.set("basequaliqty", null);
        entryData.set("unqualiqty", null);
        entryData.set("baseunqlyqty", null);
        entryData.set("samplingresult", null);
        entryData.set("inspectionstd", null);
        this.clearPropData(entryData, "supplier");
    }

    private void clearPropData(DynamicObject entryData, String ... propNames) {
        for (String propName : propNames) {
            boolean containsProperty = entryData.containsProperty(propName);
            if (!containsProperty) continue;
            entryData.set(propName, null);
        }
    }

    private void unitChange(DynamicObject entryData) {
        this.caleBaseQty(entryData);
        InspectServiceHelper.setBaseqty((String)"sampqualqty", (String)"basesampqlyqty", (DynamicObject)entryData, new HashMap(16));
        InspectServiceHelper.setBaseqty((String)"samunqualqty", (String)"basesampuqlyqty", (DynamicObject)entryData, new HashMap(16));
    }
}

