/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.handler.inspect.measureval;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.mobqc.formplugin.handler.AbstractQmcBillSubChangedHandler;
import kd.qmc.qcbd.business.commonmodel.helper.SampleSchemServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectServiceHelper;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class InspectItemChangedHandler
extends AbstractQmcBillSubChangedHandler {
    private boolean inspectDeal = true;

    public InspectItemChangedHandler(IFormView mobView) {
        super(mobView);
    }

    public void setInspectDeal(boolean inspectDeal) {
        this.inspectDeal = inspectDeal;
    }

    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        if (context.isMain()) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        List entryMappingIndices = context.getVisitingContext().getEntryMappingIndices();
        if (entryMappingIndices.size() < 2) {
            return;
        }
        DynamicObject pcEntityData = context.getCalculatedResult();
        EntryMappingIndex entryMappingIndex = (EntryMappingIndex)entryMappingIndices.get(0);
        String pcEntryName = entryMappingIndex.getPcEntryName();
        int pcEntryIndex = entryMappingIndex.getEntryIndex();
        DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(pcEntryName);
        DynamicObject pcEntryData = (DynamicObject)entryDatas.get(pcEntryIndex);
        EntryMappingIndex subentryMappingIndex = (EntryMappingIndex)entryMappingIndices.get(1);
        String pcSubEntryName = subentryMappingIndex.getPcEntryName();
        int pcSubEnryIndex = subentryMappingIndex.getEntryIndex();
        DynamicObjectCollection subEntryDatas = pcEntryData.getDynamicObjectCollection(pcSubEntryName);
        DynamicObject inspSubRow = (DynamicObject)subEntryDatas.get(pcSubEnryIndex);
        switch (pcFieldName) {
            case "projsamp": {
                this.projSampChange(pcEntityData, pcEntryIndex, pcSubEnryIndex);
                break;
            }
            case "projsampqty": {
                this.projSampQtyChange(pcEntryData, inspSubRow);
                break;
            }
            case "projqualifiyqty": 
            case "projunqualifiyqty": {
                InspectServiceHelper.setProjCkresult((DynamicObject)inspSubRow, (BigDecimal)inspSubRow.getBigDecimal("projqualifiyqty"), (BigDecimal)inspSubRow.getBigDecimal("projunqualifiyqty"));
                break;
            }
            case "specvalue": {
                InspectServiceHelper.dealSpecValue((DynamicObject)inspSubRow, (String)pcFieldName);
                if (!this.inspectDeal) break;
                InspectServiceHelper.deleteSubMeasures((DynamicObject)pcEntityData, (int)pcEntryIndex, (int)pcSubEnryIndex);
                break;
            }
            case "inspectionitem": 
            case "checkitems": {
                this.inspectionItemChange(pcEntityData, pcEntryIndex, pcSubEnryIndex, inspSubRow);
                break;
            }
            case "normtype": {
                this.normTypeChange(pcEntityData, pcEntryIndex, pcSubEnryIndex, inspSubRow);
                break;
            }
            case "matchflag": {
                this.matchFlagChange(pcEntityData, pcEntryIndex, pcSubEnryIndex, inspSubRow);
                break;
            }
            case "topvalue": 
            case "downvalue": {
                if (!this.inspectDeal) break;
                InspectServiceHelper.deleteSubMeasures((DynamicObject)pcEntityData, (int)pcEntryIndex, (int)pcSubEnryIndex);
                break;
            }
        }
    }

    private void inspectionItemChange(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex, DynamicObject inspSubRow) {
        inspSubRow.set("normtype", null);
        inspSubRow.set("projsamp", null);
        inspSubRow.set("matchflag", null);
        inspSubRow.set("specvalue", (Object)"");
        inspSubRow.set("topvalue", null);
        inspSubRow.set("downvalue", null);
        if (this.inspectDeal) {
            InspectItemChangedHandler.setInspectItem(pcEntityData, pcEntryIndex, pcSubEnryIndex, inspSubRow);
        } else {
            InspectItemChangedHandler.setApplyItem(pcEntityData, pcEntryIndex, pcSubEnryIndex, inspSubRow);
        }
    }

    private static void setInspectItem(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex, DynamicObject inspSubRow) {
        inspSubRow.set("projsampqty", (Object)0);
        InspectServiceHelper.deleteSubMeasures((DynamicObject)pcEntityData, (int)pcEntryIndex, (int)pcSubEnryIndex);
        DynamicObject inspectionItem = inspSubRow.getDynamicObject("inspectionitem");
        if (null != inspectionItem) {
            DynamicObject inspectionItemObj = BusinessDataServiceHelper.loadSingle((Object)inspectionItem.getPkValue(), (String)"qcbd_inspectionitems");
            DynamicObjectCollection entryEntity = inspectionItemObj.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) {
                return;
            }
            inspSubRow.set("inspectioncontent", (Object)((DynamicObject)entryEntity.get(0)).getString("checkcontent"));
            inspSubRow.set("keyquality", (Object)((DynamicObject)entryEntity.get(0)).getString("keyquality"));
            int size = entryEntity.size();
            if (size > 1) {
                DynamicObjectCollection inspSubEntry = ((DynamicObject)pcEntityData.getDynamicObjectCollection("matintoentity").get(pcEntryIndex)).getDynamicObjectCollection("inspsubentity");
                DynamicObjectType dynamicObjectType = inspSubEntry.getDynamicObjectType();
                for (int i = 1; i < size; ++i) {
                    DynamicObject tempRow = new DynamicObject(dynamicObjectType);
                    tempRow.set("inspectionitem", (Object)inspectionItem);
                    tempRow.set("inspectioncontent", (Object)((DynamicObject)entryEntity.get(i)).getString("checkcontent"));
                    tempRow.set("keyquality", (Object)((DynamicObject)entryEntity.get(i)).getString("keyquality"));
                    tempRow.set("uquuid", (Object)Uuid16.create().toString());
                    tempRow.set("seq", (Object)(inspSubRow.getInt("seq") + i));
                    inspSubEntry.add(pcSubEnryIndex + i, tempRow);
                }
                int inspSubSize = inspSubEntry.size();
                for (int i = pcEntryIndex + size; i < inspSubSize; ++i) {
                    ((DynamicObject)inspSubEntry.get(i)).set("seq", (Object)(i + 1));
                }
            }
        }
    }

    private static void setApplyItem(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex, DynamicObject inspSubRow) {
        DynamicObject inspectionItem = inspSubRow.getDynamicObject("checkitems");
        if (null != inspectionItem) {
            DynamicObject inspectionItemObj = BusinessDataServiceHelper.loadSingle((Object)inspectionItem.getPkValue(), (String)"qcbd_inspectionitems");
            DynamicObjectCollection entryEntity = inspectionItemObj.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) {
                return;
            }
            inspSubRow.set("checkcontent", (Object)((DynamicObject)entryEntity.get(0)).getString("checkcontent"));
            inspSubRow.set("keyquality", (Object)((DynamicObject)entryEntity.get(0)).getString("keyquality"));
            int size = entryEntity.size();
            if (size > 1) {
                DynamicObjectCollection inspSubEntry = ((DynamicObject)pcEntityData.getDynamicObjectCollection("materialentry").get(pcEntryIndex)).getDynamicObjectCollection("subprojentry");
                DynamicObjectType dynamicObjectType = inspSubEntry.getDynamicObjectType();
                for (int i = 1; i < size; ++i) {
                    DynamicObject tempRow = new DynamicObject(dynamicObjectType);
                    tempRow.set("checkitems", (Object)inspectionItem);
                    tempRow.set("checkcontent", (Object)((DynamicObject)entryEntity.get(i)).getString("checkcontent"));
                    tempRow.set("keyquality", (Object)((DynamicObject)entryEntity.get(i)).getString("keyquality"));
                    tempRow.set("seq", (Object)(inspSubRow.getInt("seq") + i));
                    inspSubEntry.add(pcSubEnryIndex + i, tempRow);
                }
                int inspSubSize = inspSubEntry.size();
                for (int i = pcEntryIndex + size; i < inspSubSize; ++i) {
                    ((DynamicObject)inspSubEntry.get(i)).set("seq", (Object)(i + 1));
                }
            }
        }
    }

    private void matchFlagChange(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex, DynamicObject inspSubRow) {
        inspSubRow.set("specvalue", (Object)"");
        inspSubRow.set("topvalue", null);
        inspSubRow.set("downvalue", null);
        if (this.inspectDeal) {
            InspectServiceHelper.deleteSubMeasures((DynamicObject)pcEntityData, (int)pcEntryIndex, (int)pcSubEnryIndex);
        }
    }

    private void normTypeChange(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex, DynamicObject inspSubRow) {
        inspSubRow.set("matchflag", null);
        inspSubRow.set("specvalue", (Object)"");
        inspSubRow.set("topvalue", null);
        inspSubRow.set("downvalue", null);
        if (this.inspectDeal) {
            InspectServiceHelper.deleteSubMeasures((DynamicObject)pcEntityData, (int)pcEntryIndex, (int)pcSubEnryIndex);
        }
    }

    private void projSampQtyChange(DynamicObject pcEntryData, DynamicObject inspSubRow) {
        BigDecimal rinsQty = pcEntryData.getBigDecimal("rinsqty");
        BigDecimal projSampQty = inspSubRow.getBigDecimal("projsampqty");
        if (projSampQty.compareTo(rinsQty) > 0) {
            pcEntryData.set("rinsqty", (Object)projSampQty);
        }
    }

    private void projSampChange(DynamicObject pcEntityData, int pcEntryIndex, int pcSubEnryIndex) {
        MserviceResult result;
        String retMsg;
        if (this.inspectDeal && StringUtils.isNotEmpty((String)(retMsg = (result = SampleSchemServiceHelper.updateProjSamp((int)pcEntryIndex, (int)pcSubEnryIndex, (DynamicObject)pcEntityData)).getRetMsg()))) {
            this.getMobView().showTipNotification(retMsg);
        }
    }
}

