/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.handler.inspectapply;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.mobqc.business.design.factory.BillCalcFactory;
import kd.qmc.mobqc.business.design.factory.ClacManager;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.design.icalefield.ApplyCaleFiedMap;
import kd.qmc.mobqc.formplugin.handler.AbstractQmcBillChangedHandler;
import kd.qmc.qcbd.business.commonmodel.helper.InspectProMatchServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.common.enums.InspectApplyEnum;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class InspectApplyBillChangedHandler
extends AbstractQmcBillChangedHandler {
    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        String pcFieldName = context.getPcFieldName();
        int rowIndex = context.getRowIndex();
        String pcEntryKey = context.getPcEntryName();
        DynamicObject pcEntityData = context.getCalculatedResult();
        ClacManager propChangedCalcManager = BillCalcFactory.createPropChangedCalcManager((String)context.getPcFieldName(), (ICaleFiedMap)new ApplyCaleFiedMap());
        if (propChangedCalcManager != null) {
            propChangedCalcManager.calculate(pcEntityData, rowIndex);
        }
        DynamicObject entryData = new DynamicObject();
        if (StringUtils.isNotBlank((CharSequence)pcEntryKey)) {
            DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(context.getPcEntryName());
            entryData = (DynamicObject)entryDatas.get(rowIndex);
            if (InspectProDimenHelper.getBillFieldByType((String)context.getPcEntityName(), (DynamicObject)pcEntityData.getDynamicObject("transactype")).contains(pcFieldName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)pcFieldName)) {
                HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
                rowIndexSet.add(rowIndex);
                InspectProMatchServiceHelper.matchBillPro((String)"apply", (DynamicObject)pcEntityData, rowIndexSet);
            }
        }
        switch (pcFieldName) {
            case "materialcfg": {
                this.changeMaterialcfg(context, pcEntityData, entryData);
                break;
            }
            case "unit": {
                this.unitChange(entryData);
                break;
            }
            case "transactype": {
                this.transacTypeChanged(context, pcEntityData);
                break;
            }
            case "inspecorg": {
                this.inspecorgChanged(context, pcEntityData);
                break;
            }
            case "inspectstd": {
                this.inspectStdChange(context, entryData);
                break;
            }
        }
    }

    private void transacTypeChanged(PropertyChangedContext context, DynamicObject pcEntityData) {
        DynamicObjectCollection matEntrys = pcEntityData.getDynamicObjectCollection("materialentry");
        int size = matEntrys.size();
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            rowIndexSet.add(i);
        }
        if (TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)((DynamicObject)context.getOldValue()), (DynamicObject)((DynamicObject)context.getNewValue()))) {
            InspectProMatchServiceHelper.matchBillPro((String)"apply", (DynamicObject)pcEntityData, rowIndexSet);
        }
    }

    private void inspecorgChanged(PropertyChangedContext context, DynamicObject pcEntityData) {
        DynamicObject inspectOrg = (DynamicObject)context.getNewValue();
        DynamicObjectCollection entrys = pcEntityData.getDynamicObjectCollection("materialentry");
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(16);
        HashMap deptsOfOrg = new HashMap(16);
        for (int i = 0; i < entrys.size(); ++i) {
            rowIndexSet.add(i);
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (Objects.nonNull(inspectOrg)) {
                boolean containUser;
                DynamicObject dept = entry.getDynamicObject("inspedeptid");
                DynamicObject inspector = entry.getDynamicObject("inspectorid");
                boolean containDept = InspectProMatchHelper.isContainDept((DynamicObject)inspectOrg, (DynamicObject)dept, deptsOfOrg);
                if (!containDept) {
                    entry.set("inspedeptid", null);
                }
                if (containUser = InspectProMatchHelper.isContainUser((DynamicObject)inspectOrg, (DynamicObject)inspector)) continue;
                entry.set("inspectorid", null);
                continue;
            }
            entry.set("inspedeptid", null);
            entry.set("inspectorid", null);
        }
        InspectProMatchServiceHelper.matchBillPro((String)"apply", (DynamicObject)pcEntityData, rowIndexSet);
    }

    private void changeMaterialcfg(PropertyChangedContext context, DynamicObject pcEntityData, DynamicObject entryData) {
        int rowIndex = context.getRowIndex();
        if (entryData == null) {
            return;
        }
        entryData.set("applyqty", null);
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
        rowIndexSet.add(rowIndex);
        InspectProMatchServiceHelper.matchBillPro((String)"apply", (DynamicObject)pcEntityData, rowIndexSet);
    }

    private void unitChange(DynamicObject entryData) {
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"materielid");
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"unit");
        DynamicObject baseunitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"baseunit");
        BigDecimal baseqty = BigDecimal.ZERO;
        HashMap cacheCovertQtyMap = new HashMap(16);
        if (materialidObj != null && unitfieldObj != null && baseunitObj != null) {
            BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"applyqty");
            baseqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)materialQty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
        }
        entryData.set("baseqty", (Object)baseqty);
    }

    private void inspectStdChange(PropertyChangedContext context, DynamicObject entryData) {
        DynamicObjectCollection projEntrys = entryData.getDynamicObjectCollection("subprojentry");
        DynamicObject inspectionstd = (DynamicObject)context.getNewValue();
        projEntrys.clear();
        InspectProjModel projModel = new InspectProjModel(false);
        projModel.setUnitField("unitid");
        InspectStdHelper.setProjEntryByStd((DynamicObject)inspectionstd, (DynamicObjectCollection)projEntrys, (InspectProjModel)projModel, (boolean)false);
        for (DynamicObject projEntry : projEntrys) {
            projEntry.set("joindept", null);
            projEntry.set("joininspector", null);
            if (!projEntry.getBoolean("isjoininspect")) continue;
            projEntry.set("joininspectstatus", (Object)InspectApplyEnum.JOININSPECTSTATUS_ENUM.P.name());
        }
    }
}

