/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.handler.joininspect;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.mobqc.formplugin.handler.AbstractQmcBillChangedHandler;
import kd.qmc.qcbd.business.commonmodel.helper.InspectProMatchServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.InspectStdHelper;
import kd.qmc.qcbd.business.commonmodel.helper.SampleSchemServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectServiceHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class JoinInspBillChangedHandler
extends AbstractQmcBillChangedHandler {
    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        String pcFieldName = context.getPcFieldName();
        int rowIndex = context.getRowIndex();
        String pcEntryKey = context.getPcEntryName();
        DynamicObject pcEntityData = context.getCalculatedResult();
        DynamicObject entryData = new DynamicObject();
        if (StringUtils.isNotBlank((CharSequence)pcEntryKey)) {
            DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(context.getPcEntryName());
            entryData = (DynamicObject)entryDatas.get(rowIndex);
            if (InspectProDimenHelper.getBillFieldByType((String)context.getPcEntityName(), (DynamicObject)pcEntityData.getDynamicObject("transactype")).contains(pcFieldName) && !StringUtils.equals((CharSequence)"biztype", (CharSequence)pcFieldName)) {
                HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
                rowIndexSet.add(rowIndex);
                InspectProMatchServiceHelper.matchBillPro((String)"joininsp", (DynamicObject)pcEntityData, rowIndexSet);
                this.afterMatchBillPro(pcEntityData, entryData, rowIndex);
            }
        }
        switch (pcFieldName) {
            case "materialcfg": {
                this.changeMaterialcfg(context, pcEntityData, entryData);
                break;
            }
            case "materialqty": {
                this.changeMaterialQty(context, entryData);
                break;
            }
            case "unitfield": {
                this.unitChange(entryData);
                break;
            }
            case "inspectionstd": {
                InspectStdHelper.inspectionstdChange((DynamicObject)pcEntityData, null, (Object)entryData.get("inspectionstd"), (int)rowIndex, (boolean)true);
                break;
            }
            case "rinsqty": {
                InspectServiceHelper.rinsQtyPropChange((DynamicObject)pcEntityData, (Object)entryData.get("rinsqty"), (int)rowIndex);
                break;
            }
            case "transactype": {
                this.transacTypeChanged(context, pcEntityData);
                break;
            }
        }
    }

    private void transacTypeChanged(PropertyChangedContext context, DynamicObject pcEntityData) {
        int i;
        DynamicObjectCollection matEntrys = pcEntityData.getDynamicObjectCollection("matintoentity");
        int size = matEntrys.size();
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(size);
        for (i = 0; i < size; ++i) {
            rowIndexSet.add(i);
        }
        if (TransacTypeHelper.isChangeDimenOfTransacType((DynamicObject)((DynamicObject)context.getOldValue()), (DynamicObject)((DynamicObject)context.getNewValue()))) {
            InspectProMatchServiceHelper.matchBillPro((String)"joininsp", (DynamicObject)pcEntityData, rowIndexSet);
            for (i = 0; i < size; ++i) {
                this.afterMatchBillPro(pcEntityData, (DynamicObject)matEntrys.get(i), i);
            }
        }
    }

    private void changeMaterialcfg(PropertyChangedContext context, DynamicObject pcEntityData, DynamicObject entryData) {
        int rowIndex = context.getRowIndex();
        if (entryData == null) {
            return;
        }
        this.clearChangeMaterialVal(entryData);
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(1);
        rowIndexSet.add(rowIndex);
        InspectProMatchServiceHelper.matchBillPro((String)"joininsp", (DynamicObject)pcEntityData, rowIndexSet);
        this.afterMatchBillPro(pcEntityData, entryData, rowIndex);
    }

    private void afterMatchBillPro(DynamicObject pcEntityData, DynamicObject entryData, int rowIndex) {
        InspectStdHelper.inspectionstdChange((DynamicObject)pcEntityData, null, (Object)entryData.get("inspectionstd"), (int)rowIndex, (boolean)true);
        SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)entryData);
        this.caleJudQty(entryData, "qualiqty");
    }

    private void changeMaterialQty(PropertyChangedContext context, DynamicObject entryData) {
        if (entryData == null) {
            return;
        }
        DynamicObject pcEntityData = context.getCalculatedResult();
        SampleSchemServiceHelper.SampSchemeChange((DynamicObject)pcEntityData, (DynamicObject)entryData);
        int matRowIndex = context.getRowIndex();
        BigDecimal maxSampQty = ((DynamicObject)pcEntityData.getDynamicObjectCollection("matintoentity").get(matRowIndex)).getBigDecimal("rinsqty");
        InspectServiceHelper.updateSampAndProjSampQtyCommon((int)matRowIndex, (DynamicObject)pcEntityData, (BigDecimal)maxSampQty, (Boolean)Boolean.TRUE);
    }

    private void caleJudQty(DynamicObject entryData, String fieldName) {
        if (entryData == null) {
            return;
        }
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"materialid");
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"unitfield");
        DynamicObject baseunitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"baseunit");
        BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
        if (materialidObj == null || unitfieldObj == null || baseunitObj == null) {
            return;
        }
        BigDecimal changeQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)fieldName);
        BigDecimal qtyVal = BigDecimalUtil.toBigDecimal((Object)changeQty);
        if (qtyVal.compareTo(materialQty) > 0) {
            changeQty = materialQty;
            entryData.set(fieldName, (Object)changeQty);
        } else if (qtyVal.compareTo(BigDecimal.ZERO) < 0) {
            changeQty = BigDecimal.ZERO;
            entryData.set(fieldName, (Object)changeQty);
        }
        switch (fieldName) {
            case "qualiqty": {
                BigDecimal unQuliQtyVal = materialQty.subtract(qtyVal);
                if (unQuliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    unQuliQtyVal = BigDecimal.ZERO;
                }
                entryData.set("unqualiqty", (Object)unQuliQtyVal);
                break;
            }
            case "unqualiqty": {
                BigDecimal quliQtyVal = materialQty.subtract(qtyVal);
                if (quliQtyVal.compareTo(BigDecimal.ZERO) < 0) {
                    quliQtyVal = BigDecimal.ZERO;
                }
                entryData.set("qualiqty", (Object)quliQtyVal);
                break;
            }
        }
        this.caleBaseQty(entryData);
    }

    private void caleBaseQty(DynamicObject entryData) {
        DynamicObject materialidObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"materialid");
        DynamicObject unitfieldObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"unitfield");
        DynamicObject baseunitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)"baseunit");
        BigDecimal baseqty = BigDecimal.ZERO;
        BigDecimal basequaliqty = BigDecimal.ZERO;
        BigDecimal baseunqlyqty = BigDecimal.ZERO;
        HashMap cacheCovertQtyMap = new HashMap(16);
        if (materialidObj != null && unitfieldObj != null && baseunitObj != null) {
            BigDecimal materialQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"materialqty");
            BigDecimal qualiqty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"qualiqty");
            BigDecimal unqualiqty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryData, (String)"unqualiqty");
            baseqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)materialQty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            basequaliqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)qualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
            baseunqlyqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)materialidObj), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)unitfieldObj), (BigDecimal)unqualiqty, (DynamicObject)baseunitObj, cacheCovertQtyMap);
        }
        entryData.set("baseqty", (Object)baseqty);
        entryData.set("basequaliqty", (Object)basequaliqty);
        entryData.set("baseunqlyqty", (Object)baseunqlyqty);
    }

    private void clearChangeMaterialVal(DynamicObject entryData) {
        entryData.set("rinsqty", null);
        entryData.set("inspectionstd", null);
        this.clearPropData(entryData, "supplier");
    }

    private void clearPropData(DynamicObject entryData, String ... propNames) {
        for (String propName : propNames) {
            boolean containsProperty = entryData.containsProperty(propName);
            if (!containsProperty) continue;
            entryData.set(propName, null);
        }
    }

    private void unitChange(DynamicObject entryData) {
        this.caleBaseQty(entryData);
        InspectServiceHelper.setBaseqty((String)"sampqualqty", (String)"basesampqlyqty", (DynamicObject)entryData, new HashMap(16));
        InspectServiceHelper.setBaseqty((String)"samunqualqty", (String)"basesampuqlyqty", (DynamicObject)entryData, new HashMap(16));
    }
}

