/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.inspect;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.design.icalefield.InspectCaleFiedMap;
import kd.qmc.mobqc.business.qmctpl.MobQmcBillEntryPlugin;
import kd.qmc.mobqc.common.util.InspectConfigUtils;
import kd.qmc.mobqc.formplugin.handler.inspect.InspectBillChangedHandler;
import kd.qmc.mobqc.formplugin.inspect.IMobInspectSubEntry;
import kd.qmc.qcbd.business.commonmodel.helper.SampleSchemServiceHelper;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;

public abstract class InspectBillEntryPlugin
extends MobQmcBillEntryPlugin
implements TabSelectListener,
IMobInspectSubEntry {
    private static final String[] INSPECT_FIELD_KEYS = new String[]{"transactype", "qualiqty", "unqualiqty", "samplingresult", "inspectionstd", "sampscheme", "rinsqty", "sampqualqty", "samunqualqty", "supplier"};

    public InspectBillEntryPlugin() {
        this.registerHandler();
    }

    protected final void registerHandler() {
        InspectBillChangedHandler handler = new InspectBillChangedHandler();
        handler.initChangedHandler(this.getCaleFieldMap());
        this.registerPropertyChangedQmcHandler(handler);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public List<String> getFieldKeys() {
        LinkedList<String> fieldKeys = new LinkedList<String>();
        fieldKeys.addAll(super.getFieldKeys());
        this.addFieldKeys(fieldKeys, INSPECT_FIELD_KEYS);
        return fieldKeys;
    }

    protected ICaleFiedMap getCaleFieldMap() {
        return new InspectCaleFiedMap();
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey;
        super.tabSelected(evt);
        switch (tabKey = evt.getTabKey()) {
            case "tabbasicinfo": {
                IPageCache pageCache = this.getPageCache();
                String row = pageCache.get("row");
                if (row == null) {
                    int entryEntityIndex = this.getView().getParentView().getModel().getEntryCurrentRowIndex(this.getEntryEntity());
                    row = String.valueOf(entryEntityIndex);
                    pageCache.put("row", row);
                }
                DataChangedHandlerHelper.setEntryPageFieldsFromCache((AbstractMobFormPlugin)this, (int)Long.valueOf(row).intValue());
                break;
            }
            case "tabinspinfo": {
                String inputType = InspectConfigUtils.getInputType((Long)RequestContext.get().getCurrUserId());
                String formId = "1".equals(inputType) ? this.getInspectInspDetailFormKey() : this.getSampDetailFormKey();
                this.selectTabSubInfo("flexinspinfo", formId);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        DynamicObject bill;
        super.afterBindData(e);
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"transactype");
        if (null == transactype || !transactype.getBoolean("inspsampprojflag")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabinspinfo"});
        }
        if ((bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this)).getBoolean("joininspectflag")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inspectionstd"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "qty": {
                this.qtyBeforeFieldPostback(e);
                break;
            }
            case "rinsqty": {
                this.rinsQtyBeforeFieldPostback(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabbasicinfo");
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        block6: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            switch (name) {
                case "sampscheme": {
                    this.sampSchemeBeforePropChange(changeData);
                    continue block6;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void qtyBeforeFieldPostback(BeforeFieldPostBackEvent e) {
        IDataModel model = this.getModel();
        DynamicObject sampScheme = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"sampscheme");
        BigDecimal qty = BigDecimalUtil.toBigDecimal((Object)e.getValue());
        this.validSampQty(sampScheme, qty);
    }

    private void sampSchemeBeforePropChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        Object newValue = changeData.getNewValue();
        DynamicObject sampScheme = null;
        if (newValue instanceof DynamicObject) {
            sampScheme = (DynamicObject)newValue;
        }
        BigDecimal qty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"qty");
        this.validSampQty(sampScheme, qty);
    }

    private void validSampQty(DynamicObject sampScheme, BigDecimal qty) {
        IDataModel model = this.getModel();
        DynamicObject unit = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"unit");
        DynamicObject transactypeObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactype");
        String rule = "";
        if (transactypeObj != null) {
            rule = transactypeObj.getString("sampnumrule");
        }
        CkSampleCaleResModel resModel = SampleSchemServiceHelper.getCkSampleCaleResModel((DynamicObject)sampScheme, (BigDecimal)qty, (DynamicObject)unit, (String)rule);
        BigDecimal rinsQty = resModel.getRinsQty();
        this.validRinsQty(rinsQty, qty);
    }

    private void rinsQtyBeforeFieldPostback(BeforeFieldPostBackEvent e) {
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimalNull((Object)e.getValue());
        BigDecimal qty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"qty");
        this.validRinsQty(rinsQty, qty);
    }

    private void validRinsQty(BigDecimal rinsQty, BigDecimal qty) {
        if (rinsQty.compareTo(qty) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6837\u672c\u6570\u91cf\u5927\u4e8e\u7269\u6599\u6570\u91cf\u3002", (String)"InspectBillEntryPlugin_0", (String)"qmc-mobqc-formplugin", (Object[])new Object[0]));
        }
    }
}

