/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.inspect;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.design.icalefield.InspectCaleFiedMap;
import kd.qmc.mobqc.business.qmctpl.MobQmcBillInfoPlugin;
import kd.qmc.mobqc.formplugin.handler.inspect.InspectBillChangedHandler;
import kd.qmc.mobqc.formplugin.handler.inspect.InspectBillNewEntryHandler;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;

public class InspectBillInfoPlugin
extends MobQmcBillInfoPlugin {
    public InspectBillInfoPlugin() {
        this.registerEntryRowAddedHandler((IEntryRowAddedHandler)new InspectBillNewEntryHandler());
        this.registerPropertyChangedHandler(new InspectBillChangedHandler());
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    protected void handleQrCode(Object code) {
        super.handleQrCode(code);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    protected ICaleFiedMap getCaleFieldMap() {
        return new InspectCaleFiedMap();
    }

    public void cacheBillBaseInfo(IDataModel model, DynamicObject bill) {
        super.cacheBillBaseInfo(model, bill);
        IPageCache pageCache = this.getPageCache();
        String convertResultStr = pageCache.get("convertResult");
        if (StringUtils.isNotEmpty((String)convertResultStr)) {
            DynamicObject convertResult = this.curData[0];
            if (Objects.isNull(convertResult.getDynamicObject("transactype"))) {
                DynamicObject org = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org");
                DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"biztype");
                if (Objects.nonNull(org) && Objects.nonNull(bizType)) {
                    Long orgId = org.getLong("id");
                    Long bizTypeId = bizType.getLong("id");
                    DynamicObject firstTransacType = TransacTypeHelper.getFirstDefaultTransacType((Long)orgId, (Long)bizTypeId);
                    convertResult.set("transactype", (Object)firstTransacType);
                } else {
                    convertResult.set("transactype", null);
                }
            }
            InspectBillChangedHandler handler = new InspectBillChangedHandler();
            PropertyChangedContext context = new PropertyChangedContext(convertResult, this.getVisitingContext());
            context.setPcFieldName("transactype");
            handler.onPropertyChanged(context);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "config": {
                this.getView().getPageCache().put("unrefresh", "true");
                this.showForm("mobqc_inspect_config", "mobqc_inspect_config", new CloseCallBack((IFormPlugin)this, "inspectConfigCallid"));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        IPageCache pageCache = this.getView().getPageCache();
        if ("true".equalsIgnoreCase(pageCache.get("unrefresh"))) {
            pageCache.remove("unrefresh");
            return;
        }
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView storageView = this.getPcEntityStorageView();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)storageView, (String)this.getPcEntityKey());
        boolean isDraw = this.isDrawByBotp();
        if (isDraw) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"biztype"});
        }
        List applyBillEntityNames = MainEntityTypeUtil.getInheritChildNumberLst((String[])new String[]{"qcp_inspecapplypbill"});
        DynamicObjectCollection matEntry = pcEntityFromCache.getDynamicObjectCollection("matintoentity");
        for (DynamicObject entry : matEntry) {
            if (!applyBillEntityNames.contains(entry.getString("srcbillentity"))) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{"transactype"});
            break;
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionid = e.getActionId();
        super.closedCallBack(e);
        switch (actionid) {
            case "inspectConfigCallid": {
                this.getView().updateView();
            }
        }
    }
}

