/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin;

import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.opplugin.validator.BillSaveValidator;
import kd.qmc.qcbd.opplugin.validator.InSpecUniqueValidatorCommon;

public class BadDealMatSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("materielid");
        e.getFieldKeys().add("supplier");
        OppUtil.setFieldKeys((PreparePropertysEventArgs)e, (String[])new String[]{"billtype", "biztype", "transactype"});
        e.getFieldKeys().add("materialcfg");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("inspedepartment");
        e.getFieldKeys().add("inspector");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("newhandmode");
        e.getFieldKeys().add("handmethed");
        this.setSrcPreparePropertys(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) continue;
            for (DynamicObject d : dynamicObjectCollection) {
                if (d.getDynamicObject("materialcfg") != null && d.getDynamicObject("materielid") == null) {
                    d.set("materielid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)d.getDynamicObject("materialcfg").getDynamicObject("masterid").getPkValue(), (String)"bd_material"));
                }
                this.setOldHandmode(d);
            }
        }
    }

    private void setOldHandmode(DynamicObject entryObj) {
        DynamicObject newHandmode = entryObj.getDynamicObject("newhandmode");
        if (!Objects.isNull(newHandmode)) {
            String oldStyle = newHandmode.getString("oldbaddealstyle");
            entryObj.set("handmethed", (Object)oldStyle);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        Boolean importFlag = OppUtil.isImport((OperateOption)this.operateOption);
        for (DynamicObject billObj : dataEntities) {
            this.matchInspPro(billObj, inspectProGlobalCache);
            DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(0);
                if (!importFlag.booleanValue()) continue;
                entry.set("scsystem", null);
                entry.set("srcordertype", null);
                entry.set("srcordernum", null);
                entry.set("srcbillentity", null);
                entry.set("srcbillid", null);
                entry.set("srcbillentryid", null);
                entry.set("srcbillentryseq", null);
            }
        }
        e.setDataEntities(dataEntities);
    }

    private void matchInspPro(DynamicObject billObj, InspectProGlobalCache inspectProGlobalCache) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(billObj);
        args.setVolustionScene(InspectDealArgs.VOLUSTIONSCENE.OPERATE);
        if (OppUtil.isImport((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.IMPORT);
        } else if (OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.API);
        }
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("materialentry");
        voluationKeyModel.setInspectDeptKey("inspedepartment");
        voluationKeyModel.setInspectUserKey("inspector");
        if ((OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue() || OppUtil.isImport((OperateOption)this.operateOption).booleanValue() || DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)billObj).booleanValue()) && billObj.getDynamicObjectCollection("materialentry").size() > 0) {
            args.getRowIndexSet().add(0);
        }
        args.setDrawNow(DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)billObj));
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InSpecUniqueValidatorCommon());
        e.addValidator((AbstractValidator)new BillSaveValidator());
    }

    private void setSrcPreparePropertys(PreparePropertysEventArgs e) {
        String oprType = (String)this.operateMeta.get("type");
        Boolean isBillList = InspObjectHelper.isOperateOnList((OperateOption)this.getOption());
        if (!isBillList.booleanValue() && StringQMCUtil.inside((String)oprType, (String[])new String[]{"save", "submit"}).booleanValue()) {
            if (!e.getFieldKeys().contains("srcbillentryid")) {
                e.getFieldKeys().add("srcbillentryid");
            }
            if (!e.getFieldKeys().contains("srcbillentity")) {
                e.getFieldKeys().add("srcbillentity");
            }
            if (!e.getFieldKeys().contains("srcbillid")) {
                e.getFieldKeys().add("srcbillid");
            }
            if (!e.getFieldKeys().contains("srcordernum")) {
                e.getFieldKeys().add("srcordernum");
            }
            if (!e.getFieldKeys().contains("srcbillentryseq")) {
                e.getFieldKeys().add("srcbillentryseq");
            }
            if (!e.getFieldKeys().contains("chkobjid")) {
                e.getFieldKeys().add("chkobjid");
            }
            if (!e.getFieldKeys().contains("chkobjentryid")) {
                e.getFieldKeys().add("chkobjentryid");
            }
            if (!e.getFieldKeys().contains("scsystem")) {
                e.getFieldKeys().add("scsystem");
            }
            String seqKey = "materialentry.seq";
            if (!e.getFieldKeys().contains(seqKey)) {
                e.getFieldKeys().add(seqKey);
            }
            if (!e.getFieldKeys().contains("secondck")) {
                e.getFieldKeys().add("secondck");
            }
            if (!e.getFieldKeys().contains("baseunit")) {
                e.getFieldKeys().add("baseunit");
            }
        }
    }
}

