/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationApply;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.enums.BillcreTypeEnum;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.opplugin.validator.BillSaveValidator;
import kd.qmc.qcbd.opplugin.validator.InSpecApplySaveValidator;
import kd.qmc.qcbd.opplugin.validator.projentry.InsAppProjEntryValidator;

public class IncInspectionAppMatSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("materielid");
        e.getFieldKeys().add("supplier");
        OppUtil.setFieldKeys((PreparePropertysEventArgs)e, (String[])new String[]{"billtype", "biztype", "transactype"});
        e.getFieldKeys().add("materialcfg");
        e.getFieldKeys().add("inspecorg");
        e.getFieldKeys().add("inspedeptid");
        e.getFieldKeys().add("inspectorid");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("applyqty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("joininspectflag");
        e.getFieldKeys().add("inspectstd");
        e.getFieldKeys().add("isjoininspect");
        e.getFieldKeys().add("matchflag");
        e.getFieldKeys().add("specvalue");
        e.getFieldKeys().add("topvalue");
        e.getFieldKeys().add("downvalue");
        e.getFieldKeys().add("normtype");
        e.getFieldKeys().add("checkitems");
        e.getFieldKeys().add("checkcontent");
        this.setSrcPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InSpecApplySaveValidator());
        e.addValidator((AbstractValidator)new BillSaveValidator());
        e.addValidator((AbstractValidator)new InsAppProjEntryValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, DynamicObject> cacheUnitConvertMap = new HashMap<String, DynamicObject>(10);
        Boolean interFaceCheck = OppUtil.interFaceCheck((OperateOption)this.getOption());
        Boolean isImport = OppUtil.isImport((OperateOption)this.operateOption);
        Boolean isApi = OppUtil.isFromApi((OperateOption)this.operateOption);
        for (DynamicObject billObj : dataEntities) {
            DynamicObjectCollection matEntrys;
            DynamicObject transacType = billObj.getDynamicObject("transactype");
            if (DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)billObj).booleanValue() && Objects.isNull(transacType)) {
                Long orgId = billObj.getDynamicObject("org").getLong("id");
                DynamicObject biTypeDyo = billObj.getDynamicObject("biztype");
                if (Objects.nonNull(biTypeDyo)) {
                    transacType = TransacTypeHelper.getFirstDefaultTransacType((Long)orgId, (Long)biTypeDyo.getLong("id"));
                    billObj.set("transactype", (Object)transacType);
                }
            }
            if (Objects.nonNull(transacType)) {
                billObj.set("joininspectflag", (Object)transacType.getBoolean("joininspectflag"));
            }
            if ((matEntrys = billObj.getDynamicObjectCollection("materialentry")) == null || matEntrys.isEmpty()) continue;
            for (DynamicObject matEntry : matEntrys) {
                DynamicObject materialcfgObj = matEntry.getDynamicObject("materialcfg");
                DynamicObject materielidObj = matEntry.getDynamicObject("materielid");
                if (materialcfgObj != null && materielidObj == null) {
                    matEntry.set("materielid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)materialcfgObj.getDynamicObject("masterid").getPkValue(), (String)"bd_material"));
                }
                if (interFaceCheck.booleanValue()) {
                    this.setBaseUnitConvDef(matEntry, cacheUnitConvertMap);
                }
                if (isImport.booleanValue()) {
                    matEntry.set("scsystem", (Object)"qmc");
                }
                if (isApi.booleanValue()) {
                    if (matEntry.getLong("srcbillid") > 0L || StringUtils.isNotBlank((CharSequence)matEntry.getString("srcordernum"))) {
                        matEntry.set("srcunitid", matEntry.get("unit"));
                    }
                    billObj.set("billcretype", (Object)BillcreTypeEnum.API_CREATE.getValue());
                }
                if (billObj.getBoolean("joininspectflag")) continue;
                matEntry.getDynamicObjectCollection("subprojentry").clear();
                matEntry.set("inspectstd", null);
            }
        }
    }

    private void setBaseUnitConvDef(DynamicObject dyncObj, Map<String, DynamicObject> cacheUnitConvertMap) {
        DynamicObject baseUnitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dyncObj, (String)"baseunit");
        DynamicObject materialObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dyncObj, (String)"materielid");
        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)dyncObj, (String)"applyqty");
        BigDecimal baseQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)dyncObj, (String)"baseqty");
        if (baseUnitObj == null && materialObj != null) {
            baseUnitObj = materialObj.getDynamicObject("baseunit");
            dyncObj.set("baseunit", (Object)baseUnitObj);
        }
        if (qty.compareTo(BigDecimal.ZERO) >= 0 && baseQty.compareTo(BigDecimal.ZERO) == 0 && (baseQty = BaseUnitQtyConVertUtil.getBaseQty((DynamicObject)dyncObj, (String)"materielid", (String)"unit", (String)"applyqty", cacheUnitConvertMap)) != null) {
            dyncObj.set("baseqty", (Object)baseQty);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Boolean importFlag = OppUtil.isImport((OperateOption)this.operateOption);
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        for (DynamicObject billObj : dataEntities) {
            this.matchInspPro(billObj, inspectProGlobalCache);
            DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                if (!importFlag.booleanValue()) continue;
                entry.set("srcordertype", null);
                entry.set("srcordernum", null);
                entry.set("srcbillentity", null);
                entry.set("srcbillid", null);
                entry.set("srcbillentryid", null);
                entry.set("srcbillentryseq", null);
            }
        }
        e.setDataEntities(dataEntities);
    }

    private void matchInspPro(DynamicObject billObj, InspectProGlobalCache inspectProGlobalCache) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(billObj);
        args.getVoluationKeyModel().setInspectOrgKey("inspecorg");
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationApply());
        args.setVolustionScene(InspectDealArgs.VOLUSTIONSCENE.OPERATE);
        if (OppUtil.isImport((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.IMPORT);
        } else if (OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.API);
        }
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("materialentry");
        voluationKeyModel.setInspectOrgKey("inspecorg");
        voluationKeyModel.setInspectDeptKey("inspedeptid");
        voluationKeyModel.setInspectUserKey("inspectorid");
        voluationKeyModel.setInspectStdKey("inspectstd");
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("materialentry");
        if (OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue() || OppUtil.isImport((OperateOption)this.operateOption).booleanValue()) {
            for (int i = 0; i < entrys.size(); ++i) {
                args.getRowIndexSet().add(i);
            }
        } else {
            for (int i = 0; i < entrys.size(); ++i) {
                if (!DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)((DynamicObject)entrys.get(i))).booleanValue()) continue;
                args.getRowIndexSet().add(i);
            }
            args.setDrawNow(Boolean.valueOf(args.getRowIndexSet().size() > 0));
        }
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    private void setSrcPreparePropertys(PreparePropertysEventArgs e) {
        if (this.operateMeta == null) {
            return;
        }
        String oprType = (String)this.operateMeta.get("type");
        Boolean isBillList = InspObjectHelper.isOperateOnList((OperateOption)this.getOption());
        if (!isBillList.booleanValue() && StringQMCUtil.inside((String)oprType, (String[])new String[]{"save", "submit"}).booleanValue()) {
            if (!e.getFieldKeys().contains("srcbillentryid")) {
                e.getFieldKeys().add("srcbillentryid");
            }
            if (!e.getFieldKeys().contains("srcbillentity")) {
                e.getFieldKeys().add("srcbillentity");
            }
            if (!e.getFieldKeys().contains("srcbillid")) {
                e.getFieldKeys().add("srcbillid");
            }
            if (!e.getFieldKeys().contains("srcordernum")) {
                e.getFieldKeys().add("srcordernum");
            }
            if (!e.getFieldKeys().contains("srcbillentryseq")) {
                e.getFieldKeys().add("srcbillentryseq");
            }
            if (!e.getFieldKeys().contains("chkobjid")) {
                e.getFieldKeys().add("chkobjid");
            }
            if (!e.getFieldKeys().contains("chkobjentryid")) {
                e.getFieldKeys().add("chkobjentryid");
            }
            if (!e.getFieldKeys().contains("scsystem")) {
                e.getFieldKeys().add("scsystem");
            }
            if (!e.getFieldKeys().contains("srcunitid")) {
                e.getFieldKeys().add("srcunitid");
            }
            String seqKey = "materialentry.seq";
            if (!e.getFieldKeys().contains(seqKey)) {
                e.getFieldKeys().add(seqKey);
            }
            if (!e.getFieldKeys().contains("secondck")) {
                e.getFieldKeys().add("secondck");
            }
            if (!e.getFieldKeys().contains("baseunit")) {
                e.getFieldKeys().add("baseunit");
            }
        }
    }
}

