/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.basedata.TransacTypeHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectDealArgs;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProGlobalCache;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.InspproVoluationKeyModel;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.factory.InspectProVoluationFactory;
import kd.qmc.qcbd.business.commonmodel.inspectpro.voluation.impl.InspectProVoluationInspect;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.BizChangeWinUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.opplugin.validator.BillSaveValidator;
import kd.qmc.qcbd.opplugin.validator.IncInspectionBillSaveValidator;
import kd.qmc.qcbd.opplugin.validator.IncInspectionBillValidator;
import kd.qmc.qcbd.opplugin.validator.projentry.InspectProjEntryValidator;

public class IncInspectionMatSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("materialcfg");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("supplier");
        OppUtil.setFieldKeys((PreparePropertysEventArgs)e, (String[])new String[]{"billtype", "biztype"});
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("insdepartment");
        e.getFieldKeys().add("subinspector");
        e.getFieldKeys().add("sampscheme");
        e.getFieldKeys().add("inspectionstd");
        e.getFieldKeys().add("matintoentity");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("samplingtype");
        e.getFieldKeys().add("transactype");
        e.getFieldKeys().add("qualiqty");
        e.getFieldKeys().add("unqualiqty");
        e.getFieldKeys().add("basequaliqty");
        e.getFieldKeys().add("baseunqlyqty");
        e.getFieldKeys().add("materialqty");
        e.getFieldKeys().add("sampqualqty");
        e.getFieldKeys().add("samunqualqty");
        e.getFieldKeys().add("sampckval");
        e.getFieldKeys().add("sampckvalstr");
        e.getFieldKeys().add(String.format("%s.id", "submeasuredvalentity"));
        e.getFieldKeys().add("rinsqty");
        e.getFieldKeys().add("samplingresult");
        e.getFieldKeys().add("normtype");
        e.getFieldKeys().add("matchflag");
        e.getFieldKeys().add("specvalue");
        e.getFieldKeys().add("topvalue");
        e.getFieldKeys().add("downvalue");
        e.getFieldKeys().add("normtype");
        e.getFieldKeys().add("inspectionitem");
        e.getFieldKeys().add("inspectioncontent");
        e.getFieldKeys().add("matintoentity.seq");
        e.getFieldKeys().add("chkobjid");
        e.getFieldKeys().add("chkobjentryid");
        e.getFieldKeys().add("sourcebillno");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("sourcebilltype");
        e.getFieldKeys().add("scsystem");
        e.getFieldKeys().add("secondck");
        e.getFieldKeys().add("joininspectflag");
        e.getFieldKeys().add("isjoininspect");
        e.getFieldKeys().add("joininspectstatus");
        e.getFieldKeys().add("inspsubentity");
        e.getFieldKeys().add("subsampleresentity");
        e.getFieldKeys().add("submeasuredvalentity");
        e.getFieldKeys().add("projckval");
        e.getFieldKeys().add("choosesampqty");
        e.getFieldKeys().add("projckvalstr");
        e.getFieldKeys().add("sampckval");
        e.getFieldKeys().add("sampckvalstr");
        this.setSrcPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new IncInspectionBillValidator());
        e.addValidator((AbstractValidator)new IncInspectionBillSaveValidator());
        e.addValidator((AbstractValidator)new InspectProjEntryValidator());
        e.addValidator((AbstractValidator)new BillSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Boolean importFlag = OppUtil.isImport((OperateOption)this.operateOption);
        for (DynamicObject billObj : dataEntities) {
            DynamicObjectCollection matEntry;
            if (DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)billObj).booleanValue() && Objects.isNull(billObj.get("transactype"))) {
                Long orgId = billObj.getDynamicObject("org").getLong("id");
                DynamicObject biTypeDyo = billObj.getDynamicObject("biztype");
                if (Objects.nonNull(biTypeDyo)) {
                    DynamicObject firstDefaultTransacType = TransacTypeHelper.getFirstDefaultTransacType((Long)orgId, (Long)biTypeDyo.getLong("id"));
                    billObj.set("transactype", (Object)firstDefaultTransacType);
                }
            }
            if ((matEntry = billObj.getDynamicObjectCollection("matintoentity")) == null) continue;
            for (DynamicObject matRow : matEntry) {
                if (matRow.getDynamicObject("materialcfg") != null && matRow.getDynamicObject("materialid") == null) {
                    Object materialPkVal = matRow.getDynamicObject("materialcfg").getDynamicObject("masterid").getPkValue();
                    matRow.set("materialid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)materialPkVal, (String)"bd_material"));
                }
                if (!importFlag.booleanValue()) continue;
                matRow.set("scsystem", (Object)"qmc");
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Boolean apiFlag = OppUtil.isFromApi((OperateOption)this.operateOption);
        Boolean importFlag = OppUtil.isImport((OperateOption)this.operateOption);
        InspectProGlobalCache inspectProGlobalCache = new InspectProGlobalCache();
        for (DynamicObject billObj : dataEntities) {
            this.formatBillObj(apiFlag, importFlag, inspectProGlobalCache, billObj);
        }
        e.setDataEntities(dataEntities);
    }

    private void dealStdAndSamp(DynamicObject billObj, DynamicObject entry, Boolean changeRinsqty) {
        CkSampleCaleModel ckSampleCaleModel = this.getCkSampleCaleModel(entry, InspectCommonHelper.getSampNumRule((DynamicObject)billObj));
        DynamicObject inspectstd = entry.getDynamicObject("inspectionstd");
        if (Objects.nonNull(inspectstd)) {
            this.setStdEntry(entry, inspectstd);
        }
        for (DynamicObject projEntry : entry.getDynamicObjectCollection("inspsubentity")) {
            this.setProjectSample(billObj, entry, projEntry, ckSampleCaleModel);
        }
        DynamicObject sampleSchem = entry.getDynamicObject("sampscheme");
        if (sampleSchem != null) {
            ckSampleCaleModel.setSampeSchemObj(DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"sampscheme"));
            CkSampleCaleResModel sampleResModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)ckSampleCaleModel);
            this.setSampleSchemMaterial(entry, sampleResModel, changeRinsqty);
        }
    }

    private void matchInspPro(DynamicObject billObj, InspectProGlobalCache inspectProGlobalCache) {
        InspectDealArgs args = new InspectDealArgs();
        args.setBillData(billObj);
        args.setFactory((InspectProVoluationFactory)new InspectProVoluationInspect());
        args.setVolustionScene(InspectDealArgs.VOLUSTIONSCENE.OPERATE);
        if (OppUtil.isImport((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.IMPORT);
        } else if (OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue()) {
            args.setBillCreType(InspectDealArgs.BILLCRETYPE.API);
        }
        InspproVoluationKeyModel voluationKeyModel = args.getVoluationKeyModel();
        voluationKeyModel.setEntryKey("matintoentity");
        voluationKeyModel.setInspectDeptKey("insdepartment");
        voluationKeyModel.setInspectUserKey("subinspector");
        voluationKeyModel.setInspectStdKey("inspectionstd");
        voluationKeyModel.setInspectSampKey("sampscheme");
        voluationKeyModel.setInspectWsKey("wsrule");
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("matintoentity");
        if (OppUtil.isFromApi((OperateOption)this.operateOption).booleanValue() || OppUtil.isImport((OperateOption)this.operateOption).booleanValue()) {
            for (int i = 0; i < entrys.size(); ++i) {
                args.getRowIndexSet().add(i);
            }
            args.setDrawNow(Boolean.TRUE);
        } else {
            for (int i = 0; i < entrys.size(); ++i) {
                if (!DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)((DynamicObject)entrys.get(i))).booleanValue()) continue;
                args.getRowIndexSet().add(i);
            }
            args.setDrawNow(Boolean.valueOf(args.getRowIndexSet().size() > 0));
        }
        InspectProMatchHelper.inspectProDeal((InspectDealArgs)args, (InspectProGlobalCache)inspectProGlobalCache);
    }

    private CkSampleCaleModel getCkSampleCaleModel(DynamicObject entryObj, String rule) {
        DynamicObject sampScheme = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"sampscheme");
        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryObj, (String)"materialqty");
        DynamicObject unitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"unitfield");
        return new CkSampleCaleModel(sampScheme, qty, unitObj, rule);
    }

    private void setStdEntry(DynamicObject entry, DynamicObject inspectstd) {
        DynamicObjectCollection stdEntrys = inspectstd.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection inspsubEntrys = entry.getDynamicObjectCollection("inspsubentity");
        if (!stdEntrys.isEmpty() && inspsubEntrys.isEmpty()) {
            int i = 1;
            for (DynamicObject stdEntry : stdEntrys) {
                DynamicObject inspsubEntry = new DynamicObject(inspsubEntrys.getDynamicObjectType());
                InspectBillHelper.setStandardProjectRow((DynamicObject)stdEntry, (DynamicObject)inspsubEntry, (int)i);
                inspsubEntrys.add((Object)inspsubEntry);
                ++i;
            }
        }
    }

    private void setProjectSample(DynamicObject billObj, DynamicObject entryObj, DynamicObject inspsubEntry, CkSampleCaleModel sampleModel) {
        if (billObj.getBoolean("joininspectflag") && inspsubEntry.getBoolean("isjoininspect")) {
            return;
        }
        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entryObj, (String)"materialqty");
        BigDecimal projQty = inspsubEntry.getBigDecimal("projsampqty");
        DynamicObject projSampScheme = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)inspsubEntry, (String)"projsamp");
        if (projSampScheme != null && qty.compareTo(BigDecimal.ZERO) > 0 && projQty.compareTo(BigDecimal.ZERO) <= 0) {
            sampleModel.setSampeSchemObj(projSampScheme);
            InspectBillSampleHelper.setCKProjectSampleRow((DynamicObject)entryObj, (DynamicObject)inspsubEntry, (CkSampleCaleResModel)InspectBillHelper.getSampleInfo((CkSampleCaleModel)sampleModel));
        }
    }

    private void setSampleSchemMaterial(DynamicObject entry, CkSampleCaleResModel sampleResModel, Boolean changeRinsqty) {
        DynamicObject recColl = sampleResModel.getAcceptyObj();
        BigDecimal sc = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)recColl, (String)"samppercentage");
        String fl = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)recColl, (String)"formula");
        DataEntityState entityState = entry.getDataEntityState();
        entry.set("samppercentage", (Object)sc);
        entry.set("formula", (Object)fl);
        entry.set("acstr", (Object)sampleResModel.getAcceptyQty());
        entry.set("re", (Object)sampleResModel.getRejQty());
        entry.set("samplingsize", (Object)sampleResModel.getSampleSize());
        if (changeRinsqty.booleanValue() && Boolean.TRUE.equals(BizChangeWinUtil.isPropChanged((DataEntityState)entityState, (String)"rinsqty") == false)) {
            DynamicObjectCollection subProjEntrys = entry.getDynamicObjectCollection("inspsubentity");
            Optional<BigDecimal> maxProjSampQtyOpt = subProjEntrys.stream().map(o -> o.getBigDecimal("projsampqty")).max(Comparator.naturalOrder());
            BigDecimal matSampQty = sampleResModel.getRinsQty();
            maxProjSampQtyOpt.ifPresent(maxProjSampQty -> entry.set("rinsqty", (Object)(maxProjSampQty.compareTo(matSampQty) > 0 ? maxProjSampQty : matSampQty)));
        }
    }

    private void addCkRes(DynamicObject matRow, boolean isWebApi) {
        DynamicObjectCollection subMeasureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
        if (subMeasureEntry.isEmpty()) {
            return;
        }
        DynamicObjectCollection inspEntry = matRow.getDynamicObjectCollection("inspsubentity");
        int inspSize = inspEntry.size();
        if (isWebApi) {
            this.addMeasureResult(subMeasureEntry, inspEntry);
        }
        DynamicObjectCollection sampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        int sampCount = sampEntry.size();
        InspectCkvalHelper.dealSampEntry((boolean)isWebApi, (DynamicObjectCollection)subMeasureEntry, (DynamicObjectCollection)sampEntry, (int)inspSize);
        InspectCkvalHelper.dealProjEntry((boolean)isWebApi, (DynamicObjectCollection)subMeasureEntry, (int)sampCount, (DynamicObjectCollection)inspEntry, (boolean)false);
    }

    private void addMeasureResult(DynamicObjectCollection subMeasureEntry, DynamicObjectCollection inspEntry) {
        Map<String, DynamicObject> inspUuidMap = inspEntry.stream().collect(Collectors.toMap(x -> x.getString("uquuid"), x -> x));
        CheckProjectCaleFactory ckProjFactory = CheckProjectCaleFactory.getInstance();
        for (DynamicObject subMeasureRow : subMeasureEntry) {
            String projUuid = subMeasureRow.getString("projuuid");
            DynamicObject inspRow = inspUuidMap.get(projUuid);
            if (null == inspRow) continue;
            String normType = inspRow.getString("normtype");
            String matchFlag = "";
            DynamicObject matchFlagObj = inspRow.getDynamicObject("matchflag");
            if (null != matchFlagObj) {
                matchFlag = matchFlagObj.getString("number");
            }
            String specValue = inspRow.getString("specvalue");
            BigDecimal topValue = inspRow.getBigDecimal("topvalue");
            BigDecimal downValue = inspRow.getBigDecimal("downvalue");
            ICheckProjectCaleStrategy strategy = ckProjFactory.getCkProjectStrategy(matchFlag, normType);
            if (null == strategy) continue;
            String measuredValDeter = subMeasureRow.getString("measuredval_deter");
            String measuredValRatStr = subMeasureRow.getString("measuredval_rat");
            BigDecimal measuredValRat = null;
            if (StringUtils.isNotEmpty((CharSequence)measuredValRatStr)) {
                measuredValRat = BigDecimalUtil.toBigDecimal((Object)measuredValRatStr);
            }
            CheckProjectCaleModel paramModel = new CheckProjectCaleModel(normType, matchFlag, specValue, topValue, downValue, measuredValDeter, measuredValRat);
            String measureJudgeRes = strategy.judgmentResultMain(paramModel);
            subMeasureRow.set("measuredval_judge", (Object)measureJudgeRes);
        }
    }

    private void setSrcPreparePropertys(PreparePropertysEventArgs e) {
        String oprType = (String)this.operateMeta.get("type");
        Boolean isBillList = InspObjectHelper.isOperateOnList((OperateOption)this.getOption());
        if (!isBillList.booleanValue() && StringQMCUtil.inside((String)oprType, (String[])new String[]{"save", "submit"}).booleanValue()) {
            if (!e.getFieldKeys().contains("srcbillentryid")) {
                e.getFieldKeys().add("srcbillentryid");
            }
            if (!e.getFieldKeys().contains("srcbillentity")) {
                e.getFieldKeys().add("srcbillentity");
            }
            if (!e.getFieldKeys().contains("srcbillid")) {
                e.getFieldKeys().add("srcbillid");
            }
            if (!e.getFieldKeys().contains("sourcebillno")) {
                e.getFieldKeys().add("sourcebillno");
            }
            if (!e.getFieldKeys().contains("srcbillentryseq")) {
                e.getFieldKeys().add("srcbillentryseq");
            }
            if (!e.getFieldKeys().contains("scsystem")) {
                e.getFieldKeys().add("scsystem");
            }
            if (!e.getFieldKeys().contains("srcunitid")) {
                e.getFieldKeys().add("srcunitid");
            }
            if (!e.getFieldKeys().contains("basequaliqty")) {
                e.getFieldKeys().add("basequaliqty");
            }
            if (!e.getFieldKeys().contains("secondck")) {
                e.getFieldKeys().add("secondck");
            }
            OppUtil.setFieldKeys((PreparePropertysEventArgs)e, (String[])new String[]{"baseunit", "baseqty", "unitfield"});
        }
    }

    private void formatBillObj(Boolean apiFlag, Boolean importFlag, InspectProGlobalCache inspectProGlobalCache, DynamicObject billObj) {
        DynamicObject transactype = billObj.getDynamicObject("transactype");
        boolean delSubInspEntry = false;
        boolean delSubMeasureEntry = false;
        if (null != transactype) {
            delSubInspEntry = !transactype.getBoolean("inspsampprojflag");
            delSubMeasureEntry = !transactype.getBoolean("ckvalflag");
        }
        this.matchInspPro(billObj, inspectProGlobalCache);
        DynamicObjectCollection matRows = billObj.getDynamicObjectCollection("matintoentity");
        for (DynamicObject maRow : matRows) {
            if (importFlag.booleanValue()) {
                this.dealStdAndSamp(billObj, maRow, Boolean.FALSE);
                maRow.set("sourcebilltype", null);
                maRow.set("sourcebillno", null);
                maRow.set("srcbillentity", null);
                maRow.set("srcbillid", null);
                maRow.set("srcbillentryid", null);
                maRow.set("srcbillentryseq", null);
                this.addCkRes(maRow, Boolean.FALSE);
            } else if (apiFlag.booleanValue()) {
                this.dealStdAndSamp(billObj, maRow, apiFlag == false);
                this.addCkRes(maRow, Boolean.TRUE);
            } else if (DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)maRow).booleanValue()) {
                this.dealStdAndSamp(billObj, maRow, apiFlag == false);
            }
            if (delSubInspEntry) {
                maRow.getDynamicObjectCollection("inspsubentity").clear();
                maRow.getDynamicObjectCollection("subsampleresentity").clear();
                maRow.getDynamicObjectCollection("submeasuredvalentity").clear();
                continue;
            }
            if (!delSubMeasureEntry) continue;
            maRow.getDynamicObjectCollection("submeasuredvalentity").clear();
            DynamicObjectCollection subEntrys = maRow.getDynamicObjectCollection("inspsubentity");
            for (DynamicObject subEntryObj : subEntrys) {
                subEntryObj.set("projckval", (Object)0);
                subEntryObj.set("choosesampqty", (Object)0);
                subEntryObj.set("projckvalstr", (Object)ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(0/0)", (String)"IncInspectionMatSaveOp_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
            }
            int subEntrySize = subEntrys.size();
            DynamicObjectCollection subSamps = maRow.getDynamicObjectCollection("subsampleresentity");
            for (DynamicObject subSamp : subSamps) {
                subSamp.set("sampckval", (Object)0);
                subSamp.set("sampckvalstr", (Object)String.format(ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(0/%s)", (String)"IncInspectionMatSaveOp_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), subEntrySize));
            }
        }
    }
}

