/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.business.commonmodel.helper.inspres.InspectResultHelper;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.constant.inspres.InspectResProLogConst;
import kd.qmc.qcbd.opplugin.evtservice.InspResultSendInfoEvt;
import kd.qmc.qcbd.opplugin.validator.InspResultFeedBackValidator;

public class InspResultFeedBackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entity");
        e.getFieldKeys().add("opname");
        e.getFieldKeys().add("billid");
        e.getFieldKeys().add("feedback_status");
        e.getFieldKeys().add("processstartdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InspResultFeedBackValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] inspResLogObjs = e.getDataEntities();
        Map<String, List<DynamicObject>> groupByInspResLogObjs = Arrays.stream(inspResLogObjs).collect(Collectors.groupingBy(x -> String.join((CharSequence)";", x.getString("entity"), x.getString("opname"))));
        for (Map.Entry<String, List<DynamicObject>> entry : groupByInspResLogObjs.entrySet()) {
            String[] keySplit = entry.getKey().split(";");
            String entity = keySplit[0];
            String operate = keySplit[1];
            Set srcBillIdList = entry.getValue().stream().map(x -> x.get("billid")).collect(Collectors.toSet());
            String billFlag = InspObjectHelper.getInspObjectFactory((String)entity).getBillFlag();
            JSONObject requestObj = InspectResultHelper.buildRequestObj((String)InspectResProLogConst.PROCESSOR_ENUM.H.name(), (String)billFlag, (String)operate, (String)entity, srcBillIdList);
            InspResultSendInfoEvt.callhandleEvent(requestObj);
        }
    }
}

