/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.opplugin.validator.InspecStandardRepairValidator;

public class InspecStandardRepairOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity.checkitems");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InspecStandardRepairValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dynObj = dataEntities[0];
        HashSet<Long> afterStdIdSet = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = dynObj.getDynamicObjectCollection("entryentity");
        Map<String, Long> repairMap = this.setRepairMap(afterStdIdSet, entryEntity);
        String selectFields = "id,entryentity.checkcontent checkcontent,entryentity.unit unit,entryentity.checkmethod checkmethod,entryentity.checkbasis checkbasis,entryentity.checkinstruct checkinstruct,entryentity.keyquality keyquality";
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", repairMap.values())};
        DynamicObjectCollection checkItemsCollection = QueryServiceHelper.query((String)"qcbd_inspectionitems", (String)selectFields, (QFilter[])qFilter);
        String selectProperties = "id,number,name,group,status,org,useorg,createorg,ctrlstrategy,enable,comment,isrepair,entryentity.isjoininspect,entryentity.checkitems,entryentity.unit,entryentity.checkcontent,entryentity.checkmethod,entryentity.checkbasis,entryentity.checkinstruct,entryentity.checkfreq,entryentity.keyquality,entryentity.normtype,entryentity.matchflag,entryentity.specvalue,entryentity.topvalue,entryentity.downvalue,entryentity.projsamp";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", afterStdIdSet)};
        DynamicObject[] dynObjArr = BusinessDataServiceHelper.load((String)"qcbd_inspectionstd", (String)selectProperties, (QFilter[])qFilters);
        String repairMethod = dynObj.getString("repairmethod");
        if ("C".equals(repairMethod)) {
            this.setValueByCover(repairMap, dynObjArr, checkItemsCollection);
            SaveServiceHelper.save((DynamicObject[])dynObjArr);
        } else if ("N".equals(repairMethod)) {
            for (DynamicObject dyn : dynObjArr) {
                dyn.set("enable", (Object)"0");
                dyn.set("isrepair", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.save((DynamicObject[])dynObjArr);
            DynamicObject[] afterRepairArr = this.setValueByCover(repairMap, dynObjArr, checkItemsCollection);
            DynamicObjectCollection dynCollection = this.setNewValueByOld(afterRepairArr);
            OperationServiceHelper.executeOperate((String)"save", (String)"qcbd_inspectionstd", (DynamicObject[])((DynamicObject[])dynCollection.toArray((Object[])new DynamicObject[0])), null);
        }
    }

    private Map<String, Long> setRepairMap(Set<Long> afterStdIdSet, DynamicObjectCollection entryEntity) {
        HashMap<String, Long> repairMap = new HashMap<String, Long>(16);
        for (DynamicObject entryObj : entryEntity) {
            Long beforeStdId = entryObj.getLong("preinspectstd.id");
            Long preitemsId = entryObj.getLong("precheckitems.id");
            String preCheckContent = entryObj.getString("precheckcontent");
            Long afterItemsId = entryObj.getLong("aftercheckitems.id");
            afterStdIdSet.add(beforeStdId);
            String key = beforeStdId + preitemsId + preCheckContent;
            repairMap.put(key, afterItemsId);
        }
        return repairMap;
    }

    private DynamicObjectCollection setNewValueByOld(DynamicObject[] afterRepairArr) {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        int seq = 1;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        for (DynamicObject oldDyn : afterRepairArr) {
            DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"qcbd_inspectionstd");
            String number = this.getNumber("qcbd_inspectionstd", newDyn);
            if (number == null || number.isEmpty()) {
                String date = df.format(new Date());
                number = "JYBZ_" + date + "_00" + seq;
                ++seq;
            }
            newDyn.set("number", (Object)number);
            newDyn.set("name", (Object)oldDyn.getLocaleString("name"));
            newDyn.set("group", (Object)oldDyn.getLong("group.id"));
            newDyn.set("status", (Object)"A");
            newDyn.set("enable", (Object)"1");
            newDyn.set("isrepair", (Object)"0");
            newDyn.set("srcstdid", (Object)oldDyn.getLong("id"));
            newDyn.set("ctrlstrategy", (Object)oldDyn.getString("ctrlstrategy"));
            newDyn.set("comment", (Object)oldDyn.getString("comment"));
            newDyn.set("createorg", (Object)oldDyn.getLong("createorg.id"));
            newDyn.set("org", (Object)oldDyn.getLong("org.id"));
            newDyn.set("creator", (Object)1L);
            newDyn.set("modifier", (Object)1L);
            DynamicObjectCollection entryCollection = oldDyn.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryCollection.size(); ++index) {
                DynamicObject entryObj = (DynamicObject)entryCollection.get(index);
                DynamicObjectCollection entryentity = newDyn.getDynamicObjectCollection("entryentity");
                DynamicObject entry = new DynamicObject(entryentity.getDynamicObjectType());
                entry.set("seq", (Object)(index + 1));
                entry.set("isjoininspect", (Object)entryObj.getString("isjoininspect"));
                entry.set("checkitems", (Object)entryObj.getLong("checkitems"));
                entry.set("checkcontent", (Object)entryObj.getString("checkcontent"));
                entry.set("unit", (Object)entryObj.getLong("unit_id"));
                DynamicObject tempObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"checkitems");
                DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)tempObj);
                entry.set("checkmethod", (Object)entryObj.getLong("checkmethod_id"));
                entry.set("checkbasis", (Object)entryObj.getLong("checkbasis_id"));
                entry.set("checkinstruct", (Object)entryObj.getLong("checkinstruct_id"));
                entry.set("checkfreq", (Object)entryObj.getLong("checkfreq_id"));
                entry.set("keyquality", (Object)entryObj.getString("keyquality"));
                entry.set("normtype", (Object)entryObj.getString("normtype"));
                entry.set("matchflag", (Object)entryObj.getLong("matchflag_id"));
                entry.set("specvalue", (Object)entryObj.getString("specvalue"));
                entry.set("topvalue", (Object)entryObj.getBigDecimal("topvalue"));
                entry.set("downvalue", (Object)entryObj.getBigDecimal("downvalue"));
                entry.set("projsamp", (Object)entryObj.getLong("projsamp_id"));
                entryentity.add((Object)entry);
            }
            dynCollection.add((Object)newDyn);
        }
        return dynCollection;
    }

    private DynamicObject[] setValueByCover(Map<String, Long> repairMap, DynamicObject[] dynObjArr, DynamicObjectCollection checkItemsCollection) {
        for (DynamicObject dyn : dynObjArr) {
            Long stdId = dyn.getLong("id");
            dyn.set("isrepair", (Object)Boolean.TRUE);
            DynamicObjectCollection entryCollection = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryObj : entryCollection) {
                Long itemsId = entryObj.getLong("checkitems.id");
                String checkContent = entryObj.getString("checkcontent");
                String key = stdId + itemsId + checkContent;
                Long newValue = repairMap.get(key);
                for (DynamicObject checkItemsObj : checkItemsCollection) {
                    Long checkItemsId = checkItemsObj.getLong("id");
                    if (newValue == null || newValue == 0L || !newValue.equals(checkItemsId)) continue;
                    entryObj.set("checkitems", (Object)newValue);
                    entryObj.set("unit", (Object)checkItemsObj.getLong("unit"));
                    entryObj.set("checkcontent", (Object)checkItemsObj.getString("checkcontent"));
                    entryObj.set("checkmethod", (Object)checkItemsObj.getLong("checkmethod"));
                    entryObj.set("checkbasis", (Object)checkItemsObj.getLong("checkbasis"));
                    entryObj.set("checkinstruct", (Object)checkItemsObj.getLong("checkinstruct"));
                    entryObj.set("keyquality", (Object)checkItemsObj.getString("keyquality"));
                }
            }
        }
        return dynObjArr;
    }

    private String getNumber(String entityName, DynamicObject dynObj) {
        QFilter qfilter = new QFilter("bizobjectid", "=", (Object)entityName);
        qfilter = qfilter.and(new QFilter("enable", "=", (Object)"1"));
        Boolean existsCoderule = QueryServiceHelper.exists((String)"bos_coderule", (Object)qfilter);
        String codeNumber = null;
        if (existsCoderule.booleanValue()) {
            Long currOrg = RequestContext.get().getOrgId();
            codeNumber = CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynObj, (String)String.valueOf(currOrg));
        }
        return codeNumber;
    }
}

