/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.baddealbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BadHandModeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDatas = this.getDataEntities();
        boolean returnFlag = this.totalRes();
        String strMes = this.strMessage();
        for (ExtendedDataEntity entity : extendedDatas) {
            DynamicObject obj = entity.getDataEntity();
            boolean istool = obj.getBoolean("istool");
            if (returnFlag || istool) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e8c\u5f00\u4e0d\u826f\u5904\u7406\u65b9\u5f0f\u672a\u5347\u7ea7\uff1a%s\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BadHandModeValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), strMes);
            this.addErrorMessage(entity, errMsg);
        }
    }

    private boolean totalRes() {
        boolean qcpRes = this.compareValue("qcp_baddeal");
        boolean qcppRes = this.compareValue("qcpp_manubaddeal");
        boolean qcasRes = this.compareValue("qcas_salebaddeal");
        boolean invRes = this.compareValue("qcnp_invbalbaddeal");
        return qcpRes && qcppRes && qcasRes && invRes;
    }

    private List<String> getComboValue(String billName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
        Map fieldMap = mainEntityType.getAllFields();
        ComboProp handMethed = (ComboProp)fieldMap.get("handmethed");
        List strList = handMethed.getComboItems();
        ArrayList<String> comList = new ArrayList<String>(strList.size());
        for (ValueMapItem item : strList) {
            String itemStr = item.getValue();
            comList.add(itemStr);
        }
        return comList;
    }

    private List<String> getOldHandmethed(String billName) {
        QFilter billFilter = new QFilter("billformid.number", "=", (Object)billName);
        DynamicObject[] billTypeList = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"id,number,billformid", (QFilter[])new QFilter[]{billFilter});
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject billObj : billTypeList) {
            Long id = billObj.getLong("id");
            idList.add(id);
        }
        QFilter filter = new QFilter("entryentity.modebilltype", "in", idList);
        DynamicObject[] badmodeDyns = BusinessDataServiceHelper.load((String)"qcbd_badhandmode", (String)"name,oldbaddealstyle", (QFilter[])new QFilter[]{filter});
        ArrayList<String> oldStyleList = new ArrayList<String>(10);
        for (DynamicObject obj : badmodeDyns) {
            String oldStyle = obj.getString("oldbaddealstyle");
            if (oldStyle.isEmpty()) continue;
            oldStyleList.add(oldStyle);
        }
        return oldStyleList;
    }

    private boolean compareValue(String billName) {
        QFilter filter = new QFilter("number", "=", (Object)billName);
        boolean res = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{filter});
        if (!res) {
            return true;
        }
        List<String> comList = this.getComboValue(billName);
        List<String> oldStyleList = this.getOldHandmethed(billName);
        boolean flag = true;
        for (String val : comList) {
            if (oldStyleList.contains(val)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private List<Map<String, String>> getRunComMap(String billName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
        Map fieldMap = mainEntityType.getAllFields();
        ComboProp handMethed = (ComboProp)fieldMap.get("handmethed");
        List strList = handMethed.getComboItems();
        ArrayList<Map<String, String>> comList = new ArrayList<Map<String, String>>(strList.size());
        for (ValueMapItem item : strList) {
            String itemStr = item.getValue();
            LocaleString itemName = item.getName();
            String itemNameStr = itemName.getLocaleValue();
            HashMap<String, String> objMap = new HashMap<String, String>(20);
            objMap.put("name", itemNameStr);
            objMap.put("value", itemStr);
            comList.add(objMap);
        }
        return comList;
    }

    private String returnMessage(String billName) {
        StringBuilder sb = new StringBuilder();
        QFilter filter = new QFilter("number", "=", (Object)billName);
        boolean res = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{filter});
        if (!res) {
            return sb.toString();
        }
        List<Map<String, String>> comList = this.getRunComMap(billName);
        List<String> oldStyleList = this.getOldHandmethed(billName);
        for (Map<String, String> val : comList) {
            if (oldStyleList.contains(val.get("value"))) continue;
            String mergeStyle = val.get("name") + "(" + val.get("value") + ")";
            sb.append(mergeStyle);
            sb.append("\u3001");
        }
        String midStr = sb.toString();
        if (StringUtils.isNotEmpty((CharSequence)midStr)) {
            midStr = midStr.substring(0, midStr.length() - 1);
        }
        return midStr;
    }

    private String strMessage() {
        String qcpStr = this.returnMessage("qcp_baddeal");
        String qcppStr = this.returnMessage("qcpp_manubaddeal");
        String qcasStr = this.returnMessage("qcas_salebaddeal");
        String qcnpStr = this.returnMessage("qcnp_invbalbaddeal");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)qcpStr)) {
            sb.append(this.getResStr("ll"));
            sb.append(qcpStr);
            sb.append("\uff0c");
        }
        if (StringUtils.isNotEmpty((CharSequence)qcppStr)) {
            sb.append(this.getResStr("sc"));
            sb.append(qcppStr);
            sb.append("\uff0c");
        }
        if (StringUtils.isNotEmpty((CharSequence)qcasStr)) {
            sb.append(this.getResStr("xs"));
            sb.append(qcasStr);
            sb.append("\uff0c");
        }
        if (StringUtils.isNotEmpty((CharSequence)qcnpStr)) {
            sb.append(this.getResStr("kc"));
            sb.append(qcnpStr);
            sb.append("\uff0c");
        }
        return sb.toString();
    }

    private String getResStr(String strType) {
        String valStr = "";
        switch (strType) {
            case "ll": {
                valStr = ResManager.loadKDString((String)"\u6765\u6599\u4e0d\u826f\u5904\u7406\u65b9\u5f0f\uff1a", (String)"BadHandModeValidator_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
                break;
            }
            case "sc": {
                valStr = ResManager.loadKDString((String)"\u751f\u4ea7\u4e0d\u826f\u5904\u7406\u65b9\u5f0f\uff1a", (String)"BadHandModeValidator_2", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
                break;
            }
            case "xs": {
                valStr = ResManager.loadKDString((String)"\u9500\u552e\u4e0d\u826f\u5904\u7406\u65b9\u5f0f\uff1a", (String)"BadHandModeValidator_3", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
                break;
            }
            case "kc": {
                valStr = ResManager.loadKDString((String)"\u5176\u5b83\u4e0d\u826f\u5904\u7406\u65b9\u5f0f\uff1a", (String)"BadHandModeValidator_4", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        return valStr;
    }
}

