/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.baddealfix;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.business.helper.BadDealSqlHelper;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class BadDealFixToolSqlPlugin
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(BadDealFixToolSqlPlugin.class);
    private static final String ENTITY = "entitynumber";
    private static final String NEWHANDMODE = "newhandmode";
    private static final String OLDHANDMETHED = "oldhandmethed";
    private static final String EXECFIX = "execfix";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ISSUNCESS = "issuncess";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(ENTITY);
        e.getFieldKeys().add(NEWHANDMODE);
        e.getFieldKeys().add(OLDHANDMETHED);
        e.getFieldKeys().add(ISSUNCESS);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynArr;
        String opKey = e.getOperationKey();
        if (!EXECFIX.equals(opKey)) {
            return;
        }
        for (DynamicObject dyn : dynArr = e.getDataEntities()) {
            this.executeFixSql(dyn);
        }
    }

    private void executeFixSql(DynamicObject dyn) {
        DynamicObject fixEntity = dyn.getDynamicObject(ENTITY);
        DynamicObjectCollection mappingEntry = dyn.getDynamicObjectCollection(ENTRYENTITY);
        BadDealSqlHelper badDealSqlHelper = new BadDealSqlHelper();
        this.execFixBadDeal(badDealSqlHelper, fixEntity, mappingEntry);
        this.execFixInspectObj(badDealSqlHelper, fixEntity, mappingEntry);
        this.execFixInspextRes(badDealSqlHelper, fixEntity, mappingEntry);
        dyn.set(ISSUNCESS, (Object)true);
        SaveServiceHelper.update((DynamicObject)dyn);
    }

    private int execFixBadDeal(BadDealSqlHelper badDealSqlHelper, DynamicObject fixEntity, DynamicObjectCollection mappingEntry) {
        StringBuilder badDealSql = new StringBuilder();
        badDealSqlHelper.createBadDealSql(badDealSql, fixEntity, mappingEntry);
        String badDealSqlStr = this.strSubStringToSql(badDealSql);
        this.log.info("\u4fee\u590d\u4e0d\u826f\u54c1\u5355\u636e\u5904\u7406\u5f00\u59cb\u6267\u884c\u3002");
        int badDealRes = DB.update((DBRoute)DBRoute.of((String)"qmc"), (String)badDealSqlStr);
        this.log.info("\u4fee\u590d\u4e0d\u826f\u54c1\u5355\u636e\u5904\u7406\u7ed3\u675f\u6267\u884c\u3002");
        return badDealRes;
    }

    private int execFixInspectObj(BadDealSqlHelper badDealSqlHelper, DynamicObject fixEntity, DynamicObjectCollection mappingEntry) {
        String billStr = fixEntity.getString("id");
        String appName = StringQMCUtil.getAppPrefix((String)billStr);
        StringBuilder badInspectObjSql = new StringBuilder();
        badDealSqlHelper.createInspectObjSql(badInspectObjSql, mappingEntry, appName);
        String badInspectObjSqlStr = this.strSubStringToSql(badInspectObjSql);
        this.log.info("\u4fee\u590d\u68c0\u9a8c\u5bf9\u8c61\u5f00\u59cb\u6267\u884c\u3002");
        int inspectObjRes = DB.update((DBRoute)DBRoute.of((String)"qmc"), (String)badInspectObjSqlStr);
        this.log.info("\u4fee\u590d\u68c0\u9a8c\u5bf9\u8c61\u7ed3\u675f\u6267\u884c\u3002");
        return inspectObjRes;
    }

    private int execFixInspextRes(BadDealSqlHelper badDealSqlHelper, DynamicObject fixEntity, DynamicObjectCollection mappingEntry) {
        StringBuilder badInspectResSql = new StringBuilder();
        badDealSqlHelper.careateInspectResSql(fixEntity, badInspectResSql, mappingEntry);
        String badInspectResSqlStr = this.strSubStringToSql(badInspectResSql);
        this.log.info("\u4fee\u590d\u68c0\u9a8c\u7ed3\u679c\u5f00\u59cb\u6267\u884c\u3002");
        int inspectResRes = DB.update((DBRoute)DBRoute.of((String)"qmc"), (String)badInspectResSqlStr);
        this.log.info("\u4fee\u590d\u68c0\u9a8c\u7ed3\u679c\u7ed3\u675f\u6267\u884c\u3002");
        return inspectResRes;
    }

    private String strSubStringToSql(StringBuilder stringBuilder) {
        String stringBuilderStr = stringBuilder.toString();
        stringBuilderStr = stringBuilderStr.replaceAll("\r\n", " ");
        int end = stringBuilderStr.indexOf("***/");
        stringBuilderStr = stringBuilderStr.substring(end += 4, stringBuilderStr.length());
        return stringBuilderStr;
    }
}

