/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.evtservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.JsonEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;
import kd.qmc.qcbd.business.commonmodel.helper.inspres.InspectResultProcessLogHelper;
import kd.qmc.qcbd.business.commonmodel.plugin.AbstractInspResultOperationServicePlugIn;
import kd.qmc.qcbd.business.commonmodel.plugin.args.AfterInspResOperationArgs;
import kd.qmc.qcbd.business.commonmodel.plugin.args.BeginInspResOperationTransactionArgs;
import kd.qmc.qcbd.business.commonmodel.plugin.args.EndInspResOperationTransactionArgs;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.business.inspresult.InspResultExcute;
import kd.qmc.qcbd.common.constant.inspres.InspectResProLogConst;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class InspResultSendInfoEvt
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(InspResultSendInfoEvt.class);

    public Object handleEvent(KDBizEvent evt) {
        if (!(evt instanceof JsonEvent)) {
            return evt.getEventId();
        }
        List<Object> srcBillIdList = new LinkedList();
        try {
            String srcDataStr = evt.getSource();
            JSONArray srcObjArray = JSON.parseArray((String)srcDataStr);
            for (Object obj : srcObjArray) {
                JSONObject srcObj = (JSONObject)obj;
                if (!srcObj.containsKey((Object)"dockParam")) {
                    return evt.getEventId();
                }
                JSONObject dockParam = srcObj.getJSONObject("dockParam");
                String inspresultExcute = dockParam.getString("inspresultExcute");
                String operationKey = srcObj.getString("operate");
                String metaKey = srcObj.getString("metaKey");
                String appID = dockParam.getString("srcAppID");
                JSONArray srcBillArray = dockParam.getJSONArray("srcBillIDs");
                if (!StringUtils.equalsIgnoreCase((CharSequence)inspresultExcute, (CharSequence)"true") || Objects.isNull(srcBillArray)) continue;
                srcBillIdList = srcBillArray.stream().map(x -> (Long)x).collect(Collectors.toList());
                List effectiveSrcBillIds = InspectResultProcessLogHelper.lockBillIds(srcBillIdList, (String)dockParam.getString("processor"));
                this.dealInspResult(srcObj, effectiveSrcBillIds);
                InspResultExcute resExcute = new InspResultExcute(MetadataServiceHelper.getDataEntityType((String)metaKey));
                String selectedFilds = "id,ck_materialid,ass_biztype,billno,ck_handmethed,ck_newhandmode.id,ck_newhandmode.number,ck_newhandmode.name,ck_unitid,ck_baseunitid,splitbatchentity.id,splitbatchentity.m_submitunit,splitbatchentity.m_srcentitynumber,splitbatchentity.m_srcsystem,splitbatchentity.m_srcbillno,splitbatchentity.m_srcbillid,splitbatchentity.m_srcbillentryid,splitbatchentity.m_srcbillentryseq,splitbatchentity.m_qualifqty,splitbatchentity.m_qualifybaseqty,splitbatchentity.m_unqualifqty,splitbatchentity.m_unqualifbaseqty,splitbatchentity.m_samplingresult";
                QFilter qFilter = new QFilter("ass_entitynumber", "=", (Object)metaKey);
                qFilter.and("ass_billid", "in", effectiveSrcBillIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet()));
                DynamicObjectCollection inspResultDyos = QueryServiceHelper.query((String)resExcute.getResEntityNumber(), (String)selectedFilds, (QFilter[])qFilter.toArray());
                this.triggerEvent(operationKey, appID, metaKey, inspResultDyos);
                if ("unaudit".equalsIgnoreCase(operationKey)) {
                    resExcute.execDockBillResOpr(inspResultDyos.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()), new String[]{"delete"});
                    resExcute.updateInspObjResult(effectiveSrcBillIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()));
                }
                InspectResultProcessLogHelper.delInspResLogs((List)effectiveSrcBillIds);
                DynamicObject[] billObjs = BusinessDataServiceHelper.load((Object[])effectiveSrcBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)metaKey));
                String operateKey = "audit".equalsIgnoreCase(operationKey) ? "inspresaudit" : "inspresunaudit";
                OperationServiceHelper.executeOperate((String)operateKey, (String)metaKey, (DynamicObject[])billObjs, (OperateOption)OperateOption.create());
            }
        }
        catch (Exception ex) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            InspectResultProcessLogHelper.setFeedBackStatus(srcBillIdList, (String)InspectResProLogConst.FEEDBACK_STATUS_ENUM.F.name(), (String)errMsg);
            return ex;
        }
        return evt.getEventId();
    }

    private void triggerEvent(String operationKey, String appID, String metaKey, DynamicObjectCollection inspResultDyos) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("operate", (Object)operationKey);
        reqJson.put("metakey", (Object)metaKey);
        reqJson.put("appid", (Object)appID);
        Map<String, List<Map<String, Object>>> srcEntityNumMap = this.getSrcEntityNumMap(inspResultDyos);
        srcEntityNumMap.forEach((key, value) -> {
            int listSize = value.size();
            Map returnInfoFirst = (Map)value.get(0);
            reqJson.put("ck_srcsystem", returnInfoFirst.get("ck_srcsystem"));
            reqJson.put("ck_srcentitynumber", returnInfoFirst.get("ck_srcentitynumber"));
            reqJson.put("biztype", returnInfoFirst.get("biztype"));
            returnInfoFirst.remove("ck_srcsystem");
            returnInfoFirst.remove("ck_srcentitynumber");
            returnInfoFirst.remove("biztype");
            for (int i = 0; i <= listSize / 1000; ++i) {
                int endIndex = Math.min(listSize, (i + 1) * 1000);
                reqJson.put("srcbills", value.subList(i * 1000, endIndex));
                WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService((String)"IWorkflowService");
                if (service == null) continue;
                service.triggerEventSubscribe("inspresult.opreate_sendinfo", reqJson.toJSONString());
            }
        });
    }

    private Map<String, List<Map<String, Object>>> getSrcEntityNumMap(DynamicObjectCollection inspResultDyos) {
        LinkedHashMap<String, List<Map<String, Object>>> srcEntityNumMap = new LinkedHashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject inspResultObj : inspResultDyos) {
            ArrayList<Map<String, Object>> list;
            String srcEntityNum = inspResultObj.getString("splitbatchentity.m_srcentitynumber");
            String srcSystem = inspResultObj.getString("splitbatchentity.m_srcsystem");
            String biztype = inspResultObj.getString("ass_biztype");
            String key = srcSystem + "_" + srcEntityNum + "_" + biztype;
            if (srcEntityNumMap.containsKey(key)) {
                list = (List)srcEntityNumMap.get(key);
                this.buildReturnInfo(inspResultObj, list, Boolean.FALSE);
                continue;
            }
            list = new ArrayList();
            this.buildReturnInfo(inspResultObj, list, Boolean.TRUE);
            srcEntityNumMap.put(key, list);
        }
        return srcEntityNumMap;
    }

    private void buildReturnInfo(DynamicObject inspResultObj, List<Map<String, Object>> list, boolean isInit) {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>(16);
        if (isInit) {
            resultInfo.put("ck_srcentitynumber", inspResultObj.getString("splitbatchentity.m_srcentitynumber"));
            resultInfo.put("ck_srcsystem", inspResultObj.getString("splitbatchentity.m_srcsystem"));
            resultInfo.put("biztype", inspResultObj.getLong("ass_biztype"));
        }
        resultInfo.put("material_id", inspResultObj.getLong("ck_materialid"));
        resultInfo.put("result_number", inspResultObj.getString("billno"));
        resultInfo.put("result_entryid", inspResultObj.getLong("splitbatchentity.id"));
        String handMethod = inspResultObj.getString("ck_handmethed");
        if (StringUtils.isNotBlank((CharSequence)handMethod)) {
            resultInfo.put("handmethed", handMethod.substring(handMethod.length() - 1));
        }
        resultInfo.put("handmethod_id", inspResultObj.getString("ck_newhandmode.id"));
        resultInfo.put("handmethod_number", inspResultObj.getString("ck_newhandmode.number"));
        resultInfo.put("handmethod_name", inspResultObj.getString("ck_newhandmode.name"));
        resultInfo.put("srcbillno", inspResultObj.getString("splitbatchentity.m_srcbillno"));
        resultInfo.put("srcbillid", inspResultObj.getLong("splitbatchentity.m_srcbillid"));
        resultInfo.put("srcbillentryid", inspResultObj.getLong("splitbatchentity.m_srcbillentryid"));
        resultInfo.put("srcbillentryseq", inspResultObj.getLong("splitbatchentity.m_srcbillentryseq"));
        resultInfo.put("qualityqty", inspResultObj.getBigDecimal("splitbatchentity.m_qualifqty"));
        resultInfo.put("qualitybaseqty", inspResultObj.getBigDecimal("splitbatchentity.m_qualifybaseqty"));
        resultInfo.put("unqualityqty", inspResultObj.getBigDecimal("splitbatchentity.m_unqualifqty"));
        resultInfo.put("unqualitybaseqty", inspResultObj.getBigDecimal("splitbatchentity.m_unqualifbaseqty"));
        resultInfo.put("ck_unit", inspResultObj.getLong("ck_unitid"));
        resultInfo.put("ck_baseunit", inspResultObj.getLong("ck_baseunitid"));
        resultInfo.put("srcunit", inspResultObj.getLong("splitbatchentity.m_submitunit"));
        String samplingResult = inspResultObj.getString("splitbatchentity.m_samplingresult");
        if (StringUtils.isNotBlank((CharSequence)samplingResult)) {
            resultInfo.put("samplingresult", StringUtils.equals((CharSequence)samplingResult, (CharSequence)"B") ? "Y" : "N");
        }
        list.add(resultInfo);
    }

    public static Object callhandleEvent(JSONObject requestObj) {
        InspResultSendInfoEvt evt = (InspResultSendInfoEvt)TypesContainer.getOrRegisterSingletonInstance((String)"kd.qmc.qcbd.opplugin.evtservice.InspResultSendInfoEvt");
        JsonEvent jsonEvent = new JsonEvent();
        JSONArray requestArr = new JSONArray();
        requestArr.add((Object)requestObj);
        jsonEvent.setSource(requestArr.toJSONString());
        return evt.handleEvent((KDBizEvent)jsonEvent);
    }

    public void dealInspResult(JSONObject srcObj, List<Long> effectiveSrcBillIds) {
        String operationKey = srcObj.getString("operate");
        if (!"audit".equalsIgnoreCase(operationKey) || CollectionUtils.isEmpty(effectiveSrcBillIds)) {
            return;
        }
        List<String> effectiveSrcBillIdStrs = effectiveSrcBillIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toList());
        JSONObject dockParam = srcObj.getJSONObject("dockParam");
        String srcAppid = dockParam.getString("srcAppID");
        String srcMetaKey = dockParam.getString("srcMetaKey");
        MainEntityType triggerBillEntityType = MetadataServiceHelper.getDataEntityType((String)srcMetaKey);
        InspResultExcute resExcute = new InspResultExcute(triggerBillEntityType);
        HashSet srcBillIdSet = new HashSet(effectiveSrcBillIdStrs);
        resExcute.execDockBillResOpr(resExcute.getResPkVals(srcBillIdSet, "A"), new String[]{"delete"});
        List<AbstractInspResultOperationServicePlugIn> plugins = this.getAbstractInspResultOperationServicePlugIns(srcMetaKey, operationKey);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)resExcute.getResEntityNumber());
        OperateOption option = OperateOption.create();
        Map<String, Object> operateMeta = this.getOpreateMeta(srcAppid, srcMetaKey, effectiveSrcBillIdStrs);
        logger.info("call trigger_handleEvent begin");
        long startTime = System.currentTimeMillis();
        try {
            for (AbstractInspResultOperationServicePlugIn plugin : plugins) {
                plugin.setContext(entityType, operateMeta, option);
                BeginInspResOperationTransactionArgs beginArgs = new BeginInspResOperationTransactionArgs(operationKey);
                plugin.beginOperationTransaction(beginArgs);
                if (beginArgs.isCancelOperation()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u68c0\u67e5\u8d44\u6e90\u64cd\u4f5c\u4e8b\u52a1\u53c2\u6570\uff0c\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"InspResultEventClient_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
                }
                EndInspResOperationTransactionArgs endArgs = new EndInspResOperationTransactionArgs(operationKey);
                plugin.endOperationTransaction(endArgs);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("trigger_handleEvent", ResManager.loadKDString((String)"\u68c0\u9a8c\u7ed3\u679c\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\u3002", (String)"InspResultEventClient_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0])), new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)});
        }
        for (AbstractInspResultOperationServicePlugIn plugin : plugins) {
            AfterInspResOperationArgs afterArgs = new AfterInspResOperationArgs(operationKey);
            plugin.afterExecuteOperationTransaction(afterArgs);
        }
        long endTime = System.currentTimeMillis();
        Map resPkMap = resExcute.getResPkMap(srcBillIdSet, "B");
        Set entrySet = resPkMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String billIdStr = (String)entry.getKey();
            Set inspResIdSet = (Set)entry.getValue();
            OperationResult operationResult = resExcute.execDockBillResOpr(inspResIdSet, new String[]{operationKey});
            if (operationResult.isSuccess()) continue;
            Set successPkIdSet = operationResult.getSuccessPkIds().stream().map(x -> (Long)x).collect(Collectors.toSet());
            resExcute.execDockBillResOpr(successPkIdSet, new String[]{"unaudit"});
            inspResIdSet.removeAll(successPkIdSet);
            resExcute.execDockBillResOpr(inspResIdSet, new String[]{"unsubmit"});
            Long billId = Long.valueOf(billIdStr);
            InspectResultProcessLogHelper.setFeedBackStatus(Collections.singletonList(billId), (String)"F", (String)operationResult.getMessage());
            effectiveSrcBillIds.remove(billId);
        }
        logger.info(String.format("consum:%s ms", startTime - endTime));
        logger.info("call trigger_handleEvent end");
    }

    private Map<String, Object> getOpreateMeta(String srcAppid, String srcMetaKey, List<String> billIds) {
        HashMap<String, Object> operateMeta = new HashMap<String, Object>(10);
        operateMeta.put("trigger_billids", billIds);
        operateMeta.put("trigger_entitynumber", srcMetaKey);
        operateMeta.put("trigger_appid", srcAppid);
        operateMeta.put("trigger_inspobjnumber", InspObjectHelper.getInspObjEntityNumberByAppid((String)srcAppid));
        return operateMeta;
    }

    private List<AbstractInspResultOperationServicePlugIn> getAbstractInspResultOperationServicePlugIns(String triggerEntitynumber, String operationKey) {
        ArrayList<AbstractInspResultOperationServicePlugIn> plugins = new ArrayList<AbstractInspResultOperationServicePlugIn>();
        QFilter qfilters = new QFilter("entitytype", "=", (Object)triggerEntitynumber);
        qfilters.and("status", "=", (Object)"C");
        qfilters.and("enable", "=", (Object)true);
        qfilters.and("entryentity.resopreate", "=", (Object)operationKey);
        qfilters.and("entryentity.resenable", "=", (Object)true);
        String selectFields = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"entryentity.resplugin", "entryentity.resplugindesc"});
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"qcbd_plugin_cfg", (String)selectFields, (QFilter[])qfilters.toArray());
        for (DynamicObject coll : colls) {
            String className = coll.getString("entryentity.resplugin");
            Object factory = TypesContainer.getOrRegisterSingletonInstance((String)className);
            if (factory instanceof AbstractInspResultOperationServicePlugIn) {
                plugins.add((AbstractInspResultOperationServicePlugIn)factory);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u53cd\u5c04\u5f02\u5e38\uff1a%s", (String)"InspResultEventClient_2", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), className));
        }
        return plugins;
    }
}

