/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.evtservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RouteVersionSyncEventService
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(RouteVersionSyncEventService.class);
    private static final int count = 100;

    public Object handleEvent(KDBizEvent evt) {
        if (!(evt instanceof EntityEvent)) {
            log.info("no meet EntityEvent {}", (Object)evt.getClass().getName());
            return evt.getEventId();
        }
        EntityEvent entityEvent = (EntityEvent)evt;
        List businessKeys = entityEvent.getBusinesskeys();
        List ids = businessKeys.stream().map(m -> Long.valueOf(m)).collect(Collectors.toList());
        DynamicObjectCollection routeVersionInitTags = QueryServiceHelper.query((String)"pdm_routeversioninittag", (String)"id,initorg", (QFilter[])new QFilter("id", "in", ids).toArray());
        Set initOrgSet = routeVersionInitTags.stream().map(m -> m.getLong("initorg")).collect(Collectors.toSet());
        DynamicObjectCollection routes = QueryServiceHelper.query((String)"pdm_route", (String)"id,routeversion", (QFilter[])new QFilter("createorg", "in", initOrgSet).toArray());
        ArrayList idVersionSplitList = new ArrayList(16);
        HashMap<String, Long> idVersionInitMap = new HashMap<String, Long>(16);
        for (int i = 0; i < routes.size(); ++i) {
            if (i % 100 == 0 && !idVersionInitMap.isEmpty()) {
                HashMap<String, Long> hashMap = new HashMap<String, Long>(16);
                hashMap.putAll(idVersionInitMap);
                idVersionInitMap.clear();
                idVersionSplitList.add(hashMap);
            }
            DynamicObject dynamicObject = (DynamicObject)routes.get(i);
            idVersionInitMap.put(dynamicObject.get("id").toString(), dynamicObject.getLong("routeversion"));
        }
        idVersionSplitList.add(idVersionInitMap);
        for (Map map : idVersionSplitList) {
            DynamicObject[] qmcRoutes;
            QFilter qFilter = new QFilter("manurouteid", "in", map.keySet());
            qFilter.and("origin", "=", (Object)"A");
            for (DynamicObject qmcRoute : qmcRoutes = BusinessDataServiceHelper.load((String)"qcbd_qmcroute", (String)"id,routeversion,manurouteid,origin", (QFilter[])qFilter.toArray())) {
                String manuRouteId = qmcRoute.getString("manurouteid");
                if (!map.containsKey(manuRouteId)) continue;
                Long versionId = (Long)map.get(manuRouteId);
                qmcRoute.set("routeversion", (Object)versionId);
            }
            SaveServiceHelper.save((DynamicObject[])qmcRoutes);
        }
        return evt.getEventId();
    }
}

