/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.importop;

import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.SAXParserFactory;
import kd.bos.impt.SheetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class InspectCkValCommonReader {
    public void read(InputStream in, SheetHandler sheetHandler) throws Exception {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        OPCPackage pkg = OPCPackage.open((File)tempFile);
        XSSFReader r = new XSSFReader(pkg);
        sheetHandler.setSharedStringsTable((SharedStringsTable)r.getSharedStringsTable());
        sheetHandler.setStylesTable(r.getStylesTable());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setContentHandler((ContentHandler)sheetHandler);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        while (sheets.hasNext()) {
            InputStream sheet = sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            if (!"sheet2".equals(sheets.getSheetName())) continue;
            sheetHandler.setSheetName(sheets.getSheetName());
            Comments sheetComments = sheets.getSheetComments();
            if (sheetComments instanceof CommentsTable) {
                sheetHandler.addSheetComments(sheets.getSheetName(), (CommentsTable)sheetComments);
            }
            xmlReader.parse(sheetSource);
            sheet.close();
            if (!sheetHandler.isInterrupt()) continue;
            break;
        }
    }
}

