/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.importop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.util.InspFormatUtil;
import kd.qmc.qcbd.opplugin.importop.InspectCommonExportSheetHandler;

public class InspectCommonExportOp
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InspectCommonExportOp.class);
    private static final String EXPORT_TYPE = "exportType";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String[] FIELDKEY_ARR = new String[]{"org.number", "billno", "materialcfg.seq", "materialcfg.number", "materialcfg.name", "materialid.materialtype", "materialid.modelnum", "inspectionstd.seq", "inspectionitem.number", "inspectionitem.name", "inspectioncontent", "samplenum.seq", "samplenum", "measuredval", "measuredval_judge"};
    private static final DataType[] DATATYPE_ARR = new DataType[]{DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType};
    public static final String MATERIALTYPE = "materialtype";
    public static final String MODELNUM = "modelnum";
    private String exportType;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("exportlist_expt".equalsIgnoreCase(operateKey) || "exportlist".equalsIgnoreCase(operateKey)) {
            this.getPageCache().put(EXPORT_TYPE, operateKey);
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        IPageCache pageCache = this.getPageCache();
        String exportType = pageCache.get(EXPORT_TYPE);
        if (StringUtils.isNotEmpty((String)exportType)) {
            pageCache.remove(EXPORT_TYPE);
            this.exportType = exportType;
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        this.getCalValSet(e.getQueryValues());
    }

    public void afterExportFile(ExportFileEvent e) {
        if (null == this.exportType) {
            return;
        }
        File file = e.getFile();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ExcelReader excelReader = new ExcelReader();
            excelReader.read((InputStream)fis, (SheetHandler)new InspectCommonExportSheetHandler(file, this.exportType, this.getPageCache().get("submeasuredvalentity")));
            fis.close();
        }
        catch (Exception fileNotFoundException) {
            throw new KDException((Throwable)fileNotFoundException, new ErrorCode("InspectCommonExportOp", ExceptionUtils.getExceptionStackTraceMessage((Exception)fileNotFoundException)), new Object[0]);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioException) {
                    logger.info(ioException.getMessage());
                }
            }
        }
    }

    private void getCalValSet(DynamicObject[] billObjArr) {
        QFilter[] ckValFilter;
        String entityName;
        Set billIdSet = Arrays.stream(billObjArr).map(x -> x.getPkValue()).collect(Collectors.toSet());
        IDataEntityType dataEntityType = billObjArr[0].getDataEntityType();
        String algoKey = ((Object)((Object)this)).getClass().getName();
        DataSet ckValSet = this.getSubMeasureSet(algoKey, entityName = dataEntityType.getName(), ckValFilter = new QFilter("id", "in", billIdSet).toArray());
        if (ckValSet.isEmpty()) {
            return;
        }
        List<Row> inspSubList = this.getInspSubSeq(algoKey, entityName, ckValFilter);
        List<Row> sampSubList = this.getSampleSeq(algoKey, entityName, ckValFilter);
        DataSetBuilder dataSetBuilder = this.getDataSetBuilder();
        while (ckValSet.hasNext()) {
            Row row = ckValSet.next();
            String projUuidKey = String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "projuuid");
            String exampleIdKey = String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "exmapleid");
            String uuid = row.getString(projUuidKey);
            Long exampleId = row.getLong(exampleIdKey);
            if (StringUtils.isEmpty((String)uuid) || null == exampleId || exampleId.equals(0L)) continue;
            String uquuidKey = String.format("%s.%s.%s", "matintoentity", "inspsubentity", "uquuid");
            Optional<Row> inspFirst = inspSubList.stream().filter(x -> uuid.equals(x.getString(uquuidKey))).findFirst();
            String sampleIdKey = String.format("%s.%s.%s", "matintoentity", "subsampleresentity", "samplenumid");
            Optional<Row> sampleFirst = sampSubList.stream().filter(x -> exampleId.equals(x.getLong(sampleIdKey))).findFirst();
            if (!inspFirst.isPresent() || !sampleFirst.isPresent()) continue;
            Row inspRow = inspFirst.get();
            Row sampRow = sampleFirst.get();
            Object[] newRow = this.setRowValues(row, inspRow, sampRow);
            dataSetBuilder.append(newRow);
        }
        String[] orderByStr = new String[]{String.format("%s desc", FIELDKEY_ARR[1]), FIELDKEY_ARR[2], FIELDKEY_ARR[7], FIELDKEY_ARR[11]};
        DataSet orderBySet = dataSetBuilder.build().orderBy(orderByStr);
        this.cachedDataSet(orderBySet, "submeasuredvalentity");
        this.clearCacheSet("inspsubentity");
        this.clearCacheSet("subsampleresentity");
    }

    private Object[] setRowValues(Row row, Row inspRow, Row sampRow) {
        Object[] newRow = new Object[FIELDKEY_ARR.length];
        newRow[0] = row.getString(String.format("%s.%s", "org", NUMBER));
        newRow[1] = row.getString(String.format("%s", "billno"));
        newRow[2] = row.getInteger(String.format("%s.%s", "matintoentity", "seq"));
        newRow[3] = row.getString(String.format("%s.%s.%s", "matintoentity", "materialid", NUMBER));
        newRow[4] = row.getString(String.format("%s.%s.%s", "matintoentity", "materialid", NAME));
        newRow[5] = row.getString(String.format("%s.%s.%s", "matintoentity", "materialid", MATERIALTYPE));
        newRow[6] = row.getString(String.format("%s.%s.%s", "matintoentity", "materialid", MODELNUM));
        newRow[7] = inspRow.getInteger(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "seq"));
        newRow[8] = inspRow.getString(String.format("%s.%s.%s.%s", "matintoentity", "inspsubentity", "inspectionitem", NUMBER));
        newRow[9] = inspRow.getString(String.format("%s.%s.%s.%s", "matintoentity", "inspsubentity", "inspectionitem", NAME));
        newRow[10] = inspRow.getString(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "inspectioncontent"));
        newRow[11] = sampRow.getInteger(String.format("%s.%s.%s", "matintoentity", "subsampleresentity", "seq"));
        newRow[12] = sampRow.getString(String.format("%s.%s.%s", "matintoentity", "subsampleresentity", "samplenum"));
        String normType = inspRow.getString(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "normtype"));
        String measureVal = null;
        measureVal = "A".equals(normType) ? row.getString(String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "measuredval_rat")) : row.getString(String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "measuredval_deter"));
        newRow[13] = measureVal;
        newRow[14] = InspFormatUtil.translater((String)row.getString(String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "measuredval_judge")));
        return newRow;
    }

    private DataSet getSubMeasureSet(String algoKey, String entityName, QFilter[] ckValFilter) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s,", "id"));
        sb.append(String.format("%s.%s,", "org", NUMBER));
        sb.append(String.format("%s,", "billno"));
        sb.append(String.format("%s.%s,", "matintoentity", "seq"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "materialid", NUMBER));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "materialid", NAME));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "materialid", MATERIALTYPE));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "materialid", MODELNUM));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "submeasuredvalentity", "projuuid"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "submeasuredvalentity", "exmapleid"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "submeasuredvalentity", "measuredval_deter"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "submeasuredvalentity", "measuredval_rat"));
        sb.append(String.format("%s.%s.%s", "matintoentity", "submeasuredvalentity", "measuredval_judge"));
        String orderByStr = String.format("%s, %s.%s", "id", "matintoentity", "seq");
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sb.toString(), (QFilter[])ckValFilter, (String)orderByStr);
    }

    private List<Row> getInspSubSeq(String algoKey, String entityName, QFilter[] ckValFilter) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s.%s.%s,", "matintoentity", "inspsubentity", "uquuid"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "inspsubentity", "seq"));
        sb.append(String.format("%s.%s.%s.%s,", "matintoentity", "inspsubentity", "inspectionitem", NUMBER));
        sb.append(String.format("%s.%s.%s.%s,", "matintoentity", "inspsubentity", "inspectionitem", NAME));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "inspsubentity", "inspectioncontent"));
        sb.append(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "normtype"));
        String orderByStr = String.format("%s.%s.%s, %s.%s.%s", "matintoentity", "inspsubentity", "uquuid", "matintoentity", "inspsubentity", "seq");
        DataSet inspSubSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sb.toString(), (QFilter[])ckValFilter, (String)orderByStr);
        CachedDataSet inspCacheSet = this.cachedDataSet(inspSubSet, "inspsubentity");
        return inspCacheSet.getList(0, inspCacheSet.getRowCount());
    }

    private List<Row> getSampleSeq(String algoKey, String entityName, QFilter[] ckValFilter) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s.%s.%s,", "matintoentity", "subsampleresentity", "samplenumid"));
        sb.append(String.format("%s.%s.%s,", "matintoentity", "subsampleresentity", "seq"));
        sb.append(String.format("%s.%s.%s", "matintoentity", "subsampleresentity", "samplenum"));
        String orderByStr = String.format("%s.%s.%s", "matintoentity", "subsampleresentity", "samplenumid");
        DataSet sampleSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)sb.toString(), (QFilter[])ckValFilter, (String)orderByStr);
        CachedDataSet sampCacheSet = this.cachedDataSet(sampleSet, "subsampleresentity");
        return sampCacheSet.getList(0, sampCacheSet.getRowCount());
    }

    private CachedDataSet cachedDataSet(DataSet dataSet, String cacheKey) {
        CacheHint hint = new CacheHint();
        hint.setTimeout(3600000L);
        CachedDataSet cacheDataSet = dataSet.cache(hint);
        this.getPageCache().put(cacheKey, cacheDataSet.getCacheId());
        return cacheDataSet;
    }

    private void clearCacheSet(String cacheKey) {
        IPageCache pageCache = this.getPageCache();
        String cacheId = pageCache.get(cacheKey);
        Algo.removeCacheDataSet((String)cacheId);
        pageCache.remove(cacheKey);
    }

    private DataSetBuilder getDataSetBuilder() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDKEY_ARR, (DataType[])DATATYPE_ARR);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
    }
}

