/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.importop;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.xml.sax.SAXException;

public class InspectCommonExportSheetHandler
extends SheetHandler {
    private static final Log logger = LogFactory.getLog(InspectCommonExportSheetHandler.class);
    private SXSSFWorkbook book;
    private final List<SXSSFSheet> sheets = new LinkedList<SXSSFSheet>();
    private static final int CACHE_SIZE = 10000;
    private static final int MAX_COL_NUM = 10000;
    private static final String EXPORT_LIST = "exportlist";
    private final File file;
    private final String exportType;
    BufferedOutputStream bos;
    private final Map styles = new HashMap();
    private CellStyle mustInputHead;
    private CellStyle chooseInputHead;
    private int rowNum = 0;
    private String cacheId;

    public InspectCommonExportSheetHandler(File file, String exportType, String cacheId) {
        this.file = file;
        this.exportType = exportType;
        this.cacheId = cacheId;
    }

    public void handleRow(SheetHandler.ParsedRow oldRow) {
        Map oldRowData;
        if (this.sheets.isEmpty()) {
            if (null == this.book) {
                this.book = new SXSSFWorkbook(10000);
            }
            SXSSFSheet sheet0 = this.book.createSheet(oldRow.getSheetName());
            sheet0.setColumnWidth(0, 10000);
            this.sheets.add(sheet0);
        }
        if (CollectionUtils.isEmpty((Map)(oldRowData = oldRow.getData()))) {
            return;
        }
        SXSSFRow newRow = this.sheets.get(0).createRow(this.rowNum);
        Map types = oldRow.getTypes();
        Map styles = oldRow.getStyles();
        List sortedIndex = oldRowData.keySet().stream().sorted().collect(Collectors.toList());
        for (Integer index : sortedIndex) {
            JSONObject styleObj = (JSONObject)styles.get(index);
            String cellValue = (String)oldRowData.get(index);
            if (EXPORT_LIST.equals(this.exportType) && 1 == this.rowNum && 0 == index) {
                String[] comments = cellValue.split("\r\n");
                LinkedList<String> valueList = new LinkedList<String>();
                Collections.addAll(valueList, comments);
                valueList.add(ResManager.loadKDString((String)"\u5bfc\u5165\u5b9e\u6d4b\u503c\u6570\u636e\u9700\u7ef4\u62a4sheet2\u9875\u7b7e\u3002\u5b9e\u6d4b\u503c\u8bf7\u6309\u68c0\u9a8c\u6807\u51c6\u5206\u5f55\u884c\u548c\u6837\u672c\u5206\u5f55\u884c\u8fdb\u884c\u5bf9\u5e94\uff08\u68c0\u9a8c\u6807\u51c6\u5206\u5f55\u884c\u5e8f\u53f7\u8bf7\u53c2\u7167\u201c\u57fa\u7840\u8d44\u6599\uff1e\u68c0\u9a8c\u6807\u51c6\u201d\uff0c\u6837\u672c\u5206\u5f55\u884c\u53f7\u8bf7\u53c2\u7167sheet1\u9875\u7b7e\u6837\u672c\u7f16\u53f7\u987a\u5e8f\uff09\u3002", (String)"InspectCommonExportSheetHandler_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
                cellValue = String.join((CharSequence)"\r\n", valueList);
            }
            this.dealHeadStyle(this.rowNum, index, styleObj, cellValue);
            CellType cellType = this.convertCellType((SheetHandler.XSSFDataType)types.get(index), styleObj.getString("fmt"));
            SXSSFCell cell = newRow.createCell(index.intValue(), cellType);
            this.setCellValue(cell, styleObj, cellValue);
        }
        ++this.rowNum;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.addCkValSheet();
        try {
            this.bos = new BufferedOutputStream(new FileOutputStream(this.file));
            this.book.write((OutputStream)this.bos);
            this.book.dispose();
            this.book.close();
            this.bos.close();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("InspectCommonExportSheetHandler", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), new Object[0]);
        }
        finally {
            if (null != this.bos) {
                try {
                    this.bos.close();
                    Algo.removeCacheDataSet((String)this.cacheId);
                }
                catch (IOException e) {
                    logger.info(e.getMessage());
                }
            }
        }
    }

    private void addCkValSheet() {
        SXSSFSheet ckValSheet = this.book.createSheet("sheet2");
        ckValSheet.setColumnWidth(0, 10000);
        this.sheets.add(ckValSheet);
        int rowNum = 0;
        rowNum = this.addCkValHead(ckValSheet, rowNum);
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)this.cacheId);
        DataSet ckValSet = cacheDataSet.toDataSet(Algo.create((String)((Object)((Object)this)).getClass().getName()), Boolean.TRUE.booleanValue());
        Field[] fields = cacheDataSet.getRowMeta().getFields();
        int length = fields.length;
        while (ckValSet.hasNext()) {
            Row dataRow = ckValSet.next();
            SXSSFRow excelRow = ckValSheet.createRow(rowNum++);
            for (int i = 0; i < length; ++i) {
                Object value = dataRow.get(i);
                excelRow.createCell(i).setCellValue(null == value ? "" : String.valueOf(value));
            }
        }
    }

    private void createCkValHeadCell(SXSSFRow nameRow, int index, String cellValue, boolean isMustInput) {
        SXSSFCell cell = nameRow.createCell(index);
        cell.setCellValue(cellValue);
        if (isMustInput) {
            cell.setCellStyle(this.mustInputHead);
        } else {
            cell.setCellStyle(this.chooseInputHead);
        }
        this.sheets.get(1).setColumnWidth(index, ImportHelper.calcColumnWidth((String)cellValue, (int)0));
    }

    private CellType convertCellType(SheetHandler.XSSFDataType xssfDataType, String fmt) {
        if (xssfDataType != null) {
            switch (xssfDataType) {
                case BOOL: {
                    return CellType.BOOLEAN;
                }
                case ERROR: {
                    return CellType.ERROR;
                }
                case FORMULA: {
                    return CellType.FORMULA;
                }
                case INLINESTR: 
                case SSTINDEX: {
                    if (StringUtils.isNotBlank((CharSequence)fmt)) {
                        return CellType.NUMERIC;
                    }
                    return CellType.STRING;
                }
                case NUMBER: {
                    return CellType.NUMERIC;
                }
            }
            return CellType.BLANK;
        }
        return CellType.BLANK;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort("color");
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = (CellStyle)this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable var3) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private void setCellValue(SXSSFCell cell, JSONObject styleObj, String cellValue) {
        String fmt = styleObj.getString("fmt");
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            try {
                cell.setCellValue(new BigDecimal(cellValue).doubleValue());
            }
            catch (Throwable var13) {
                cell.setCellValue(cellValue);
            }
        } else {
            cell.setCellValue(cellValue);
        }
        cell.setCellStyle(this.getCellStyle(styleObj));
    }

    private void dealHeadStyle(int rowNum, Integer index, JSONObject styleObj, String cellValue) {
        if (1 == rowNum && EXPORT_LIST.equals(this.exportType)) {
            styleObj.put("color", (Object)IndexedColors.RED.getIndex());
            this.sheets.get(0).setColumnWidth(index.intValue(), ImportHelper.calcColumnWidth((String)cellValue, (int)0));
        } else {
            boolean isDataRow;
            boolean bl = isDataRow = 3 == rowNum && EXPORT_LIST.equals(this.exportType) || 0 == rowNum && "exportlist_expt".equals(this.exportType);
            if (!isDataRow) {
                return;
            }
            styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
            if (cellValue.startsWith("*")) {
                styleObj.put("color", (Object)IndexedColors.RED.getIndex());
                if (null == this.mustInputHead) {
                    this.mustInputHead = this.getCellStyle(styleObj);
                }
            } else if (null == this.chooseInputHead) {
                this.chooseInputHead = this.getCellStyle(styleObj);
            }
            this.sheets.get(0).setColumnWidth(index.intValue(), ImportHelper.calcColumnWidth((String)cellValue, (int)0));
        }
    }

    private int addCkValHead(SXSSFSheet ckValSheet, int rowNum) {
        SXSSFRow idRow = ckValSheet.createRow(rowNum++);
        int index = 0;
        idRow.createCell(index++).setCellValue("org.number");
        idRow.createCell(index++).setCellValue("billno");
        idRow.createCell(index++).setCellValue("materialcfg.seq");
        idRow.createCell(index++).setCellValue("materialcfg.number");
        idRow.createCell(index++).setCellValue("materialcfg.name");
        idRow.createCell(index++).setCellValue("materialid.materialtype");
        idRow.createCell(index++).setCellValue("materialid.modelnum");
        idRow.createCell(index++).setCellValue("inspectionstd.seq");
        idRow.createCell(index++).setCellValue("inspectionitem.number");
        idRow.createCell(index++).setCellValue("inspectionitem.name");
        idRow.createCell(index++).setCellValue("inspectioncontent");
        idRow.createCell(index++).setCellValue("samplenum.seq");
        idRow.createCell(index++).setCellValue("samplenum");
        idRow.createCell(index++).setCellValue("measuredval");
        idRow.createCell(index++).setCellValue("measuredval_judge");
        SXSSFRow nameRow = ckValSheet.createRow(rowNum++);
        index = 0;
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"*\u8d28\u68c0\u7ec4\u7ec7", (String)"InspectCommonExportSheetHandler_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), true);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"*\u5355\u636e\u7f16\u53f7", (String)"InspectCommonExportSheetHandler_2", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), true);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"*\u7269\u6599\u5206\u5f55\u884c\u53f7", (String)"InspectCommonExportSheetHandler_3", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), true);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"InspectCommonExportSheetHandler_4", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"InspectCommonExportSheetHandler_5", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u7269\u6599\u7c7b\u578b", (String)"InspectCommonExportSheetHandler_6", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"InspectCommonExportSheetHandler_7", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"*\u68c0\u9a8c\u6807\u51c6\u5206\u5f55\u884c\u53f7", (String)"InspectCommonExportSheetHandler_8", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), true);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u68c0\u9a8c\u9879\u76ee\u7f16\u7801", (String)"InspectCommonExportSheetHandler_9", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u68c0\u9a8c\u9879\u76ee\u540d\u79f0", (String)"InspectCommonExportSheetHandler_10", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u68c0\u9a8c\u5185\u5bb9", (String)"InspectCommonExportSheetHandler_11", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"*\u6837\u672c\u5206\u5f55\u884c\u53f7", (String)"InspectCommonExportSheetHandler_12", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), true);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u6837\u672c\u7f16\u53f7", (String)"InspectCommonExportSheetHandler_13", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c", (String)"InspectCommonExportSheetHandler_14", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        this.createCkValHeadCell(nameRow, index++, ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c\u5224\u5b9a\u7ed3\u679c", (String)"InspectCommonExportSheetHandler_15", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), false);
        return rowNum;
    }
}

