/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.importop;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.util.InspFormatUtil;
import org.xml.sax.SAXException;

public class InspectCommonImportSheetHandler
extends BatchImportSheetHandler {
    Map<String, List<Map<String, Object>>> ckValMap;
    private int orgIndex = -1;
    private int billNoIndex = -1;
    private int matSeqIndex = -1;
    private int inspSeqIndex = -1;
    private int sampSeqIndex = -1;
    private int measureValIndex = -1;
    private int measureJudIndex = -1;
    private boolean haveAllIndex;
    private final List<String> errRowIndex = new LinkedList<String>();
    List<String> errList;

    public InspectCommonImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url, Map<String, Object> option, Map<String, List<Map<String, Object>>> ckValMap, List<String> errList) {
        super(ctx, mainEntityType, url, option, new HeartBeat());
        this.ckValMap = ckValMap;
        this.errList = errList;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.initIdRow(row);
        this.checkIndex(row);
        this.addCkVals(row);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (!this.errRowIndex.isEmpty()) {
            String errStr = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199sheet2\u7b2c%s\u884c\u5fc5\u5f55\u9879\u3002", (String)"InspectCommonImportSheetHandler_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", this.errRowIndex));
            this.errList.add(errStr);
        }
    }

    private boolean isDataLegal(SheetHandler.ParsedRow row) {
        String org = row.get(Integer.valueOf(this.orgIndex));
        String billNo = row.get(Integer.valueOf(this.billNoIndex));
        String matSeq = row.get(Integer.valueOf(this.matSeqIndex));
        String inspSeq = row.get(Integer.valueOf(this.inspSeqIndex));
        String sampSeq = row.get(Integer.valueOf(this.sampSeqIndex));
        if (StringUtils.isEmpty((String)org) || StringUtils.isEmpty((String)billNo) || StringUtils.isEmpty((String)matSeq) || StringUtils.isEmpty((String)inspSeq) || StringUtils.isEmpty((String)sampSeq)) {
            this.errRowIndex.add(String.valueOf(row.getRowNum() + 1));
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getCkValList(SheetHandler.ParsedRow row) {
        String org = row.get(Integer.valueOf(this.orgIndex));
        String billNo = row.get(Integer.valueOf(this.billNoIndex));
        String matSeq = row.get(Integer.valueOf(this.matSeqIndex));
        String inspSeq = row.get(Integer.valueOf(this.inspSeqIndex));
        String key = org + "-" + billNo + "-" + matSeq + "-" + inspSeq;
        if (this.ckValMap.containsKey(key)) {
            return this.ckValMap.get(key);
        }
        LinkedList<Map<String, Object>> ckValList = new LinkedList<Map<String, Object>>();
        this.ckValMap.put(key, ckValList);
        return ckValList;
    }

    private void addCkVals(SheetHandler.ParsedRow row) {
        if (row.getSheetName().equals("sheet2") && this.haveAllIndex && row.getRowNum() > 1) {
            boolean isLagal = this.isDataLegal(row);
            if (!isLagal) {
                return;
            }
            List<Map<String, Object>> ckValList = this.getCkValList(row);
            String sampSeqStr = row.get(Integer.valueOf(this.sampSeqIndex));
            if (!StringUtils.isNumericString((String)sampSeqStr) || new BigDecimal(sampSeqStr).compareTo(new BigDecimal(10000)) > 0) {
                return;
            }
            int sampSeq = Integer.parseInt(sampSeqStr);
            int emptySampSize = sampSeq - ckValList.size() - 1;
            if (emptySampSize < 0) {
                Map<String, Object> valMap = ckValList.get(sampSeq - 1);
                if (!valMap.isEmpty()) {
                    Object errInfo = valMap.get("example_errinfo");
                    String errStr = String.format(ResManager.loadKDString((String)" \u5b9e\u6d4b\u503c(%s)\u91cd\u590d", (String)"InspectCommonImportSheetHandler_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), sampSeq);
                    if (null == errInfo) {
                        valMap.put("example_errinfo", errStr);
                    } else if (!errInfo.toString().contains(errStr)) {
                        valMap.put("example_errinfo", errInfo + ";" + errStr);
                    }
                } else {
                    valMap.put("exampleval", null == row.get(Integer.valueOf(this.measureValIndex)) ? "" : row.get(Integer.valueOf(this.measureValIndex)));
                    valMap.put("examplevalres", InspFormatUtil.translater((String)row.get(Integer.valueOf(this.measureJudIndex))));
                }
            } else {
                for (int i = 0; i < emptySampSize; ++i) {
                    ckValList.add(new HashMap(16));
                }
                HashMap<String, String> valMap = new HashMap<String, String>(16);
                valMap.put("exampleval", null == row.get(Integer.valueOf(this.measureValIndex)) ? "" : row.get(Integer.valueOf(this.measureValIndex)));
                valMap.put("examplevalres", InspFormatUtil.translater((String)row.get(Integer.valueOf(this.measureJudIndex))));
                ckValList.add(valMap);
            }
        }
    }

    private void checkIndex(SheetHandler.ParsedRow row) {
        if (row.getSheetName().equals("sheet2") && 1 == row.getRowNum() && -1 != this.orgIndex && -1 != this.billNoIndex && -1 != this.matSeqIndex && -1 != this.inspSeqIndex && -1 != this.sampSeqIndex && -1 != this.measureValIndex && -1 != this.measureJudIndex) {
            this.haveAllIndex = true;
        }
    }

    private void initIdRow(SheetHandler.ParsedRow row) {
        if (row.getSheetName().equals("sheet2") && 0 == row.getRowNum()) {
            Map idRowMap = row.getData();
            idRowMap.forEach(this::initIndex);
        }
    }

    private void initIndex(Integer index, String value) {
        switch (value) {
            case "org.number": {
                this.orgIndex = index;
                break;
            }
            case "billno": {
                this.billNoIndex = index;
                break;
            }
            case "materialcfg.seq": {
                this.matSeqIndex = index;
                break;
            }
            case "inspectionstd.seq": {
                this.inspSeqIndex = index;
                break;
            }
            case "samplenum.seq": {
                this.sampSeqIndex = index;
                break;
            }
            case "measuredval": {
                this.measureValIndex = index;
                break;
            }
            case "measuredval_judge": {
                this.measureJudIndex = index;
                break;
            }
        }
    }
}

