/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.importop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.SheetHandler;
import kd.qmc.qcbd.opplugin.importop.InspectCkValCommonReader;
import kd.qmc.qcbd.opplugin.importop.InspectCommonImportSheetHandler;

public class InspectImportOp
extends BatchImportPlugin {
    private final Map<String, List<Map<String, Object>>> ckValMap = new HashMap<String, List<Map<String, Object>>>(16);
    private final List<String> errList = new LinkedList<String>();

    public List<ComboItem> getOverrideFieldsConfig() {
        List list = super.getOverrideFieldsConfig();
        ArrayList<ComboItem> newList = new ArrayList<ComboItem>(list.size());
        for (ComboItem c : list) {
            if ("id".equals(c.getValue())) continue;
            newList.add(c);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InspectCkValCommonReader reader = new InspectCkValCommonReader();
        Map option = this.ctx.getOption();
        for (String url : this.ctx.getAllUrls()) {
            InputStream in = service.getInputStream(url);
            try {
                reader.read(in, (SheetHandler)new InspectCommonImportSheetHandler(this.ctx, this.mainEntityType, url, option, this.ckValMap, this.errList));
            }
            catch (Exception e) {
                this.ctx.getLogger(url).log(Integer.valueOf(0), e.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), e.getMessage());
                }
            }
        }
        super.resolveExcel();
    }

    protected ApiResult save(List<ImportBillData> billdatas, ImportLogger logger) {
        if (!this.errList.isEmpty()) {
            logger.log(Integer.valueOf(0), this.errList.get(0));
            logger.fail();
            return null;
        }
        for (ImportBillData billData : billdatas) {
            this.addCkValue(billData);
        }
        return super.save(billdatas, logger);
    }

    private void addCkValue(ImportBillData billData) {
        JSONObject data = billData.getData();
        Object orgObj = data.get((Object)"org");
        if (!(orgObj instanceof Map)) {
            return;
        }
        Object orgNumber = ((Map)orgObj).get("number");
        String billNo = data.getString("billno");
        Object matEntry = data.get((Object)"matintoentity");
        if (matEntry instanceof List) {
            List matList = (List)matEntry;
            int matSize = matList.size();
            for (int i = 0; i < matSize; ++i) {
                Object matRow = matList.get(i);
                int matSeq = i + 1;
                if (!(matRow instanceof Map)) continue;
                Map matMap = (Map)matRow;
                this.addMatCkValue(orgNumber, billNo, matSeq, matMap);
            }
        }
    }

    private void addMatCkValue(Object orgNumber, String billNo, int matSeq, Map matMap) {
        Object inspEntry = matMap.get("inspsubentity");
        if (inspEntry instanceof List) {
            List inspList = (List)inspEntry;
            int inspSize = inspList.size();
            for (int j = 0; j < inspSize; ++j) {
                Object inspObj;
                int inspSeq = j + 1;
                String key = orgNumber + "-" + billNo + "-" + matSeq + "-" + inspSeq;
                List<Map<String, Object>> ckValues = this.ckValMap.get(key);
                if (null == ckValues || !((inspObj = inspList.get(j)) instanceof Map)) continue;
                ((Map)inspObj).put("examples_tag", JSON.toJSONString(ckValues));
            }
        }
    }
}

