/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.inspecobj;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;
import kd.qmc.qcbd.business.commonmodel.helper.inspres.InspectResultHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspres.InspectResultProcessLogHelper;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.business.inspresult.InspResultExcute;
import kd.qmc.qcbd.common.args.insobj.DeleteInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.GlobalSaveInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveInspObjectEventArgs;
import kd.qmc.qcbd.common.constant.inspres.InspectResProLogConst;
import kd.qmc.qcbd.common.factory.InspObjectFactory;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.opplugin.evtservice.InspResultSendInfoEvt;
import kd.qmc.qcbd.opplugin.validator.TriggerInspResultValidator;

public class TriggerInspObjectOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(TriggerInspObjectOp.class);
    private static final String TRUESTR = "true";
    private InspObjectFactory mInspObjectSevice;
    private static final String[] needRunArr = new String[]{"inspect", "baddeal", "urgentpass"};

    private InspObjectFactory getInspObjectFactory() {
        String formId = this.billEntityType.getName();
        logger.info("getInspObjectFactory begin formid = :" + formId);
        if (this.mInspObjectSevice == null) {
            logger.info("getInspObjectFactory begin query service formid = :" + formId);
            this.mInspObjectSevice = InspObjectHelper.getInspObjectFactory((String)formId);
        }
        logger.info("getInspObjectFactory begin query service mInspObjectSevice = :" + JSON.toJSONString((Object)this.mInspObjectSevice));
        return this.mInspObjectSevice;
    }

    public void beforeOnPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void beforeOnAddValidators(AddValidatorsEventArgs e) {
        InspObjectFactory factory = this.getInspObjectFactory();
        if (factory != null && this.isNeedRun(factory.getBillFlag())) {
            this.getOption().setVariableValue("trigger_appid", this.billEntityType.getAppId());
            e.addValidator((AbstractValidator)new TriggerInspResultValidator());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.mInspObjectSevice = this.getInspObjectFactory();
        if (this.mInspObjectSevice != null) {
            IniInspObjectEventArgs argModel = new IniInspObjectEventArgs(this.billEntityType.getAppId());
            argModel.setFormId(this.billEntityType.getName());
            this.mInspObjectSevice.iniInspObject(argModel);
        }
        this.beforeOnAddValidators(e);
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("srcunitid");
        if (this.inspresultExcute()) {
            e.getFieldKeys().add("chkobjid");
            e.getFieldKeys().add("inspfirstentrykey");
            e.getFieldKeys().add("biztype");
            logger.info("call getInspObjectFactory from onPreparePropertys");
            if (this.mInspObjectSevice != null && StringUtils.equalsIgnoreCase((CharSequence)"baddeal", (CharSequence)this.mInspObjectSevice.getBillFlag())) {
                e.getFieldKeys().add("handmethed");
            }
            if (this.mInspObjectSevice != null && StringUtils.equalsIgnoreCase((CharSequence)"inspect", (CharSequence)this.mInspObjectSevice.getBillFlag())) {
                e.getFieldKeys().add("qualiqty");
                e.getFieldKeys().add("id");
                e.getFieldKeys().add("chkobjentryid");
                e.getFieldKeys().add("chkobjid");
                e.getFieldKeys().add("basequaliqty");
                e.getFieldKeys().add("samplingresult");
            }
            this.beforeOnPreparePropertys(e);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey;
        switch (operationKey = e.getOperationKey()) {
            case "unaudit": {
                this.inspResultExcuteBegin(e);
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        InspObjectFactory factory = this.getInspObjectFactory();
        if (factory == null || e.getDataEntities() == null) {
            return;
        }
        switch (operationKey) {
            case "submit": {
                if (InspObjectHelper.isOperateOnList((OperateOption)this.getOption()).booleanValue()) break;
                this.saveInspObject(e, factory);
                break;
            }
            case "save": {
                this.saveInspObject(e, factory);
                break;
            }
            case "delete": {
                this.deleteInspObject(e, factory);
                break;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey;
        super.endOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "save": 
            case "submit": {
                this.validSbillStatus(e.getDataEntities());
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        InspObjectFactory factory = this.getInspObjectFactory();
        if (factory == null) {
            return;
        }
        String billFlag = factory.getBillFlag();
        InspResultExcute inspResultExcute = null;
        if (this.inspresultExcute()) {
            inspResultExcute = new InspResultExcute(this.billEntityType);
            inspResultExcute.mainAfterExecuteOperationTransaction((AbstractOperationServicePlugIn)this);
        }
        switch (operationKey) {
            case "audit": 
            case "unaudit": {
                if (!this.isNeedRun(billFlag)) break;
                InspectResultProcessLogHelper.batchInsertNew((DynamicObject[])e.getDataEntities(), (String)e.getOperationKey());
                String dealByEventCenter = ParameterUtil.getQmcSystemProp((String)"dealInspResultWithoutEventCent", (String)this.billEntityType.getAppId());
                if (TRUESTR.equalsIgnoreCase(dealByEventCenter)) {
                    JSONObject requestObj = InspectResultHelper.buildRequestObj((String)InspectResProLogConst.PROCESSOR_ENUM.S.name(), (String)billFlag, (String)operationKey, (DynamicObject[])e.getDataEntities());
                    InspResultSendInfoEvt.callhandleEvent(requestObj);
                    break;
                }
                WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService((String)"IWorkflowService");
                JSONObject requestObj = InspectResultHelper.buildRequestObj((String)InspectResProLogConst.PROCESSOR_ENUM.E.name(), (String)billFlag, (String)operationKey, (DynamicObject[])e.getDataEntities());
                JSONObject dockParam = requestObj.getJSONObject("dockParam");
                service.triggerEventSubscribe(dockParam.getString("event"), requestObj.toJSONString());
                break;
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        String triggerAfterExecute = this.getOption().getVariableValue("trigger_after_execute", "");
        if (this.inspresultExcute() && !StringUtils.equalsIgnoreCase((CharSequence)triggerAfterExecute, (CharSequence)TRUESTR)) {
            new InspResultExcute(this.billEntityType).mainRollbackResOperation((AbstractOperationServicePlugIn)this);
        }
    }

    private void saveInspObject(BeginOperationTransactionArgs e, InspObjectFactory factory) {
        GlobalSaveInspObjectEventArgs globalargs = new GlobalSaveInspObjectEventArgs();
        for (DynamicObject saveBillObj : e.getDataEntities()) {
            SaveInspObjectEventArgs saveInspArgs = new SaveInspObjectEventArgs();
            saveInspArgs.setOperator(e.getOperationKey());
            saveInspArgs.setBillEntityType(this.billEntityType);
            this.saveInspObject(e, saveInspArgs, factory, saveBillObj, globalargs);
            if (saveInspArgs.isCancle()) continue;
            SaveAssBillInfoEventArgs assArgs = new SaveAssBillInfoEventArgs();
            assArgs.setOperator(e.getOperationKey());
            assArgs.setSaveInspArgs(saveInspArgs);
            assArgs.setBillEntityType(this.billEntityType);
            this.saveAssBillInfo(e, assArgs, factory, saveBillObj, globalargs);
        }
        List billObjs = globalargs.getBillObjs();
        billObjs.addAll(DynamicObjUtil.getListObj((DynamicObject[])e.getDataEntities(), new HashMap(16)));
        factory.buildInspectSrcInfo(globalargs);
        factory.batchSaveInspObject(globalargs);
    }

    private void inspResultExcuteBegin(BeforeOperationArgs e) {
        if (this.inspresultExcute()) {
            new InspResultExcute(this.billEntityType).mainBeforeExecuteResOperationTransaction(e, (AbstractOperationServicePlugIn)this);
        }
    }

    private void deleteInspObject(BeginOperationTransactionArgs e, InspObjectFactory factory) {
        if (factory == null) {
            return;
        }
        DeleteInspObjectEventArgs args = new DeleteInspObjectEventArgs();
        args.setOperator(e.getOperationKey());
        args.setBillEntityType(this.billEntityType);
        List pkVals = DynamicObjUtil.getIDList((DynamicObject[])e.getDataEntities());
        args.setPkVals(pkVals);
        factory.beforeDeleteInspObject(args);
        if (!args.isCancle()) {
            factory.afterDeleteInspObject(args);
        }
    }

    private void saveInspObject(BeginOperationTransactionArgs e, SaveInspObjectEventArgs args, InspObjectFactory factory, DynamicObject saveBillObj, GlobalSaveInspObjectEventArgs globalargs) {
        args.setSaveBillID((Long)saveBillObj.getPkValue());
        args.setSaveBillObj(saveBillObj);
        factory.beforeSaveInspObject(args, globalargs);
        if (!args.isCancle()) {
            factory.afterSaveInspObject(args, globalargs);
        }
        if (args.isCancle()) {
            e.setCancelOperation(args.isCancle());
            throw new KDBizException(args.getMessage());
        }
    }

    private void saveAssBillInfo(BeginOperationTransactionArgs e, SaveAssBillInfoEventArgs args, InspObjectFactory factory, DynamicObject saveBillObj, GlobalSaveInspObjectEventArgs globalargs) {
        factory.structDeleteParams(saveBillObj, args);
        String deleteAssIDStr = this.getOption().getVariableValue("Option_DeleteAssID", "");
        if (StringUtils.isNotBlank((CharSequence)deleteAssIDStr)) {
            Set deleteAssIDs = (Set)JSON.parseObject((String)deleteAssIDStr, (TypeReference)new TypeReference<Set<Object>>(){}, (Feature[])new Feature[0]);
            args.setDeleteAssID(deleteAssIDs);
        }
        factory.beforeSaveAssBillInfo(args, globalargs);
        if (!args.isCancle()) {
            factory.afterSaveAssBillInfo(args, globalargs);
        }
        if (args.isCancle()) {
            e.setCancelOperation(args.isCancle());
            throw new KDBizException(args.getMessage());
        }
    }

    private boolean inspresultExcute() {
        Boolean inspresultExcuteFlag = false;
        String inspresultExcuteStr = this.getOption().getVariableValue("trigger_inspresult_excute", "");
        if (StringUtils.equalsIgnoreCase((CharSequence)inspresultExcuteStr, (CharSequence)TRUESTR)) {
            inspresultExcuteFlag = true;
        }
        return inspresultExcuteFlag;
    }

    private boolean isNeedRun(String billFlag) {
        return ArrayUtils.contains((Object[])needRunArr, (Object)billFlag);
    }

    private void validSbillStatus(DynamicObject[] dataEntity) {
        String checkSbillStatus = ParameterUtil.getQmcSystemProp((String)"checksbillstatus");
        if (!TRUESTR.equalsIgnoreCase(checkSbillStatus)) {
            return;
        }
        String entity = dataEntity[0].getDataEntityType().getName();
        String attrValue = ParameterUtil.getQmcSystemProp((String)"ignoresbillstatus_S", (String)entity);
        if (null != attrValue) {
            return;
        }
        Set<Long> billIds = Arrays.stream(dataEntity).map(x -> x.getLong("id")).collect(Collectors.toSet());
        this.checkSbillStatus(entity, billIds);
    }

    private void checkSbillStatus(String billEntity, Set<Long> billIdSet) {
        String ignoreSavecheck = ParameterUtil.getQmcSystemProp((String)"entity_ignore_savecheck", (String)billEntity);
        if (TRUESTR.equalsIgnoreCase(ignoreSavecheck)) {
            return;
        }
        List sourceBillBfs = BFTrackerServiceHelper.loadBillLinkUp((String)billEntity, (Long[])billIdSet.toArray(new Long[0]), (boolean)true);
        Map<String, HashSet<Long>> sourceBills = this.dealGetSourceSet(sourceBillBfs);
        for (Map.Entry<String, HashSet<Long>> entry : sourceBills.entrySet()) {
            HashSet<Long> sbillIdSet;
            String sbillEntity = entry.getKey();
            DynamicObjectCollection billStatus = QueryServiceHelper.query((String)sbillEntity, (String)"id, billstatus", (QFilter[])new QFilter("id", "in", sbillIdSet = entry.getValue()).toArray());
            if (billStatus.size() == sbillIdSet.size() && billStatus.stream().allMatch(x -> "C".equals(x.get("billstatus")))) continue;
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5bf9\u5e94\u7684\u4e0a\u6e38\u5355\u636e\u672a\u5ba1\u6838\u3002", (String)"TriggerInspObjectOp_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    private Map<String, HashSet<Long>> dealGetSourceSet(List<BFRow> sourceBillBfs) {
        HashMap<Long, String> idKeyMap = new HashMap<Long, String>(16);
        HashMap<String, HashSet<Long>> returnMap = new HashMap<String, HashSet<Long>>(16);
        for (BFRow bfRow : sourceBillBfs) {
            HashSet idSet;
            String entityKey;
            BFRowId rowId = bfRow.getSId();
            Long sid = rowId.getBillId();
            Long mainTableId = rowId.getMainTableId();
            if (!idKeyMap.containsKey(mainTableId)) {
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
                String entityNumber = tableDefine.getEntityNumber();
                idKeyMap.put(mainTableId, entityNumber);
            }
            if (returnMap.containsKey(entityKey = (String)idKeyMap.get(mainTableId))) {
                idSet = (HashSet)returnMap.get(entityKey);
                idSet.add(sid);
                returnMap.put(entityKey, idSet);
                continue;
            }
            idSet = new HashSet();
            idSet.add(sid);
            returnMap.put(entityKey, idSet);
        }
        return returnMap;
    }
}

