/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.inspectproop;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProDimenHelper;
import kd.qmc.qcbd.business.commonmodel.inspectpro.InspectProMatchHelper;
import kd.qmc.qcbd.opplugin.inspectproop.InspectProValidator;

public class InspectProOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("biztypeid");
        e.getFieldKeys().add("promatchdimen");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("setuptype");
        e.getFieldKeys().add("materielid");
        e.getFieldKeys().add("materieltype");
        e.getFieldKeys().add("supplier");
        String seq = "entryentity.seq";
        e.getFieldKeys().add(seq);
        e.getFieldKeys().add("qroute");
        e.getFieldKeys().add("processseq");
        e.getFieldKeys().add("operationno");
        e.getFieldKeys().add("subprojentry");
        Set profieldSet = InspectProDimenHelper.getProfieldAllDimen();
        for (String profield : profieldSet) {
            if (e.getFieldKeys().contains(profield)) continue;
            e.getFieldKeys().add(profield);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.validate(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InspectProValidator());
    }

    private void validate(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dynamicObject = ParameterReader.getBillParameter((String)"qcbd_inspectpro");
        boolean setValueOnly = (Boolean)dynamicObject.get("setvalueonly");
        if (!setValueOnly) {
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject bill = dataEntities[i];
            DataEntityPropertyCollection billProperties = bill.getDataEntityType().getProperties();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection dimens = bill.getDynamicObjectCollection("promatchdimen");
            String dimensName = dimens.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
            for (int m = 0; m < entrys.size() - 1; ++m) {
                DynamicObject entryOut = (DynamicObject)entrys.get(m);
                for (int n = m + 1; n < entrys.size(); ++n) {
                    DynamicObject entryIn = (DynamicObject)entrys.get(n);
                    boolean sameEntry = true;
                    for (DynamicObject dimen : dimens) {
                        DynamicObject dimenDetail = dimen.getDynamicObject("fbasedataid");
                        String proField = dimenDetail.getString("profield");
                        if (billProperties.containsKey((Object)proField)) continue;
                        if (!Objects.equals(entryIn.get(proField), entryOut.get(proField))) {
                            sameEntry = false;
                            break;
                        }
                        if (!StringUtils.equals((CharSequence)"materielid", (CharSequence)proField) || Objects.equals(entryIn.get("materieltype"), entryOut.get("materieltype")) && Objects.equals(entryIn.get("setuptype"), entryOut.get("setuptype"))) continue;
                        sameEntry = false;
                        break;
                    }
                    if (!sameEntry) continue;
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5339\u914d\u7ef4\u5ea6\u4e3a\u201c%1$s\u201d\u65f6\uff0c\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\u5b57\u6bb5\u503c\u4e0d\u5141\u8bb8\u76f8\u540c\u3002", (String)"InspectProOp_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), dimensName, entryOut.get("seq"), entryIn.get("seq")));
                    e.setCancel(true);
                }
            }
            QFilter qFilterCommon = new QFilter("status", "!=", (Object)"A");
            qFilterCommon.and("createorg", "=", bill.getDynamicObject("createorg").getPkValue());
            qFilterCommon.and("id", "!=", bill.getPkValue());
            InspectProMatchHelper.buildDimenSameQfilter((DynamicObjectCollection)dimens, (QFilter)qFilterCommon);
            for (int q = 0; q < entrys.size(); ++q) {
                DynamicObject curentry = (DynamicObject)entrys.get(q);
                QFilter qFilter = qFilterCommon.copy();
                for (DynamicObject dimen : dimens) {
                    DynamicObject dimenDetail = dimen.getDynamicObject("fbasedataid");
                    String proField = dimenDetail.getString("profield");
                    if (billProperties.containsKey((Object)proField)) {
                        IDataEntityProperty property = (IDataEntityProperty)billProperties.get((Object)proField);
                        Object value = this.getFilterValue(bill, proField, property);
                        qFilter.and(proField, "=", value);
                        continue;
                    }
                    DataEntityPropertyCollection entryProperties = curentry.getDataEntityType().getProperties();
                    IDataEntityProperty property = (IDataEntityProperty)entryProperties.get((Object)proField);
                    Object value = this.getFilterValue(curentry, proField, property);
                    qFilter.and("entryentity." + proField, "=", value);
                    if (!StringUtils.equals((CharSequence)"materielid", (CharSequence)proField)) continue;
                    if (curentry.get("setuptype") == null) {
                        qFilter.and("entryentity.setuptype", "=", (Object)"");
                    } else {
                        qFilter.and("entryentity.setuptype", "=", curentry.get("setuptype"));
                    }
                    qFilter.and("entryentity.materieltype", "=", this.getFilterValue(curentry, "materieltype", (IDataEntityProperty)entryProperties.get((Object)"materieltype")));
                }
                boolean exists = QueryServiceHelper.exists((String)"qcbd_inspectpro", (QFilter[])qFilter.toArray());
                if (!exists) continue;
                String errMessage = String.format(ResManager.loadKDString((String)"\u5339\u914d\u7ef4\u5ea6\u4e3a\u2018%1$s\u2019\u65f6\uff0c\u7b2c%2$s\u884c\u5206\u5f55\u6570\u636e\u5728\u68c0\u9a8c\u65b9\u6848\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u8bb0\u5f55\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"InspectProOp_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), dimensName, curentry.get("seq"));
                e.setCancelMessage(errMessage);
                e.setCancel(true);
            }
        }
    }

    private Object getFilterValue(DynamicObject curentry, String proField, IDataEntityProperty property) {
        Object value = curentry.get(proField);
        if (property instanceof BasedataProp) {
            value = Objects.nonNull(value) ? ((DynamicObject)value).getPkValue() : Long.valueOf(0L);
        }
        return value;
    }
}

