/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.urgentpass;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.opplugin.urgentpass.UrgentPassSaveValidator;
import kd.qmc.qcbd.opplugin.validator.BillSaveValidator;

public class UrgentPassSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("materialentry.seq");
        this.setSrcPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillSaveValidator());
        e.addValidator((AbstractValidator)new UrgentPassSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, DynamicObject> cacheUnitConvertMap = new HashMap<String, DynamicObject>(10);
        Boolean interFaceCheck = OppUtil.interFaceCheck((OperateOption)this.getOption());
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                if (!interFaceCheck.booleanValue()) continue;
                this.setBaseUnitConvDef(entry, cacheUnitConvertMap);
            }
        }
    }

    private void setBaseUnitConvDef(DynamicObject entry, Map<String, DynamicObject> cacheUnitConvertMap) {
        DynamicObject baseUnitObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"baseunit");
        DynamicObject matObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"materialid");
        BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"qty");
        BigDecimal baseQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"baseqty");
        if (baseUnitObj == null && matObj != null) {
            baseUnitObj = matObj.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)baseUnitObj);
        }
        if (qty.compareTo(BigDecimal.ZERO) >= 0 && baseQty.compareTo(BigDecimal.ZERO) == 0 && (baseQty = BaseUnitQtyConVertUtil.getBaseQty((DynamicObject)entry, (String)"materialid", (String)"unit", (String)"qty", cacheUnitConvertMap)) != null) {
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private void setSrcPreparePropertys(PreparePropertysEventArgs e) {
        String oprType = (String)this.operateMeta.get("type");
        Boolean isBillList = InspObjectHelper.isOperateOnList((OperateOption)this.getOption());
        if (!isBillList.booleanValue() && StringQMCUtil.inside((String)oprType, (String[])new String[]{"save", "submit"}).booleanValue()) {
            if (!e.getFieldKeys().contains("srcbillentryid")) {
                e.getFieldKeys().add("srcbillentryid");
            }
            if (!e.getFieldKeys().contains("srcbillentity")) {
                e.getFieldKeys().add("srcbillentity");
            }
            if (!e.getFieldKeys().contains("srcbillid")) {
                e.getFieldKeys().add("srcbillid");
            }
            if (!e.getFieldKeys().contains("srcbillentryseq")) {
                e.getFieldKeys().add("srcbillentryseq");
            }
            if (!e.getFieldKeys().contains("srcsystem")) {
                e.getFieldKeys().add("srcsystem");
            }
            if (!e.getFieldKeys().contains("srcunit")) {
                e.getFieldKeys().add("srcunit");
            }
            OppUtil.setFieldKeys((PreparePropertysEventArgs)e, (String[])new String[]{"baseunit", "baseqty", "unit"});
            if (!e.getFieldKeys().contains("srcbillnumber")) {
                e.getFieldKeys().add("srcbillnumber");
            }
            if (!e.getFieldKeys().contains("chkobjentryid")) {
                e.getFieldKeys().add("chkobjentryid");
            }
        }
    }
}

