/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.urgentpass;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.business.helper.inspectexecute.CkInspectInfoHelper;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;

public class UrgentPassSaveValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObjectCollection cfgJudgeResultCol = UrgentPassSaveValidator.getCfgJudgeResult(dataEntities);
        this.checkInfo(dataEntities, operate, cfgJudgeResultCol);
    }

    private static DynamicObjectCollection getCfgJudgeResult(ExtendedDataEntity[] dataEntities) {
        ArrayList<JSONObject> lstReqObj = new ArrayList<JSONObject>(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection matEntrys = billObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject dynamicObject : matEntrys) {
                JSONObject jso = new JSONObject();
                jso.put("materialCfg", (Object)dynamicObject.getLong("materialcfg.id"));
                jso.put("userOrg", (Object)billObj.getLong("org.id"));
                jso.put("bizType", (Object)billObj.getString("biztype.number"));
                lstReqObj.add(jso);
            }
        }
        CkInspectInfoHelper ckInspectInfoHelper = new CkInspectInfoHelper();
        return ckInspectInfoHelper.judgeInspectInfo(lstReqObj);
    }

    public void checkInfo(ExtendedDataEntity[] dataEntities, String operate, DynamicObjectCollection cfgJudgeResultCol) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDataEntity().getDynamicObjectCollection("materialentry");
            if (!Objects.nonNull(cfgJudgeResultCol)) continue;
            for (DynamicObject entry : entrys) {
                if (!DynamicObjPropUtil.isFirstDrawByDyo((DynamicObject)entry).booleanValue()) continue;
                for (DynamicObject cfgJudgeResult : cfgJudgeResultCol) {
                    DynamicObject materialCfg = entry.getDynamicObject("materialcfg");
                    long materialCfgId = Objects.nonNull(materialCfg) ? materialCfg.getLong("id") : 0L;
                    int seq = entry.getInt("seq");
                    if (cfgJudgeResult.getLong("inspectcfgid") != materialCfgId) continue;
                    if ("save".equals(operate)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\uff1a\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"UrgentPassSaveValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), seq));
                        continue;
                    }
                    if (!"submit".equals(operate)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u7269\u6599\u4fe1\u606f\u7b2c%s\u884c\uff1a\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"UrgentPassSaveValidator_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), seq));
                }
            }
        }
    }
}

