/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.qmc.qcbd.business.custom.ext.IWithoutJoinItemTipsClean;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.ErrorMsgUtil;
import kd.qmc.qcbd.common.util.OppUtil;
import kd.qmc.qcbd.common.util.OrgUnitUtil;
import kd.qmc.qcbd.common.util.PageCacheQmcUtil;
import kd.qmc.qcbd.common.util.UserUtil;

public class InSpecApplySaveValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "qmc-qcbd-opplugin";

    public void validate() {
        ExtendedDataEntity[] dataEntity = this.getDataEntities();
        HashMap<String, Set<Object>> cacheMap = new HashMap<String, Set<Object>>(1000);
        HashMap<Long, List<Long>> trustOrgMap = new HashMap<Long, List<Long>>(10);
        HashMap<Long, List<Long>> trustOrgDeptMap = new HashMap<Long, List<Long>>(10);
        HashMap<Long, List<Long>> orgUserCacheMap = new HashMap<Long, List<Long>>(10);
        HashMap<Long, List<Long>> applyOrgToDeptMap = new HashMap<Long, List<Long>>(10);
        OperateOption opt = this.getOption();
        Boolean interFaceCheck = OppUtil.interFaceCheck((OperateOption)opt);
        for (ExtendedDataEntity rowDataEntity : dataEntity) {
            DynamicObject billObj = rowDataEntity.getDataEntity();
            ArrayList<String> errMsgs = new ArrayList<String>(10);
            this.setValidOrgAndBillNoMsg(billObj, errMsgs);
            if (interFaceCheck.booleanValue()) {
                this.setValidInspecOrgMsg(billObj, errMsgs, trustOrgMap);
                this.validAvailableApplyDept(billObj, errMsgs, cacheMap, applyOrgToDeptMap);
                List<String> errEntryMsgs = this.validBillEntry(billObj, cacheMap, orgUserCacheMap, trustOrgDeptMap);
                if (!errEntryMsgs.isEmpty()) {
                    errMsgs.addAll(errEntryMsgs);
                }
            }
            for (String errMsg : errMsgs) {
                this.addErrorMessage(rowDataEntity, errMsg);
            }
            this.JoinInspectAlert(rowDataEntity, billObj);
        }
        PageCacheQmcUtil.clearObjCache(cacheMap);
    }

    private List<String> validBillEntry(DynamicObject dynamicObject, Map<String, Set<Object>> cacheMap, Map<Long, List<Long>> orgUserCacheMap, Map<Long, List<Long>> trustOrgDeptMap) {
        DynamicObjectCollection entryObjs = dynamicObject.getDynamicObjectCollection("materialentry");
        ArrayList<String> errMsgs = new ArrayList<String>(10);
        Set bdMultiMeasureUnitCacheSet = PageCacheQmcUtil.setIniObjCache(cacheMap, (String)"bd_multimeasureunit");
        Set bosOrgStructure = PageCacheQmcUtil.setIniObjCache(cacheMap, (String)"bos_org_structure");
        for (int i = 0; i < entryObjs.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryObjs.get(i);
            String errMsg = this.getValidUnitMsg(i, entryObj, bdMultiMeasureUnitCacheSet);
            if (errMsg.length() > 0) {
                errMsgs.add(errMsg);
            }
            this.setValidInspecOrgDeptMsg(dynamicObject, entryObj, errMsgs, trustOrgDeptMap);
            this.setValidAvailable(dynamicObject, entryObj, errMsgs, bosOrgStructure, orgUserCacheMap);
        }
        return errMsgs;
    }

    private String getValidUnitMsg(int i, DynamicObject entryObj, Set<Object> bdMultiMeasureUnitCacheSet) {
        DynamicObject materielObj = entryObj.getDynamicObject("materielid");
        DynamicObject unitObj = entryObj.getDynamicObject("unit");
        String errMsg = "";
        if (materielObj != null && unitObj != null) {
            DynamicObject baseunitObj = materielObj.getDynamicObject("baseunit");
            QFilter qFilter = new QFilter("materialid", "=", materielObj.getPkValue());
            Map materialUnitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
            Set mulitMaterialSet = materialUnitMap.keySet().stream().collect(Collectors.toSet());
            bdMultiMeasureUnitCacheSet.addAll(mulitMaterialSet);
            Set unitIds = materialUnitMap.values().stream().filter(p -> p.getDynamicObject("measureunitid") != null).map(p -> p.getDynamicObject("measureunitid") != null ? p.getDynamicObject("measureunitid").getLong("id") : 0L).collect(Collectors.toSet());
            unitIds.add(baseunitObj.getLong("id"));
            if (!unitIds.contains(unitObj.getLong("id"))) {
                errMsg = ErrorMsgUtil.getErrMsg((String)ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f", (String)"InSpecApplySaveValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Integer)(i + 1), (String)ResManager.loadKDString((String)"\u7269\u6599\u65e0\u6cd5\u9009\u62e9\u8be5\u5355\u4f4d\u3002", (String)"InSpecApplySaveValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        return errMsg;
    }

    private void setValidOrgAndBillNoMsg(DynamicObject dynamicObject, List<String> errMsgs) {
        String billNo = dynamicObject.getString("billno");
        DynamicObject org = dynamicObject.getDynamicObject("org");
        String errMsg = "";
        if (null == org) {
            errMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InSpecApplySaveValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            errMsgs.add(errMsg);
            return;
        }
        QFilter qfilters = new QFilter("org", "=", (Object)org.getLong("id"));
        qfilters.and("billno", "=", (Object)billNo);
        Long pkVal = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)dynamicObject);
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getEntityKey(), (String)"id", (QFilter[])qfilters.toArray());
        for (DynamicObject dynamic : query) {
            if (pkVal.equals(dynamic.getLong("id"))) continue;
            errMsg = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u548c\u7533\u8bf7\u7ec4\u7ec7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5176\u4e2d\u4e00\u9879\u3002", (String)"InSpecApplySaveValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            break;
        }
        if (errMsg.length() > 0) {
            errMsgs.add(errMsg);
        }
    }

    private void setValidInspecOrgMsg(DynamicObject dynamicObject, List<String> errMsgs, Map<Long, List<Long>> trustOrgMap) {
        String errMsg = "";
        DynamicObject org = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dynamicObject, (String)"org");
        DynamicObject inspecorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dynamicObject, (String)"inspecorg");
        if (inspecorg == null || org == null) {
            return;
        }
        Long orgID = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)org);
        ArrayList deftoOrgs = trustOrgMap.get(orgID);
        if (deftoOrgs == null) {
            deftoOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)orgID, (boolean)true);
            if (deftoOrgs == null) {
                deftoOrgs = new ArrayList(10);
            }
            trustOrgMap.put(orgID, deftoOrgs);
        }
        if (!deftoOrgs.isEmpty() && !deftoOrgs.contains(Long.parseLong(inspecorg.getPkValue().toString()))) {
            errMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7\u65e0\u6cd5\u6307\u5b9a\u6b64\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InSpecApplySaveValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if (errMsg.length() > 0) {
            errMsgs.add(errMsg);
        }
    }

    private void setValidInspecOrgDeptMsg(DynamicObject dynamicObject, DynamicObject entryObj, List<String> errMsgs, Map<Long, List<Long>> trustOrgDepMap) {
        String errMsg = "";
        DynamicObject inspedept = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"inspedeptid");
        DynamicObject inspecorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dynamicObject, (String)"inspecorg");
        if (inspecorg == null || inspedept == null) {
            return;
        }
        Long inspecorgId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)inspecorg);
        Long inspedeptId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)inspedept);
        ArrayList deptids = trustOrgDepMap.get(inspecorgId);
        if (deptids == null) {
            deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)inspecorgId, (boolean)false);
            if (deptids == null) {
                deptids = new ArrayList(10);
            }
            trustOrgDepMap.put(inspecorgId, deptids);
        }
        if (!deptids.isEmpty() && !deptids.contains(inspedeptId)) {
            errMsg = ResManager.loadKDString((String)"\u8d28\u68c0\u90e8\u95e8\u4e0d\u662f\u8d28\u68c0\u7ec4\u7ec7\u6240\u59d4\u6258\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"InSpecApplySaveValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        if (errMsg.length() > 0) {
            errMsgs.add(errMsg);
        }
    }

    private void setValidAvailable(DynamicObject dynamicObject, DynamicObject entryObj, List<String> errMsgs, Set<Object> bosOrgStructure, Map<Long, List<Long>> orgUserCacheMap) {
        Long inspectorId;
        Long inspecorgID;
        List qualityOrgUserByOrgid;
        DynamicObject inspecorg;
        Long inspedeptId;
        Object strcutID;
        String errMsg = "";
        DynamicObject inspectoridObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"inspectorid");
        DynamicObject inspedept = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryObj, (String)"inspedeptid");
        if (inspedept != null && (strcutID = OrgUnitUtil.unitOrgIsFreeze((Long)(inspedeptId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)inspedept)))) != null) {
            bosOrgStructure.add(strcutID);
            errMsg = ResManager.loadKDString((String)"\u8d28\u68c0\u90e8\u95e8\u4e0d\u53ef\u7528\u3002", (String)"InSpecApplySaveValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            errMsgs.add(errMsg);
        }
        if ((inspecorg = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dynamicObject, (String)"inspecorg")) != null && inspectoridObj != null && !(qualityOrgUserByOrgid = UserUtil.getQualityOrgUserByOrgid((Long)(inspecorgID = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)inspecorg)), orgUserCacheMap)).contains(inspectorId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)inspectoridObj))) {
            errMsg = ResManager.loadKDString((String)"\u8d28\u68c0\u5458\u4e0d\u5728\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5185\u3002", (String)"InSpecApplySaveValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            errMsgs.add(errMsg);
        }
    }

    private void validAvailableApplyDept(DynamicObject dynamicObject, List<String> errMsgs, Map<String, Set<Object>> cacheMap, Map<Long, List<Long>> applyOrgToDeptMap) {
        Object strcutID;
        DynamicObject org = dynamicObject.getDynamicObject("org");
        DynamicObject qualityorg = dynamicObject.getDynamicObject("qualityorg");
        String errMsg = "";
        Long qualityorgId = 0L;
        Set bosOrgStructure = PageCacheQmcUtil.setIniObjCache(cacheMap, (String)"bos_org_structure");
        if (qualityorg != null && (strcutID = OrgUnitUtil.unitOrgIsFreeze((Long)(qualityorgId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)qualityorg)))) != null) {
            bosOrgStructure.add(strcutID);
            errMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8\u4e0d\u53ef\u7528\u3002", (String)"InSpecApplySaveValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            errMsgs.add(errMsg);
        }
        if (org != null && qualityorg != null) {
            Long orgId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)org);
            ArrayList deptids = applyOrgToDeptMap.get(orgId);
            if (deptids == null) {
                deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)false);
                if (deptids == null) {
                    deptids = new ArrayList(10);
                }
                applyOrgToDeptMap.put(orgId, deptids);
            }
            if (!deptids.isEmpty() && !deptids.contains(qualityorgId)) {
                errMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8\u4e0d\u662f\u7533\u8bf7\u7ec4\u7ec7\u6240\u59d4\u6258\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"InSpecApplySaveValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                errMsgs.add(errMsg);
            }
        }
    }

    private void JoinInspectAlert(ExtendedDataEntity rowDataEntity, DynamicObject billObj) {
        List isNeedTipsList;
        DynamicObjectCollection isJoinProjCollection = new DynamicObjectCollection();
        DynamicObjectCollection matEntrys = billObj.getDynamicObjectCollection("materialentry");
        for (DynamicObject matEntry : matEntrys) {
            DynamicObjectCollection projEntrys = matEntry.getDynamicObjectCollection("subprojentry");
            isJoinProjCollection.addAll((Collection)projEntrys);
        }
        PluginProxy<IWithoutJoinItemTipsClean> pluginProxy = InSpecApplySaveValidator.getDimensPluginProxy(null);
        Boolean isNeedTips = Boolean.TRUE;
        if (!CollectionUtils.isEmpty((Collection)pluginProxy.getPlugins()) && !CollectionUtils.isEmpty((Collection)(isNeedTipsList = pluginProxy.callReplace(o -> o.getIsNeedTips())))) {
            isNeedTips = (Boolean)isNeedTipsList.get(0);
        }
        boolean hasJoinProj = isJoinProjCollection.stream().anyMatch(o -> o.getBoolean("isjoininspect"));
        if (billObj.getBoolean("joininspectflag") && !hasJoinProj && StringUtils.equals((CharSequence)"submit", (CharSequence)this.getOperateKey()) && isNeedTips.booleanValue()) {
            this.addWarningMessage(rowDataEntity, ResManager.loadKDString((String)"\u8054\u5408\u68c0\u9a8c\u5df2\u542f\u7528\uff0c\u4f46\u672a\u8bbe\u7f6e\u8054\u5408\u68c0\u9a8c\u9879\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InSpecApplySaveValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public static PluginProxy<IWithoutJoinItemTipsClean> getDimensPluginProxy(IWithoutJoinItemTipsClean customDeal) {
        PluginProxy pluginProxy = PluginProxy.create(IWithoutJoinItemTipsClean.class, (String)"QMC_QCBD_WITHOUTJOINITEM_TIPS");
        if (null != customDeal) {
            pluginProxy = PluginProxy.create((Object)customDeal, IWithoutJoinItemTipsClean.class, (String)"QMC_QCBD_WITHOUTJOINITEM_TIPS", null);
        }
        return pluginProxy;
    }
}

