/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.constant.InspResultConst;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class InSpecBillCommonValidator
extends AbstractValidator {
    public void validate() {
        Set<Long> pushedBillIds = this.getPushedBillId();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long id = dataEntity.getDataEntity().getLong("id");
            if (!pushedBillIds.contains(id)) continue;
            String pushMsg = ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5b58\u5728\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"InSpecBillCommonValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, pushMsg, ErrorLevel.FatalError);
        }
    }

    private Set<Long> getPushedBillId() {
        String inspResultExcute;
        List<Long> idList = Arrays.stream(this.dataEntities).map(x -> x.getDataEntity().getLong("id")).collect(Collectors.toList());
        String entity = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)entity, (Long[])idList.toArray(new Long[idList.size()]));
        HashSet<Long> ignoreTableIdSet = new HashSet<Long>(16);
        String targetEntityId = ParameterUtil.getQmcSystemProp((String)"ignoreTargetEntitys", (String)entity);
        if (StringUtils.isNotEmpty((String)targetEntityId)) {
            this.addIgnoreTableId(ignoreTableIdSet, targetEntityId);
        }
        if ("true".equals(inspResultExcute = this.getOption().getVariableValue("trigger_inspresult_excute", "false"))) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
            String appId = mainEntityType.getAppId();
            String inspResultEntity = (String)InspResultConst.getInspresultAppMap().get(appId);
            this.addIgnoreTableId(ignoreTableIdSet, inspResultEntity);
        }
        HashSet<Long> pushedBillSet = new HashSet<Long>(16);
        dirtTargetBills.forEach((key, value) -> {
            if (value.stream().anyMatch(x -> !ignoreTableIdSet.contains(x.getId().getMainTableId()))) {
                pushedBillSet.add((Long)key);
            }
        });
        return pushedBillSet;
    }

    private void addIgnoreTableId(Set<Long> ignoreTableIdSet, String entityKey) {
        TableDefine tableDefineTemp = EntityMetadataCache.loadMainTableDefine((String)entityKey);
        if (null != tableDefineTemp) {
            ignoreTableIdSet.add(tableDefineTemp.getTableId());
        }
    }
}

