/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InSpecUniqueValidatorCommon
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operate = this.getOperateKey();
        if (!"save".equals(operate) && !"submit".equals(operate)) {
            return;
        }
        Map<String, List<DynamicObject>> getStoreBillNoMap = this.getStoreBillNoMap(dataEntities);
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            Optional<DynamicObject> billNoObjOp;
            DynamicObject billObj = rowDataEntity.getDataEntity();
            DynamicObject org = billObj.getDynamicObject("org");
            if (null == org) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u68c0\u7ec4\u7ec7\u3002", (String)"InSpecUniqueValidatorCommon_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            long id = (Long)billObj.get("id");
            String billNo = billObj.getString("billno");
            List<DynamicObject> itemBillnoObjs = getStoreBillNoMap.get(billNo);
            if (itemBillnoObjs == null || !(billNoObjOp = itemBillnoObjs.stream().filter(x -> org.getLong("id") == x.getLong("org")).findAny()).isPresent() || id == billNoObjOp.get().getLong("id")) continue;
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u548c\u8d28\u68c0\u7ec4\u7ec7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5176\u4e2d\u4e00\u9879\u3002", (String)"InSpecUniqueValidatorCommon_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private Map<String, List<DynamicObject>> getStoreBillNoMap(ExtendedDataEntity[] dataEntities) {
        String formid = dataEntities[0].getDataEntity().getDataEntityType().getName();
        Set billNos = ((Stream)Arrays.stream(dataEntities).sequential()).map(x -> x.getDataEntity().getString("billno")).collect(Collectors.toSet());
        QFilter billFilters = new QFilter("billno", "in", billNos);
        DynamicObjectCollection billColls = QueryServiceHelper.query((String)formid, (String)"id,org,billno", (QFilter[])billFilters.toArray());
        Map<String, List<DynamicObject>> billNoMap = billColls.stream().collect(Collectors.groupingBy(p -> p.getString("billno")));
        return billNoMap;
    }
}

