/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.qmc.qcbd.common.util.ErrorMsgUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class IncInspectionBillValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "qmc-qcbd-opplugin";
    private static final String[] COMPARISON = new String[]{"[ ]", "( )", "[ )", "( ]", "<", "<=", ">", ">=", "=", "\u2260"};
    private static final String INSPSUBENTITY = "inspsubentity";
    private static final String DECISUBENTITY = "decisubentity";
    private static final String MATERIALQTY = "materialqty";
    private static final String RINSQTY = "rinsqty";
    private static final String MATINTOENTITY = "matintoentity";

    public String getEntityKey() {
        return this.entityKey;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntity = this.getDataEntities();
        String operate = this.getOperateKey();
        if (!StringQMCUtil.inside((String)operate, (String[])new String[]{"submit"}).booleanValue()) {
            return;
        }
        for (ExtendedDataEntity rowDataEntity : dataEntity) {
            HashMap<Integer, List<Integer>> batchErrorMl = new HashMap<Integer, List<Integer>>(16);
            HashMap<Integer, List<Integer>> batchErrorSl = new HashMap<Integer, List<Integer>>(16);
            HashMap<Integer, List<Integer>> batchErrorRl = new HashMap<Integer, List<Integer>>(16);
            HashMap<Integer, List<Integer>> joinInspErrs = new HashMap<Integer, List<Integer>>(16);
            HashMap<Integer, List<Integer>> batchErrorQualiQty = new HashMap<Integer, List<Integer>>(16);
            HashMap<Integer, List<Integer>> batchErrorUnQualiQty = new HashMap<Integer, List<Integer>>(16);
            DynamicObjectCollection matEntry = (DynamicObjectCollection)rowDataEntity.getValue(MATINTOENTITY);
            Integer m = 0;
            String matEntryName = ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f", (String)"IncInspectionBillValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String inbSubEntryName = ResManager.loadKDString((String)"\u68c0\u9a8c\u4fe1\u606f", (String)"IncInspectionBillValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            for (DynamicObject matRow : matEntry) {
                BigDecimal rinsqty = matRow.getBigDecimal(RINSQTY);
                BigDecimal materialqty = matRow.getBigDecimal(MATERIALQTY);
                BigDecimal qualiqty = matRow.getBigDecimal("qualiqty");
                BigDecimal baseQualiqty = matRow.getBigDecimal("basequaliqty");
                BigDecimal unqualiqty = matRow.getBigDecimal("unqualiqty");
                BigDecimal baseUnqualiqty = matRow.getBigDecimal("baseunqlyqty");
                BigDecimal sampqualqty = matRow.getBigDecimal("sampqualqty");
                BigDecimal samunqualqty = matRow.getBigDecimal("samunqualqty");
                String samplingresult = matRow.getString("samplingresult");
                if (samplingresult == null || "".equals(samplingresult)) {
                    batchErrorRl.put(m + 1, null);
                }
                if (materialqty.compareTo(qualiqty.add(unqualiqty)) != 0) {
                    batchErrorMl.put(m + 1, null);
                }
                if (rinsqty.compareTo(sampqualqty.add(samunqualqty)) != 0) {
                    batchErrorSl.put(m + 1, null);
                }
                if (qualiqty.compareTo(BigDecimal.ZERO) > 0 && baseQualiqty.compareTo(BigDecimal.ZERO) <= 0) {
                    batchErrorQualiQty.put(m + 1, null);
                }
                if (unqualiqty.compareTo(BigDecimal.ZERO) > 0 && baseUnqualiqty.compareTo(BigDecimal.ZERO) <= 0) {
                    batchErrorUnQualiQty.put(m + 1, null);
                }
                DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection(INSPSUBENTITY);
                int size = inspSubEntry.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject inspRow = (DynamicObject)inspSubEntry.get(i);
                    String joinInspectStatus = inspRow.getString("joininspectstatus");
                    if (!inspRow.getBoolean("isjoininspect") || !StringUtils.isNotBlank((CharSequence)joinInspectStatus) || "Y".equalsIgnoreCase(joinInspectStatus)) continue;
                    if (!joinInspErrs.containsKey(m + 1)) {
                        joinInspErrs.put(m + 1, new LinkedList());
                    }
                    List integers = (List)joinInspErrs.get(m + 1);
                    integers.add(i + 1);
                }
                Integer n = m;
                Integer n2 = m = Integer.valueOf(m + 1);
            }
            this.errorMessageDeal(rowDataEntity, batchErrorRl, matEntryName, "", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u91cf\u5224\u5b9a\u3002", (String)"IncInspectionBillValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), false);
            this.errorMessageDeal(rowDataEntity, batchErrorMl, matEntryName, "", ResManager.loadKDString((String)"\u5408\u683c\u6570+\u4e0d\u5408\u683c\u6570\u4e0d\u7b49\u4e8e\u68c0\u9a8c\u6570\u91cf\u3002", (String)"IncInspectionBillValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), false);
            this.errorMessageDeal(rowDataEntity, batchErrorSl, matEntryName, "", ResManager.loadKDString((String)"\u6837\u672c\u5408\u683c\u6570+\u6837\u672c\u4e0d\u5408\u683c\u6570\u4e0d\u7b49\u4e8e\u6837\u672c\u6570\u91cf\uff0c\u662f\u5426\u63d0\u4ea4\uff1f", (String)"IncInspectionBillValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), true);
            this.errorMessageDeal(rowDataEntity, joinInspErrs, matEntryName, inbSubEntryName, ResManager.loadKDString((String)"\u8054\u5408\u68c0\u9a8c\u72b6\u6001\u4e3a\u672a\u5b8c\u6210\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"IncInspectionBillValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), true);
            this.errorMessageDeal(rowDataEntity, batchErrorQualiQty, matEntryName, inbSubEntryName, ResManager.loadKDString((String)"\u5408\u683c\u6570\u4e0d\u4e3a0\u65f6\uff0c\u57fa\u672c\u5408\u683c\u6570\u4e0d\u80fd\u4e3a0\u3002", (String)"IncInspectionBillValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), true);
            this.errorMessageDeal(rowDataEntity, batchErrorUnQualiQty, matEntryName, inbSubEntryName, ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u6570\u4e0d\u4e3a0\u65f6\uff0c\u57fa\u672c\u4e0d\u5408\u683c\u6570\u4e0d\u80fd\u4e3a0\u3002", (String)"IncInspectionBillValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), true);
        }
    }

    private void errorMessageDeal(ExtendedDataEntity rowDataEntity, Map<Integer, List<Integer>> batchErrorMl, String entityName, String subentityName, String errorStr, boolean isWarning) {
        if (!batchErrorMl.isEmpty()) {
            for (Map.Entry<Integer, List<Integer>> entry : batchErrorMl.entrySet()) {
                List<Integer> entryValue = entry.getValue();
                if (null != entryValue) {
                    for (Integer subIndex : entryValue) {
                        this.addErrMessgae(rowDataEntity, entityName, subentityName, errorStr, isWarning, entry, subIndex);
                    }
                    continue;
                }
                this.addErrMessgae(rowDataEntity, entityName, subentityName, errorStr, isWarning, entry, 1);
            }
        }
    }

    private void addErrMessgae(ExtendedDataEntity rowDataEntity, String entityName, String subentityName, String errorStr, boolean isWarning, Map.Entry<Integer, List<Integer>> entry, Integer subIndex) {
        if (isWarning) {
            this.addWarningMessage(rowDataEntity, ErrorMsgUtil.getErrMsg((String)entityName, (Integer)entry.getKey(), (String)subentityName, (Integer)subIndex, (String)errorStr));
        } else {
            this.addErrorMessage(rowDataEntity, ErrorMsgUtil.getErrMsg((String)entityName, (Integer)entry.getKey(), (String)subentityName, (Integer)subIndex, (String)errorStr));
        }
    }
}

