/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class InspectionItemsValidator
extends AbstractValidator {
    public void validate() {
        String operateKey;
        switch (operateKey = this.getOperateKey()) {
            case "itemsplit": {
                this.itemSplitValidate();
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                this.checkout();
                break;
            }
        }
    }

    private void itemSplitValidate() {
        for (ExtendedDataEntity dataEntities : this.getDataEntities()) {
            BigDecimal itementry = dataEntities.getDataEntity().getBigDecimal("itementryqty");
            Boolean split = (Boolean)dataEntities.getValue("split");
            String status = dataEntities.getValue("status").toString();
            if (split.booleanValue()) {
                this.addErrorMessage(dataEntities, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u62c6\u5206\uff0c\u65e0\u6cd5\u518d\u6b21\u62c6\u5206\u3002", (String)"InspectionItemsValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equals(status)) {
                this.addErrorMessage(dataEntities, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"InspectionItemsValidator_1", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (itementry.compareTo(BigDecimal.ONE) > 0) continue;
            this.addErrorMessage(dataEntities, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u5206\u5f55\u6570\u5c0f\u4e8e\u7b49\u4e8e1\uff0c\u4e0d\u6ee1\u8db3\u62c6\u5206\u6761\u4ef6\u3002", (String)"InspectionItemsValidator_2", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkout() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            int size = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").size();
            if (size <= 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u591a\u884c\u5206\u5f55\u3002", (String)"InspectionItemsValidator_3", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
        }
    }
}

