/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.JoinInspectHelper;
import kd.qmc.qcbd.common.model.joininspect.JoinInspectEntityModel;

public class JoinInspectUnauditValidator
extends AbstractValidator {
    public void validate() {
        this.validInspectBillStatus();
    }

    private void validInspectBillStatus() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String entityKey = this.getEntityKey();
        JoinInspectEntityModel entityModel = JoinInspectHelper.getEntityModel((String)entityKey, (String)this.getOperateKey());
        List<DynamicObject> joinInspects = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Set itemEntryIds = JoinInspectHelper.getJoinInspItemEntryIds((DynamicObject[])joinInspects.toArray(new DynamicObject[0]));
        String selectField = String.join((CharSequence)",", "id", "billno", String.format("%s.%s.%s %s", "matintoentity", "inspsubentity", "joininspentryid", "joininspentryid"));
        QFilter filter = new QFilter("billstatus", "!=", (Object)"A").and(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "joininspentryid"), "in", (Object)itemEntryIds);
        DynamicObjectCollection inspInfos = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)entityModel.getInspectBill(), (String)selectField, (QFilter[])filter.toArray(), (String)"id");
        if (inspInfos.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> itemGroup = inspInfos.stream().collect(Collectors.groupingBy(x -> x.getLong("joininspentryid")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject joinInspObj = dataEntity.getDataEntity();
            DynamicObjectCollection matEntry = joinInspObj.getDynamicObjectCollection("matintoentity");
            int matsize = matEntry.size();
            for (int i = 0; i < matsize; ++i) {
                DynamicObject matRow = (DynamicObject)matEntry.get(i);
                DynamicObjectCollection joinInspSub = matRow.getDynamicObjectCollection("inspsubentity");
                int joinInspSubSize = joinInspSub.size();
                for (int j = 0; j < joinInspSubSize; ++j) {
                    DynamicObject joinInspSubObj = (DynamicObject)joinInspSub.get(j);
                    Object itemKey = joinInspSubObj.getPkValue();
                    if (!itemGroup.containsKey(itemKey)) continue;
                    Set billNoSet = itemGroup.get(itemKey).stream().map(x -> x.getString("billno")).collect(Collectors.toSet());
                    String billIdsStr = String.join((CharSequence)",", billNoSet);
                    String errMdg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u7b2c%1$S\u884c\uff0c\u68c0\u9a8c\u4fe1\u606f\u7b2c%2$s\u884c\uff1a\u5173\u8054\u7684\u68c0\u9a8c\u5355(%3$s)\u4e3a\u63d0\u4ea4\u6216\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"JoinInspectUnauditValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), i + 1, j + 1, billIdsStr);
                    this.addErrorMessage(dataEntity, errMdg);
                }
            }
        }
    }
}

