/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QmcRouteValidator
extends AbstractValidator {
    private String[] arr = new String[]{"", "0", " "};
    private String[] status = new String[]{"A", "B", "C"};
    Set<String> aMainSet;
    Set<String> bMainSet;
    Set<String> cMainSet;
    Set<String> aReplaceSet;
    Set<String> bReplaceSet;
    Set<String> cReplaceSet;
    private static final String SYSTEM_TYPE = "qmc-qcbd-opplugin";

    public void validate() {
        String operate;
        this.aMainSet = new HashSet<String>(this.dataEntities.length);
        this.bMainSet = new HashSet<String>(this.dataEntities.length);
        this.cMainSet = new HashSet<String>(this.dataEntities.length);
        this.aReplaceSet = new HashSet<String>(this.dataEntities.length);
        this.bReplaceSet = new HashSet<String>(this.dataEntities.length);
        this.cReplaceSet = new HashSet<String>(this.dataEntities.length);
        switch (operate = this.getOperateKey()) {
            case "delete": {
                break;
            }
            case "unaudit": {
                break;
            }
            case "save": {
                break;
            }
            case "submitandnew": {
                this.checkData();
                break;
            }
            case "submit": {
                this.checkData();
            }
        }
    }

    private boolean checkHeadData(ExtendedDataEntity entity, Map<String, String> param) {
        boolean isError = false;
        DynamicObject obj = entity.getDataEntity();
        String origin = obj.getString("origin");
        if (StringUtils.isBlank((CharSequence)origin)) {
            return false;
        }
        if (this.isNull(obj.getDynamicObject("createorg"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
            return isError;
        }
        if (this.isNull(obj.getString("number"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        if (this.isNull(obj.getString("name"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        if ("A".equals(obj.getString("processtype"))) {
            if (this.isNull(obj.getDynamicObject("material"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                isError = true;
                return isError;
            }
        } else if ("B".equals(obj.getString("processtype"))) {
            if (this.isNull(obj.getDynamicObject("unit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                isError = true;
            }
            if (this.isNull(obj.getDynamicObject("materialgroup"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u63a7\u5236\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                isError = true;
                return isError;
            }
        } else if ("C".equals(obj.getString("processtype")) && this.isNull(obj.getDynamicObject("unit"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        QFilter filter = new QFilter("id", "!=", obj.getPkValue()).and("origin", "=", (Object)origin);
        if (!this.isNull(obj.getDynamicObject("routeversion"))) {
            filter.and("routeversion.id", "=", obj.getDynamicObject("routeversion").getPkValue());
        }
        filter.and(new QFilter("createorg", "=", obj.getDynamicObject("createorg").getPkValue()));
        filter.and(new QFilter("status", "in", (Object)this.status));
        StringBuilder str = new StringBuilder();
        if (obj.getBoolean("ismainprocess")) {
            param.put("ismain", "1");
            filter.and(new QFilter("ismainprocess", "=", (Object)"1"));
            if ("A".equals(obj.getString("processtype"))) {
                param.put("type", "A");
                filter.and(new QFilter("material", "in", obj.getDynamicObject("material").getPkValue()));
                if (!this.isNull(obj.get("auxproperty"))) {
                    filter.and(new QFilter("auxproperty", "in", obj.getDynamicObject("auxproperty").getPkValue()));
                }
                if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter})) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u7248\u672c\u53f7\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                    isError = true;
                } else {
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(obj.getDynamicObject("material").getPkValue().toString());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                    if (this.aMainSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u7248\u672c\u53f7\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    }
                }
            } else if ("B".equals(obj.getString("processtype"))) {
                param.put("type", "B");
                filter.and(new QFilter("materialgroup", "=", obj.getDynamicObject("materialgroup").getPkValue()));
                if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter})) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                    isError = true;
                } else {
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                    if (this.bMainSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    }
                }
            } else {
                param.put("type", "C");
                if (this.isNull(obj.getDynamicObject("group"))) {
                    filter.and(new QFilter("processtype", "=", (Object)"C"));
                    if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter})) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                        isError = true;
                    } else {
                        str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                        str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                        str.append("0");
                        if (this.cMainSet.contains(str.toString())) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            isError = true;
                        }
                    }
                } else {
                    filter.and(new QFilter("group", "in", obj.getDynamicObject("group").getPkValue()));
                    filter.and(new QFilter("processtype", "=", (Object)"C"));
                    if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter})) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                        isError = true;
                    } else {
                        str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                        str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                        str.append(obj.getDynamicObject("group").getPkValue().toString());
                        if (this.cMainSet.contains(str.toString())) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            isError = true;
                        }
                    }
                }
            }
        } else {
            param.put("ismain", "0");
            if (this.isNull(obj.getDynamicObject("routereplace"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u975e\u4e3b\u5de5\u827a\u8def\u7ebf,\u66ff\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                isError = true;
                return isError;
            }
            QFilter notMainFilter = new QFilter("ismainprocess", "in", (Object)this.arr);
            QFilter isMainQFilter = new QFilter("ismainprocess", "=", (Object)"1");
            QFilter replaceQFilter = new QFilter("routereplace", "=", obj.getDynamicObject("routereplace").getPkValue());
            if ("A".equals(obj.getString("processtype"))) {
                param.put("type", "A");
                filter.and(new QFilter("material", "in", obj.getDynamicObject("material").getPkValue()));
                if (!this.isNull(obj.get("auxproperty"))) {
                    filter.and(new QFilter("auxproperty", "in", obj.getDynamicObject("auxproperty").getPkValue()));
                }
                str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                str.append(obj.getDynamicObject("material").getPkValue().toString());
                str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                str.setLength(0);
                str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                str.append(obj.getDynamicObject("material").getPkValue().toString());
                str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                if (this.aReplaceSet.contains(str.toString())) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u66ff\u4ee3\u53f7\u3001\u7248\u672c\u53f7\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    isError = true;
                } else if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter, replaceQFilter, notMainFilter})) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u66ff\u4ee3\u53f7\u3001\u7248\u672c\u53f7\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    isError = true;
                }
            } else if ("B".equals(obj.getString("processtype"))) {
                param.put("type", "B");
                filter.and(new QFilter("materialgroup", "=", obj.getDynamicObject("materialgroup").getPkValue()));
                str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                str.setLength(0);
                str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                if (this.bReplaceSet.contains(str.toString())) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    isError = true;
                } else if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter, replaceQFilter, notMainFilter})) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u63a7\u5236\u7ec4\u3001\u7248\u672c\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    isError = true;
                }
            } else {
                param.put("type", "C");
                if (this.isNull(obj.getDynamicObject("group"))) {
                    filter.and(new QFilter("processtype", "=", (Object)"C"));
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append("0");
                    str.setLength(0);
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                    str.append("0");
                    if (this.cReplaceSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u672c\u6b21\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    } else if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter, replaceQFilter, notMainFilter})) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    }
                } else {
                    filter.and(new QFilter("group", "in", obj.getDynamicObject("group").getPkValue()));
                    filter.and(new QFilter("processtype", "=", (Object)"C"));
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(obj.getDynamicObject("group").getPkValue().toString());
                    str.setLength(0);
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                    str.append(obj.getDynamicObject("group").getPkValue().toString());
                    if (this.cReplaceSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u672c\u6b21\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    } else if (QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter, replaceQFilter, notMainFilter})) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524d\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"QmcRouteValidator_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        isError = true;
                    }
                }
            }
        }
        return isError;
    }

    private boolean checkEntryData(ExtendedDataEntity entity, Map<String, Set<String>> operaNoMap) {
        boolean isError = false;
        DynamicObjectCollection entryCol = entity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (entryCol.isEmpty()) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            boolean ouputNotNullFlag;
            String processSeq;
            DynamicObject entryObj = (DynamicObject)entryCol.get(j);
            if (this.isNull(entryObj.getString("processseq"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_21", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                isError = true;
            }
            if (this.isNull(entryObj.getString("processseqname"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u5e8f\u5217\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_22", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                isError = true;
            }
            if (!"1".equals(processSeq = entryObj.getString("processseq"))) {
                if (this.isNull(entryObj.getString("reference"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u53c2\u7167\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                } else if (entryObj.getString("reference").equals(entryObj.getString("processseq"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u53c2\u7167\u4e0d\u80fd\u4e3a\u81ea\u8eab\u5e8f\u5217\u3002", (String)"QmcRouteValidator_24", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
                if (this.isNull(entryObj.getString("relation"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u5e76\u884c\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_25", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
                if (this.isNull(entryObj.getString("output")) || this.isNull(entryObj.getString("input"))) {
                    if (this.isNull(entryObj.getString("input"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u8f6c\u5165\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_26", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                        isError = true;
                    }
                    if (this.isNull(entryObj.getString("output"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u8f6c\u51fa\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_27", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                        isError = true;
                    }
                } else if (Integer.parseInt(entryObj.getString("input")) < Integer.parseInt(entryObj.getString("output"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s],\u8f6c\u5165\u5de5\u5e8f\u4e0d\u80fd\u5c0f\u4e8e\u8f6c\u51fa\u5de5\u5e8f\u3002", (String)"QmcRouteValidator_28", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
            }
            DynamicObjectCollection subEntryCol = entity.getDataEntity().getDynamicObjectCollection("processentry");
            boolean isExist = false;
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (!processSeq.equals(subEntryObj.getString("parent"))) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217[%s]\uff0c\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u3002", (String)"QmcRouteValidator_29", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq")));
                isError = true;
            }
            String ouput = entryObj.getString("output");
            String input = entryObj.getString("input");
            String reference = entryObj.getString("reference");
            Set<String> operatNoSet = operaNoMap.get(reference);
            boolean inputNotNullFlag = !Objects.isNull(operatNoSet) && !operatNoSet.contains(input);
            boolean bl = ouputNotNullFlag = !Objects.isNull(operatNoSet) && !operatNoSet.contains(ouput);
            if (inputNotNullFlag) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u7684\u53c2\u7167\u5e8f\u5217[%2$s]\u4e2d\u5de5\u5e8f[%3$s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u5165\u5de5\u5e8f\u3002", (String)"QmcRouteValidator_63", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq"), reference, input));
                isError = true;
            }
            if (!ouputNotNullFlag) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u7684\u53c2\u7167\u5e8f\u5217[%2$s]\u4e2d\u5de5\u5e8f[%3$s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u51fa\u5de5\u5e8f\u3002", (String)"QmcRouteValidator_64", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("processseq"), reference, ouput));
            isError = true;
        }
        return isError;
    }

    private boolean checkSubEntryData(ExtendedDataEntity entity) {
        boolean isError = false;
        DynamicObjectCollection entryCol = entity.getDataEntity().getDynamicObjectCollection("processentry");
        String processEntry = entryCol.getDynamicObjectType().getProperties().toString();
        if (processEntry.contains("storagepoint")) {
            ArrayList<Object> alist = new ArrayList<Object>();
            for (DynamicObject sup : entryCol) {
                if (!"true".equals(sup.getString("storagepoint"))) continue;
                alist.add(sup.get("storagepoint"));
            }
            if (alist.size() > 1) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5165\u5e93\u70b9\u552f\u4e00\u3002", (String)"QmcRouteValidator_30", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
                isError = true;
            }
        }
        if (entryCol.isEmpty()) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_31", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        String pattern = "^[1-9][0-9]{0,4}$";
        Pattern p = Pattern.compile(pattern);
        for (int j = 0; j < entryCol.size(); ++j) {
            BigDecimal qty;
            DynamicObject entryObj = (DynamicObject)entryCol.get(j);
            if (!p.matcher(entryObj.getString("operationno")).find()) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51655\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"QmcRouteValidator_32", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            boolean flag = false;
            if (this.isNull(entryObj.get("parent"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f[%s]\u5de5\u5e8f\u5e8f\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_33", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("operationno")));
                isError = true;
            } else {
                for (int j2 = 0; j2 < entity.getDataEntity().getDynamicObjectCollection("entryentity").size(); ++j2) {
                    if (!entryObj.get("parent").equals(((DynamicObject)entity.getDataEntity().getDynamicObjectCollection("entryentity").get(j2)).getString("processseq"))) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%s]\u4e0d\u5b58\u5728\u3002", (String)"QmcRouteValidator_34", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent")));
                isError = true;
            }
            if ("1002".equals(entryObj.getString("machiningtype"))) {
                if (this.isNull(entryObj.get("settlementunit"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u4e3a\u59d4\u5916\u52a0\u5de5\uff0c\u7ed3\u7b97\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_35", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if (this.isNull(entryObj.get("settlementcoefficient"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u4e3a\u59d4\u5916\u52a0\u5de5\uff0c\u7ed3\u7b97\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_36", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                } else if (entryObj.getBigDecimal("settlementcoefficient").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_37", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            if (this.isNull(entryObj.getDynamicObject("workcenter"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u4f5c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_38", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("productionorg"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_39", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getString("operationdesc"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b[%2$s]\u5de5\u5e8f\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_40", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("oprctrlstrategy"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_41", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("upperratio")) || entryObj.getBigDecimal("upperratio").compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_42", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("floorratio")) || entryObj.getBigDecimal("floorratio").compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_43", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("basebatchqty")) || entryObj.getBigDecimal("basebatchqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u57fa\u672c\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_44", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u8868\u5934\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_45", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u8868\u5934\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_46", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_47", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("operationunit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_48", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (entryObj.getBoolean("issplit")) {
                qty = entryObj.getBigDecimal("splitqty");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u52fe\u9009\u4e86\u662f\u5426\u62c6\u5206\u6392\u7a0b\uff0c\u5efa\u8bae\u62c6\u5206\u6570\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QmcRouteValidator_49", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("minworktime")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u52fe\u9009\u4e86\u662f\u5426\u62c6\u5206\u6392\u7a0b\uff0c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QmcRouteValidator_50", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            } else {
                qty = entryObj.getBigDecimal("splitqty");
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5efa\u8bae\u62c6\u5206\u6570\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_51", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("minworktime")).compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_52", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            if (entryObj.getBoolean("isprocessoverlap")) {
                qty = entryObj.getBigDecimal("minoverlaptime");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u52fe\u9009\u4e86\u662f\u5426\u5de5\u5e8f\u91cd\u53e0\uff0c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QmcRouteValidator_53", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("overlapqty")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u52fe\u9009\u4e86\u662f\u5426\u5de5\u5e8f\u91cd\u53e0\uff0c\u91cd\u53e0\u6279\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"QmcRouteValidator_54", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if (this.isNull(entryObj.getDynamicObject("overlapunit"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5df2\u52fe\u9009\u4e86\u662f\u5426\u5de5\u5e8f\u91cd\u53e0\uff0c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_55", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            } else {
                qty = entryObj.getBigDecimal("minoverlaptime");
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_56", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("overlapqty")).compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_37", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (!this.isNull(subEntryObj.getDynamicObject("resource"))) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6392\u7a0b\u5b50\u5206\u5f55\uff0c\u8d44\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_57", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            subEntryCol = entryObj.getDynamicObjectCollection("actentryentity");
            Map<Object, Boolean> queryWorkCenter = this.queryWorkCenter(entryObj);
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (this.isNull(subEntryObj.getString("processstage"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\uff0c\u5de5\u5e8f\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_58", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("standardformula"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\uff0c\u6807\u51c6\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_59", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("standardformula1"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\uff0c\u6807\u51c6\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_59", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (subEntryObj.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"QmcRouteValidator_60", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("activity"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcRouteValidator_61", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                    continue;
                }
                if (!queryWorkCenter.containsKey(subEntryObj.getDynamicObject("activity").getPkValue()) || !queryWorkCenter.get(subEntryObj.getDynamicObject("activity").getPkValue()).booleanValue() || BigDecimal.ZERO.compareTo(subEntryObj.getBigDecimal("baseqty")) < 0) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217[%1$s]\u4e0b\u5de5\u5e8f[%2$s]\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c[%3$s]\u884c\u57fa\u672c\u6570\u91cf\u9700\u8981\u5927\u4e8e0\u3002", (String)"QmcRouteValidator_62", (String)SYSTEM_TYPE, (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
            }
        }
        return isError;
    }

    private Map<Object, Boolean> queryWorkCenter(DynamicObject entryObj) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>(16);
        DynamicObject dynamicObject = entryObj.getDynamicObject("workcenter");
        if (dynamicObject != null) {
            DynamicObjectCollection col = QueryServiceHelper.query((String)"mpdm_workcentre", (String)"id,processactivetable.processnumber processnumber,processactivetable.processroutecontrol processroutecontrol", (QFilter[])new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())});
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject entry = (DynamicObject)col.get(i);
                if (entry.get("processnumber") == null || entry.getLong("processnumber") == 0L) continue;
                map.put(entry.getLong("processnumber"), "1".equals(entry.getString("processroutecontrol")));
            }
        }
        return map;
    }

    private void checkData() {
        ArrayList allDataList = new ArrayList(this.dataEntities.length);
        ArrayList<ExtendedDataEntity> isMainDataList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        ArrayList<ExtendedDataEntity> notMainDataList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            if (this.dataEntities[i].getDataEntity().getBoolean("ismainprocess")) {
                isMainDataList.add(this.dataEntities[i]);
                continue;
            }
            notMainDataList.add(this.dataEntities[i]);
        }
        allDataList.addAll(isMainDataList);
        allDataList.addAll(notMainDataList);
        StringBuilder str = new StringBuilder();
        HashMap<String, String> param = new HashMap<String, String>(3);
        for (int i = 0; i < allDataList.size(); ++i) {
            boolean checkDataHead = this.checkHeadData((ExtendedDataEntity)allDataList.get(i), param);
            if (checkDataHead) continue;
            Map<String, Set<String>> operatNoMap = this.getOperaNoMap((ExtendedDataEntity)allDataList.get(i));
            boolean checkEntryData = this.checkEntryData((ExtendedDataEntity)allDataList.get(i), operatNoMap);
            boolean checkSubEntryData = this.checkSubEntryData((ExtendedDataEntity)allDataList.get(i));
            str.setLength(0);
            if (checkDataHead || checkEntryData || checkSubEntryData) continue;
            DynamicObject obj = ((ExtendedDataEntity)allDataList.get(i)).getDataEntity();
            str.append(obj.getDynamicObject("createorg").getPkValue().toString());
            str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
            if ("1".equals(param.get("ismain"))) {
                if ("A".equals(param.get("type"))) {
                    str.append(obj.getDynamicObject("material").getPkValue().toString());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                    this.aMainSet.add(str.toString());
                    continue;
                }
                if ("B".equals(param.get("type"))) {
                    str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                    this.bMainSet.add(str.toString());
                    continue;
                }
                str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
                this.cMainSet.add(str.toString());
                continue;
            }
            str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
            if ("A".equals(param.get("type"))) {
                str.append(obj.getDynamicObject("material").getPkValue().toString());
                str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                this.aReplaceSet.add(str.toString());
                continue;
            }
            if ("B".equals(param.get("type"))) {
                str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                this.bReplaceSet.add(str.toString());
                continue;
            }
            str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
            this.cReplaceSet.add(str.toString());
        }
    }

    private Map<String, Set<String>> getOperaNoMap(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dynamicObjectEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection processEntrys = dynamicObjectEntity.getDynamicObjectCollection("processentry");
        HashMap<String, Set<String>> operaNoMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject entry : processEntrys) {
            Set<String> operatNoSet;
            String parentKey = entry.getString("parent");
            String operatNo = entry.getString("operationno");
            if (operaNoMap.containsKey(parentKey)) {
                operatNoSet = (Set)operaNoMap.get(parentKey);
                operatNoSet.add(operatNo);
                operaNoMap.put(parentKey, operatNoSet);
                continue;
            }
            operatNoSet = new HashSet();
            operatNoSet.add(operatNo);
            operaNoMap.put(parentKey, operatNoSet);
        }
        return operaNoMap;
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }
}

