/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjUtil;

public class SuspiciousSubmitValidator
extends AbstractValidator {
    private static final String QCBD_SUSPICIOUS = "qcbd_suspicious";
    private static final String STATUS = "status";
    public static final String CREATEORG = "createorg";
    public static final String ENTRYENTITY = "entryentity";
    public static final String BATCHNO = "batchno";
    public static final String MATERIAL = "material";
    public static final String SUPPLIER = "supplier";
    public static final String MANUFACTURER = "manufacturer";
    public static final String SERIALNO = "serialno";
    private static final String[] CHECK_ARR = new String[]{"material.number", "supplier", "manufacturer", "batchno", "serialno"};
    private static final String[] CHECK_ARR_FIELD = new String[]{"createorg.id", "entryentity.material.number", "entryentity.supplier.id", "entryentity.manufacturer", "entryentity.batchno", "entryentity.serialno"};

    public void validate() {
        Set<String> suspiciousSet = this.getSuspiciousSet();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String status = dynamicObject.getString(STATUS);
            if ("B".equals(status) || "C".equals(status)) {
                return;
            }
            List<String> errMsglist = this.checkUnique(suspiciousSet, dynamicObject);
            for (String errMsg : errMsglist) {
                this.addErrorMessage(dataEntity, errMsg);
            }
        }
    }

    private List<String> checkUnique(Set<String> checkSet, DynamicObject dynamicObject) {
        ArrayList<String> errorList = new ArrayList<String>(10);
        ArrayList checkList = new ArrayList(10);
        Collections.addAll(checkList, CHECK_ARR);
        DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        for (int i = 0; i < objectCollection.size(); ++i) {
            DynamicObject currObj = (DynamicObject)objectCollection.get(i);
            String currStr = DynamicObjUtil.getOnlyObjStr((DynamicObject)currObj, checkList);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(dynamicObject.getLong("createorg.id"));
            stringBuilder.append(currStr);
            currStr = stringBuilder.toString();
            if (checkSet.contains(currStr)) {
                String errMessage = String.format(ResManager.loadKDString((String)"\u53ef\u7591\u4ef6\u4fe1\u606f\u7b2c%s\u884c\uff1a\u8be5\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"SuspiciousSubmitValidator_0", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]), i + 1);
                errorList.add(errMessage);
                continue;
            }
            checkSet.add(currStr);
        }
        return errorList;
    }

    private Set<String> getSuspiciousSet() {
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<String> materialSet = new HashSet<String>(16);
        HashSet<String> suspiciousSet = new HashSet<String>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            Long createOrg = dy.getLong("createorg.id");
            orgSet.add(createOrg);
            DynamicObjectCollection collection = dy.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject dynamicObject : collection) {
                String materialNum = dynamicObject.getString("material.number");
                materialSet.add(materialNum);
            }
        }
        ArrayList checkList = new ArrayList(10);
        Collections.addAll(checkList, CHECK_ARR_FIELD);
        QFilter[] qFilter = new QFilter[]{new QFilter("createorg.id", "in", orgSet), new QFilter("entryentity.material.number", "in", materialSet), new QFilter(STATUS, "!=", (Object)"A")};
        String selectFields = "id,status,createorg.id,entryentity.material.number,entryentity.supplier.id,entryentity.manufacturer,entryentity.batchno,entryentity.serialno";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SuspiciousSubmitValidator", (String)QCBD_SUSPICIOUS, (String)selectFields, (QFilter[])qFilter, null);){
            for (Row ds : dataSet) {
                String onlyObjMapKey = DynamicObjUtil.getOnlyRowStr((Row)ds, checkList);
                suspiciousSet.add(onlyObjMapKey);
            }
        }
        return suspiciousSet;
    }
}

