/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspres.InspectResultProcessLogHelper;
import kd.qmc.qcbd.business.inspresult.InspResultExcute;
import kd.qmc.qcbd.common.platform.unionpush.UnionPushServiceHelper;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TriggerInspResultValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        Map<String, ExtendedDataEntity> entityMap = this.getExtendedDataEntityMap();
        if (StringQMCUtil.inside((String)operate, (String[])new String[]{"submit", "unsubmit", "audit", "unaudit", "save", "delete"}).booleanValue()) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            String entityKey = this.getEntityKey();
            Set billIdSet = Arrays.stream(dataEntities).map(x -> x.getBillPkId()).collect(Collectors.toSet());
            QFilter[] filterArr = new QFilter("entity", "=", (Object)entityKey).and("billid", "in", billIdSet).and("feedback_status", "!=", (Object)"U").toArray();
            String selectFileds = String.join((CharSequence)",", "billid", "feedback_status");
            DynamicObjectCollection billIds = QueryServiceHelper.query((String)"qcbd_inspres_poclog", (String)selectFileds, (QFilter[])filterArr);
            if (!billIds.isEmpty()) {
                List<String> processStatus = Arrays.asList("W", "P");
                Map<Long, List<DynamicObject>> billIdFeedbackStatus = billIds.stream().collect(Collectors.groupingBy(x -> x.getLong("billid")));
                LinkedList<Long> unEffectiveBillIds = new LinkedList<Long>();
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    Object billPkId = extendedDataEntity.getBillPkId();
                    List<DynamicObject> billFeedBackStatus = billIdFeedbackStatus.get(billPkId);
                    if (!CollectionUtils.isNotEmpty(billFeedBackStatus)) continue;
                    boolean processIng = billFeedBackStatus.stream().anyMatch(x -> processStatus.contains(x.getString("feedback_status")));
                    if (processIng) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u68c0\u9a8c\u7ed3\u679c\u5904\u7406\u4e2d\uff0c\u8bf7\u7ee7\u7eed\u7b49\u5f85\u6216\u624b\u52a8\u5904\u7406\u3002", (String)"TriggerInspResultValidator_3", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean processErr = billFeedBackStatus.stream().anyMatch(x -> "F".equals(x.getString("feedback_status")));
                    if (!processErr) continue;
                    unEffectiveBillIds.add((Long)billPkId);
                }
                InspectResultProcessLogHelper.setFeedBackStatus(unEffectiveBillIds, (String)"U", (String)"");
            }
        }
        if (StringQMCUtil.inside((String)operate, (String[])new String[]{"audit", "unaudit"}).booleanValue()) {
            this.validResult(entityMap, operate);
        }
    }

    private void validResult(Map<String, ExtendedDataEntity> entityMap, String operate) {
        if (entityMap.size() <= 0) {
            return;
        }
        Set<String> pkVals = entityMap.entrySet().stream().map(p -> (String)p.getKey()).collect(Collectors.toSet());
        this.setResMsg(entityMap, pkVals);
        if (StringQMCUtil.inside((String)operate, (String[])new String[]{"unaudit"}).booleanValue()) {
            this.setInvInspectbillMsg(entityMap, pkVals);
        }
    }

    private void setInvInspectbillMsg(Map<String, ExtendedDataEntity> entityMap, Set<String> pkVals) {
        QFilter qfilters = new QFilter("ass_billid", "in", pkVals);
        qfilters.and("ass_entitynumber", "=", (Object)this.entityKey);
        qfilters.and("splitbatchentity.m_srcentitynumber", "=", (Object)"im_invinspectbill");
        InspResultExcute inspExcute = new InspResultExcute(this.validateContext.getBillEntityType());
        String resEntityNumber = inspExcute.getResEntityNumber();
        DynamicObjectCollection colls = QueryServiceHelper.query((String)resEntityNumber, (String)"id,ass_billid", (QFilter[])qfilters.toArray());
        if (colls.isEmpty()) {
            return;
        }
        List relBillIdList = colls.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> objIdMap = colls.stream().collect(Collectors.groupingBy(p -> p.getLong("id")));
        Map returnMap = UnionPushServiceHelper.findUnionPushRecordByRelationObj((String)resEntityNumber, relBillIdList);
        for (Map.Entry entry : returnMap.entrySet()) {
            List<DynamicObject> billObjs;
            Long entryKey = (Long)entry.getKey();
            Map entryVal = (Map)entry.getValue();
            if (entryVal == null) continue;
            List billnos = (List)entryVal.get("billno");
            String entitytype = (String)entryVal.get("entitytype");
            if (billnos == null || (billObjs = objIdMap.get(entryKey)) == null) continue;
            for (DynamicObject billObj : billObjs) {
                String billID = billObj.getString("ass_billid");
                ExtendedDataEntity extendData = entityMap.get(billID);
                if (extendData == null) continue;
                String msg = ResManager.loadKDString((String)"\u5df2\u751f\u6210%1$s\u201c%2$s\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"TriggerInspResultValidator_2", (String)"qmc-qcbd-opplugin", (Object[])new Object[0]);
                String billnoStr = StringQMCUtil.getFieldStr(billnos.stream().collect(Collectors.toSet()));
                String entityName = "";
                if (StringUtils.isNotBlank((CharSequence)entitytype)) {
                    MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitytype);
                    entityName = mainEntityType.getDisplayName().getLocaleValue();
                }
                this.addErrorMessage(extendData, String.format(msg, entityName, billnoStr));
            }
        }
    }

    private void setResMsg(Map<String, ExtendedDataEntity> extendDataMap, Set<String> pkVals) {
    }

    private Map<String, ExtendedDataEntity> getExtendedDataEntityMap() {
        HashMap<String, ExtendedDataEntity> extendDataMap = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity rowDataEntity : this.dataEntities) {
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            Object pkVal = dataEntity.getPkValue();
            extendDataMap.put(String.valueOf(pkVal), rowDataEntity);
        }
        return extendDataMap;
    }
}

