/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.opplugin.widestrict;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class WideStrictRuleValidator
extends AbstractValidator {
    private static final String SYSTEM_TYPE = "qmc-qcbd-opplugin";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String errMsg;
            DynamicObjectCollection entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (entryEntity.size() != 4) {
                errMsg = ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6570\u76ee\u4e0d\u6b63\u786e\u3002", (String)"WideStrictRuleValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
                continue;
            }
            if (!entryEntity.stream().anyMatch(x -> x.getBoolean("starttage"))) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u68c0\u9a8c\u9636\u6bb5\u3002", (String)"WideStrictRuleValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
                continue;
            }
            HashMap<String, Boolean> checkReuslt = new HashMap<String, Boolean>(16);
            checkReuslt.put("findError", false);
            HashSet<Integer> checkedSet = new HashSet<Integer>(16);
            HashSet<Integer> stageSet = new HashSet<Integer>(16);
            Optional<DynamicObject> currentEntryOp = entryEntity.stream().filter(x -> x.getBoolean("starttage")).findFirst();
            DynamicObject currentEntry = currentEntryOp.get();
            int currentStage = Integer.parseInt(currentEntry.getDynamicObject("currentstage").getString("number"));
            stageSet.add(currentStage);
            stageSet.addAll(this.stageCheck(dataEntity, entryEntity, currentStage, checkReuslt));
            checkedSet.add(currentStage);
            while (stageSet.size() > checkedSet.size()) {
                List unCheckList = stageSet.stream().filter(x -> !checkedSet.contains(x)).collect(Collectors.toList());
                for (Integer stage : unCheckList) {
                    stageSet.addAll(this.stageCheck(dataEntity, entryEntity, stage, checkReuslt));
                    checkedSet.add(stage);
                }
            }
            if (((Boolean)checkReuslt.get("findError")).booleanValue()) continue;
            checkReuslt.put("findError", false);
            for (int i = 0; i < 4; ++i) {
                DynamicObject entry;
                if (checkedSet.contains(i + 1) || null == (entry = (DynamicObject)entryEntity.get(i)).get("sapplan") && null == entry.get("nextstage") && !StringUtils.isNotBlank((Object)entry.get("startcondition")) && null == entry.get("rnextstage") && !StringUtils.isNotBlank((Object)entry.get("rstartcondition"))) continue;
                String errMsg2 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u914d\u7f6e\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u65e0\u6cd5\u8fdb\u5165\u8be5\u9636\u6bb5\uff0c\u89c4\u5219\u65e0\u6548\u3002\u8bf7\u6e05\u9664\u8be5\u884c\u8f6c\u6362\u89c4\u5219\u6216\u91cd\u65b0\u5b9a\u4e49\u6d41\u8f6c\u89c4\u5219\u3002", (String)"WideStrictRuleValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), i + 1);
                this.addMessage(dataEntity, errMsg2, ErrorLevel.Error);
                checkReuslt.put("findError", true);
            }
            if (((Boolean)checkReuslt.get("findError")).booleanValue()) continue;
            checkReuslt.put("findError", false);
            for (Integer stage : checkedSet) {
                int i = stage - 1;
                Boolean rowCheck = this.rowCheck(dataEntity, entryEntity, i);
                Boolean rowAcceptCheck = this.rowAcceptCheck(dataEntity, entryEntity, i);
                Boolean rowRejectCheck = this.rowRejectCheck(dataEntity, entryEntity, i);
                if (rowCheck.booleanValue() && rowAcceptCheck.booleanValue() && rowRejectCheck.booleanValue()) continue;
                checkReuslt.put("findError", true);
            }
            if (!((Boolean)checkReuslt.get("findError")).booleanValue()) continue;
        }
    }

    private List<Integer> stageCheck(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntity, int currentStage, Map<String, Boolean> checkResult) {
        LinkedList<Integer> stageList = new LinkedList<Integer>();
        int rowIndex = currentStage - 1;
        Object nextStage = ((DynamicObject)entryEntity.get(rowIndex)).get("nextstage");
        Object rnextStage = ((DynamicObject)entryEntity.get(rowIndex)).get("rnextstage");
        if (null == nextStage && null == rnextStage) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5b9a\u4e49\u6d41\u8f6c\u89c4\u5219\uff0c\u7b2c%1$s\u884c\u914d\u7f6e\u7684\u8f6c\u6362\u89c4\u5219\u5c06\u4e00\u76f4\u505c\u7559\u5728\u8be5\u9636\u6bb5\uff0c\u8fdb\u5165\u6b7b\u5faa\u73af\u3002", (String)"WideStrictRuleValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            checkResult.put("findError", true);
        }
        if (null != nextStage) {
            stageList.add(Integer.valueOf(((DynamicObject)nextStage).getString("number")));
        }
        if (null != rnextStage) {
            stageList.add(Integer.valueOf(((DynamicObject)rnextStage).getString("number")));
        }
        return stageList;
    }

    private Boolean rowRejectCheck(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntity, int rowIndex) {
        Boolean legal = true;
        DynamicObject entryStartStage = (DynamicObject)entryEntity.get(rowIndex);
        if (null == entryStartStage.get("rnextstage") && StringUtils.isNotBlank((CharSequence)entryStartStage.getString("rstartcondition")) || null != entryStartStage.get("rnextstage") && StringUtils.isBlank((CharSequence)entryStartStage.getString("rstartcondition"))) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u4e0d\u63a5\u53d7\u7684\u8f6c\u6362\u89c4\u5219\u5fc5\u987b\u540c\u65f6\u8d4b\u503c\u6216\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WideStrictRuleValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            legal = false;
        }
        return legal;
    }

    private Boolean rowAcceptCheck(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntity, int rowIndex) {
        Boolean legal = true;
        DynamicObject entryStartStage = (DynamicObject)entryEntity.get(rowIndex);
        if (null == entryStartStage.get("nextstage") && StringUtils.isNotBlank((CharSequence)entryStartStage.getString("startcondition")) || null != entryStartStage.get("nextstage") && StringUtils.isBlank((CharSequence)entryStartStage.getString("startcondition"))) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u63a5\u53d7\u7684\u8f6c\u6362\u89c4\u5219\u5fc5\u987b\u540c\u65f6\u8d4b\u503c\u6216\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WideStrictRuleValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            legal = false;
        }
        return legal;
    }

    private Boolean rowCheck(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntity, int rowIndex) {
        DynamicObject entryStartStage;
        Boolean legal = true;
        if (3 != rowIndex && null == (entryStartStage = (DynamicObject)entryEntity.get(rowIndex)).get("sapplan")) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u62bd\u6837\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WideStrictRuleValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            legal = false;
        }
        return legal;
    }
}

