/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.qmc.qcbd.business.inspres.InspResApiHelper;
import kd.qmc.qcbd.business.inspres.InspResHelperBase;
import kd.qmc.qcbd.business.inspres.InspResQualPanelHelper;
import kd.qmc.qcbd.mservice.api.IInspectResultService;

public class InspectResultServiceImpl
implements IInspectResultService {
    private static final Log logger = LogFactory.getLog(InspectResultServiceImpl.class);

    public Map<String, Object> getInspectKanBanResult(Map<String, Object> postParam) {
        logger.info("getInspectKanBanResult requestData\uff1a" + postParam);
        String errMsg = this.validKanBanReq(postParam);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return this.getErrorRet(errMsg);
        }
        InspResQualPanelHelper helper = new InspResQualPanelHelper(postParam);
        logger.info("getInspectKanBanResult afterBuild helper\uff1a" + helper);
        helper.initRetParam(postParam);
        logger.info("getInspectKanBanResult initRetParam \uff1a" + helper.getRetParam());
        helper.appendSendQty();
        logger.info("getInspectKanBanResult appendSendQty \uff1a" + helper.getRetParam());
        DynamicObjectCollection inspectRes = helper.getInspectRes();
        logger.info("getInspectKanBanResult inspectRes \uff1a" + inspectRes);
        Map inspCountMap = helper.getInspectCount(inspectRes);
        logger.info("getInspectKanBanResult inspCountMap \uff1a" + inspCountMap);
        helper.addInspresInfo(inspectRes, inspCountMap);
        logger.info("getInspectKanBanResult addInspresInfo \uff1a" + helper.getRetParam());
        return helper.getRetParam();
    }

    public Map<String, Set<Object>> getTbillInfos(Map<String, Object> postParam) {
        String entityType;
        logger.info("getTbillInfos requestData\uff1a" + postParam);
        InspResQualPanelHelper helper = new InspResQualPanelHelper(postParam);
        logger.info("getTbillInfos afterBuild helper\uff1a" + helper);
        helper.initRetParam(postParam);
        logger.info("getTbillInfos initRetParam \uff1a" + helper.getRetParam());
        HashMap<String, Set<Object>> retMap = new HashMap(16);
        switch (entityType = (String)postParam.get("entityType")) {
            case "apply_type": {
                retMap = this.billInfoFormat((InspResHelperBase)helper);
                break;
            }
            case "inspect_type": 
            case "baddeal_type": {
                retMap = helper.getBillInfos(entityType);
                break;
            }
        }
        logger.info("getTbillInfos retMap \uff1a" + retMap);
        return retMap;
    }

    public Map<String, Object> getInspectResult(Map<String, Object> postParam) {
        logger.info("getInspectResult requestData\uff1a" + postParam);
        String errMsg = this.validInspResReq(postParam);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return this.getErrorRet(errMsg);
        }
        InspResApiHelper helper = new InspResApiHelper(postParam);
        logger.info("getInspectResult afterBuild helper\uff1a" + helper);
        helper.initRetParam(postParam);
        logger.info("getInspectResult initRetParam\uff1a" + helper.getRetParam());
        DynamicObjectCollection inspectRes = helper.getInspectRes();
        logger.info("getInspectResult inspectRes\uff1a" + inspectRes);
        Map inspCountMap = helper.getInspectCount(inspectRes);
        logger.info("getInspectResult inspCountMap\uff1a" + inspCountMap);
        helper.addInspresInfo(inspectRes, inspCountMap);
        logger.info("getInspectResult retParam\uff1a" + helper.getRetParam());
        return helper.getRetParam();
    }

    private String validKanBanReq(Map<String, Object> postParam) {
        Object callEntryId;
        String callBillType;
        Object callBillId;
        Object callEntityNumber;
        StringBuilder errMsfSb = new StringBuilder();
        Object inspectAppnumbers = postParam.get("inspect_appnumbers");
        String errFormatStr = ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u6b63\u786e;", (String)"InspectResultServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]);
        if (!(inspectAppnumbers instanceof String)) {
            errMsfSb.append(String.format(errFormatStr, "inspect_appnumbers"));
        }
        if (!((callEntityNumber = postParam.get("call_entitynumber")) instanceof String)) {
            errMsfSb.append(String.format(errFormatStr, "call_entitynumber"));
        }
        if (!((callBillId = postParam.get("call_billid")) instanceof Long)) {
            errMsfSb.append(String.format(errFormatStr, "call_billid"));
        }
        if ("E".equals(callBillType = String.valueOf(postParam.get("call_type"))) && !((callEntryId = postParam.get("call_entryid")) instanceof Long)) {
            errMsfSb.append(String.format(errFormatStr, "call_entryid"));
        }
        return errMsfSb.toString();
    }

    private String validInspResReq(Map<String, Object> postParam) {
        Object sendDataObj;
        Object sendEntitynumber;
        StringBuilder errMsfSb = new StringBuilder();
        Object inspectAppnumbers = postParam.get("inspect_appnumbers");
        String errFormatStr = ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u6b63\u786e;", (String)"InspectResultServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]);
        if (!(inspectAppnumbers instanceof List)) {
            errMsfSb.append(String.format(errFormatStr, "inspect_appnumbers"));
        }
        if (!((sendEntitynumber = postParam.get("call_entitynumber")) instanceof String)) {
            errMsfSb.append(String.format(errFormatStr, "call_entitynumber"));
        }
        if (!((sendDataObj = postParam.get("send_data")) instanceof List)) {
            errMsfSb.append(String.format(errFormatStr, "send_data"));
        }
        List sendData = (List)sendDataObj;
        List sendBillIds = sendData.stream().filter(x -> x.get("call_billid") instanceof Long).map(x -> (Long)x.get("call_billid")).collect(Collectors.toList());
        if (sendData.size() != sendBillIds.size()) {
            errMsfSb.append(String.format(errFormatStr, "call_billid"));
        }
        List sendEntryIds = sendData.stream().filter(x -> x.get("call_entryid") instanceof Long).map(x -> (Long)x.get("call_entryid")).collect(Collectors.toList());
        if (sendData.size() != sendEntryIds.size()) {
            errMsfSb.append(String.format(errFormatStr, "call_entryid"));
        }
        return errMsfSb.toString();
    }

    private Map<String, Set<Object>> billInfoFormat(InspResHelperBase helper) {
        HashMap inspObjSrcInfos = new HashMap(16);
        Set sendEntitys = helper.getSendEntitys();
        for (String sendEntity : sendEntitys) {
            inspObjSrcInfos.putAll(helper.getInspObjInfos(sendEntity));
        }
        HashMap<String, Set<Object>> retmap = new HashMap<String, Set<Object>>(16);
        Collection inspObjCollection = inspObjSrcInfos.values();
        for (List inspObjList : inspObjCollection) {
            for (DynamicObject inspObj : inspObjList) {
                String entity = inspObj.getString("sentitynumber");
                Long sBillId = Long.parseLong(inspObj.getString("sbillid"));
                if (!retmap.containsKey(entity)) {
                    retmap.put(entity, new HashSet(16));
                }
                ((Set)retmap.get(entity)).add(sBillId);
            }
        }
        return retmap;
    }

    private Map<String, Object> getErrorRet(String errMsg) {
        HashMap<String, Object> retParam = new HashMap<String, Object>(16);
        retParam.put("successful", false);
        retParam.put("message", errMsg);
        retParam.put("errorcode", "9999");
        return retParam;
    }
}

