/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectApiServiceHelper;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.mservice.api.IInspectService;
import kd.qmc.qcbd.mservice.dto.JudgeMeasureReq;
import kd.qmc.qcbd.mservice.dto.JudgeMeasureRes;
import kd.qmc.qcbd.mservice.measure.InspectJudgeMeasureServiceImpl;
import org.apache.commons.collections.MapUtils;

public class InspectServiceImpl
implements IInspectService {
    public String getJudgeResByMeasureVal(String requestJsonStr) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        try {
            JSONObject requestObj = JSON.parseObject((String)requestJsonStr);
            JSONArray inspSubEntry = requestObj.getJSONArray("inspsubentity");
            HashMap<String, JSONObject> inspSubEntryMap = new HashMap<String, JSONObject>(16);
            for (Object inspSubObj : inspSubEntry) {
                JSONObject inspSubJsonObj = (JSONObject)inspSubObj;
                inspSubEntryMap.put(inspSubJsonObj.getString("uquuid"), inspSubJsonObj);
            }
            JSONArray subMeasureEntry = requestObj.getJSONArray("submeasuredvalentity");
            Map<String, Map<Long, String>> judgeMeasureResMap = this.judgeMeasureValRes(inspSubEntryMap, subMeasureEntry);
            for (Object subMeasureRowObj : subMeasureEntry) {
                JSONObject subMeasureRow = (JSONObject)subMeasureRowObj;
                String projUuid = subMeasureRow.getString("projuuid");
                Map<Long, String> measureResMap = judgeMeasureResMap.get(projUuid);
                if (!MapUtils.isNotEmpty(measureResMap)) continue;
                String measureRes = measureResMap.get(subMeasureRow.getLong("exmapleid"));
                subMeasureRow.put("measuredval_judge", (Object)measureRes);
            }
            result.setData((Object)InspectApiServiceHelper.getJudgeRes((JSONObject)requestObj, (Boolean)Boolean.TRUE));
        }
        catch (Exception e) {
            result.setRetCode("-1");
            result.setRetMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return JSON.toJSONString((Object)result);
    }

    public String getJudgeResByMeasureRes(String requestJsonStr) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        try {
            JSONObject requestObj = JSON.parseObject((String)requestJsonStr);
            result.setData((Object)InspectApiServiceHelper.getJudgeRes((JSONObject)requestObj, (Boolean)Boolean.FALSE));
        }
        catch (Exception e) {
            result.setRetCode("-1");
            result.setRetMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return JSON.toJSONString((Object)result);
    }

    private Map<String, Map<Long, String>> judgeMeasureValRes(Map<String, JSONObject> inspSubEntryMap, JSONArray subMeasureEntry) {
        List<JudgeMeasureReq> judgeMeasureReqList = this.buildJudgeMeasureReq(inspSubEntryMap, subMeasureEntry);
        List<JudgeMeasureRes> judgeMeasureResList = InspectJudgeMeasureServiceImpl.judgeMeasureValRes(judgeMeasureReqList);
        HashMap<String, Map<Long, String>> judgeMeasureResMap = new HashMap<String, Map<Long, String>>(16);
        for (JudgeMeasureRes measureRes : judgeMeasureResList) {
            String projUuid = String.valueOf(measureRes.getProjUuid());
            if (!judgeMeasureResMap.containsKey(projUuid)) {
                judgeMeasureResMap.put(projUuid, new HashMap(16));
            }
            ((Map)judgeMeasureResMap.get(projUuid)).put(measureRes.getSampleId(), measureRes.getMeasureResult());
        }
        return judgeMeasureResMap;
    }

    private List<JudgeMeasureReq> buildJudgeMeasureReq(Map<String, JSONObject> inspSubEntryMap, JSONArray subMeasureEntry) {
        LinkedList<JudgeMeasureReq> judgeMeasureReqList = new LinkedList<JudgeMeasureReq>();
        for (Object subMeasureRowObj : subMeasureEntry) {
            JSONObject subMeasureRow = (JSONObject)subMeasureRowObj;
            String projUuid = subMeasureRow.getString("projuuid");
            JSONObject inspItemInfo = inspSubEntryMap.get(projUuid);
            if (null == inspItemInfo) continue;
            JudgeMeasureReq measureReq = new JudgeMeasureReq();
            judgeMeasureReqList.add(measureReq);
            measureReq.setProjUuid(subMeasureRow.getString("projuuid"));
            measureReq.setSampleId(subMeasureRow.getLongValue("exmapleid"));
            measureReq.setMeasuredValDeter(subMeasureRow.getString("measuredval_deter"));
            String measureValRat = subMeasureRow.getString("measuredval_rat");
            if (StringUtils.isNotEmpty((String)measureValRat) && StringUtils.isNumeric((String)measureValRat.replaceFirst("-", ""))) {
                measureReq.setMeasuredValRat(new BigDecimal(measureValRat));
            }
            measureReq.setNormtype(inspItemInfo.getString("normtype"));
            measureReq.setMatchflag(inspItemInfo.getLong("matchflag"));
            measureReq.setSpecvalue(inspItemInfo.getString("specvalue"));
            measureReq.setTopvalue(inspItemInfo.getBigDecimal("topvalue"));
            measureReq.setDownvalue(inspItemInfo.getBigDecimal("downvalue"));
        }
        return judgeMeasureReqList;
    }
}

