/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.business.helper.RouteSyncHelper;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.CopyUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.qmc.qcbd.mservice.api.IManufactureRouteSyncService;

public class ManufactureRouteSyncServiceImpl
implements IManufactureRouteSyncService {
    private static final Log logger = LogFactory.getLog(ManufactureRouteSyncServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject alterProcessEntry(String routParamStr) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        JSONObject resObj = null;
        logger.info("alterProcessEntry begin:" + routParamStr);
        try (TXHandle h = TX.required((String)"alterProcessEntry");){
            try {
                JSONObject routParam = JSON.parseObject((String)routParamStr);
                JSONArray routParamArray = routParam.getJSONArray("routerIds");
                ArrayList<Long> routIds = new ArrayList<Long>(16);
                for (int i = 0; i < routParamArray.size(); ++i) {
                    routIds.add((Long)routParamArray.get(i));
                }
                List routeIdGrp = AverageAssignUtil.getAssignListByMaxSize(routIds, (int)10000);
                for (List sRouteIDs : routeIdGrp) {
                    this.initQmcRoute(sRouteIDs);
                    this.alterProcessEntryRows(sRouteIDs);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                result = MserviceResult.newFailInstance();
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                result.setRetMsg(errMsg);
                logger.error("alterProcessEntry  error:" + errMsg);
            }
            finally {
                resObj = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result), JSONObject.class);
            }
        }
        logger.info("alterProcessEntry end:" + JSON.toJSONString((Object)resObj));
        return resObj;
    }

    private void initQmcRoute(List<Long> sRouteIDs) {
        QFilter qfilters = new QFilter("id", "in", sRouteIDs);
        DynamicObjectCollection qmcRoutes = QueryServiceHelper.query((String)"qcbd_qmcroute", (String)"id", (QFilter[])qfilters.toArray());
        ArrayList<Long> pdmRouteIDs = new ArrayList<Long>(16);
        for (Long sRouteID : sRouteIDs) {
            Optional<DynamicObject> routeOp = qmcRoutes.stream().filter(p -> p.getLong("id") == sRouteID.longValue()).findFirst();
            if (routeOp.isPresent()) continue;
            pdmRouteIDs.add(sRouteID);
        }
        if (pdmRouteIDs.size() <= 0) {
            return;
        }
        qfilters = new QFilter("id", "in", pdmRouteIDs);
        qfilters.and("status", "=", (Object)"C");
        QFilter ctQfilters = new QFilter("processentry.checktype", "=", (Object)"1013");
        ctQfilters.or("processentry.firstcheck", "=", (Object)true);
        qfilters.and(ctQfilters);
        DynamicObjectCollection pdmRoutes = QueryServiceHelper.query((String)"pdm_route", (String)"id", (QFilter[])qfilters.toArray());
        List businesskeys = pdmRoutes.stream().map(p -> p.getString("id")).collect(Collectors.toList());
        new RouteSyncHelper().dealRoute(businesskeys, "audit");
    }

    private void alterProcessEntryRows(List<Long> sRouteIDs) {
        DynamicObject[] qmcRoutes = BusinessDataServiceHelper.load((Object[])sRouteIDs.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"qcbd_qmcroute"));
        DynamicObject[] pdmRoutes = BusinessDataServiceHelper.load((Object[])sRouteIDs.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_route"));
        Map<Long, List<DynamicObject>> pdmRouteMap = Arrays.stream(pdmRoutes).collect(Collectors.groupingBy(x -> x.getLong("id")));
        for (DynamicObject qmcRoute : qmcRoutes) {
            Long id = qmcRoute.getLong("id");
            String origin = qmcRoute.getString("origin");
            List<DynamicObject> pdmRouteLst = pdmRouteMap.get(id);
            if (pdmRouteLst == null || pdmRouteLst.size() < 1 || !StringQMCUtil.inside((String)origin, (String[])new String[]{"A"}).booleanValue()) continue;
            DynamicObject pdmRoute = pdmRouteLst.get(0);
            DynamicObjectCollection formEntity = pdmRoute.getDynamicObjectCollection("processentry");
            DynamicObjectCollection toEntity = qmcRoute.getDynamicObjectCollection("processentry");
            if (toEntity == null) continue;
            for (DynamicObject fromEntry : formEntity) {
                Long idFrom = fromEntry.getLong("id");
                Optional<DynamicObject> toRowOp = toEntity.stream().filter(p -> p.getLong("route_procentryid") == idFrom.longValue()).findFirst();
                if (!toRowOp.isPresent()) {
                    String parent = fromEntry.getString("parent");
                    String operationno = fromEntry.getString("operationno");
                    List toRowLst = toEntity.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getString("parent"), (CharSequence)parent) && StringUtils.equalsIgnoreCase((CharSequence)p.getString("operationno"), (CharSequence)operationno) && p.getLong("route_procentryid") == 0L).collect(Collectors.toList());
                    if (toRowLst.size() == 1) {
                        ((DynamicObject)toRowLst.get(0)).set("route_procentryid", (Object)idFrom);
                        toRowOp = toEntity.stream().filter(p -> p.getLong("route_procentryid") == idFrom.longValue()).findFirst();
                    }
                }
                DynamicObject toNewEntry = null;
                HashSet<String> ignoreKeys = new HashSet<String>();
                if (toRowOp.isPresent()) {
                    toNewEntry = toRowOp.get();
                    ignoreKeys.add("id");
                } else {
                    toNewEntry = toEntity.addNew();
                    toNewEntry.set("route_procentryid", fromEntry.get("id"));
                }
                CopyUtil.copy((DynamicObject)fromEntry, (DynamicObject)toNewEntry, ignoreKeys);
            }
        }
        SaveServiceHelper.save((DynamicObject[])qmcRoutes);
    }
}

