/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.CkInspectInfoHelper;
import kd.qmc.qcbd.business.matInspect.IMaterialInspectSubPlugin;
import kd.qmc.qcbd.common.util.MaterialInspectUtil;
import kd.qmc.qcbd.mservice.api.IMaterialInspectService;

public class MaterialInspectServiceImpl
implements IMaterialInspectService {
    public JSONObject isNeedInspect(JSONObject reqObj) {
        List entryObjList;
        Map isNeedInspectMap;
        JSONObject result = new JSONObject();
        String errMsg = this.isParamInvalid(reqObj);
        if (errMsg.length() > 0) {
            result.put("respCode", (Object)"9999");
            result.put("respMsg", (Object)errMsg);
            return result;
        }
        DynamicObjectCollection inspectInfos = MaterialInspectUtil.queryInspectMaterial((Long)reqObj.getLong("materialId"), (Long)reqObj.getLong("inspectOrgId"), (String)reqObj.getString("bizType"));
        Boolean isNeedInspect = this.inspectQuery(reqObj, inspectInfos);
        result.put("respCode", (Object)"0000");
        result.put("isNeedInspect", (Object)isNeedInspect);
        if (inspectInfos.isEmpty()) {
            return result;
        }
        HashMap map = new HashMap(1);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        String materialId = reqObj.getString("materialId");
        String inspectOrgId = reqObj.getString("inspectOrgId");
        paramMap.put("isNeedInspect", isNeedInspect);
        paramMap.put("bizType", reqObj.getString("bizType"));
        paramMap.put("materialId", materialId);
        paramMap.put("inspectOrgId", inspectOrgId);
        map.put(((DynamicObject)inspectInfos.get(0)).getLong("id"), paramMap);
        PluginProxy<IMaterialInspectSubPlugin> pluginProxy = MaterialInspectServiceImpl.getDimensPluginProxy(null);
        if (!CollectionUtils.isEmpty((Collection)pluginProxy.getPlugins()) && (isNeedInspectMap = (Map)(entryObjList = pluginProxy.callReplace(p -> p.afterIsNeedInspect((Map)map))).get(0)) != null && isNeedInspectMap.containsKey(((DynamicObject)inspectInfos.get(0)).getLong("id"))) {
            isNeedInspect = (Boolean)isNeedInspectMap.get(((DynamicObject)inspectInfos.get(0)).getLong("id"));
            result.put("isNeedInspect", (Object)(isNeedInspect == null ? Boolean.FALSE : isNeedInspect));
        }
        return result;
    }

    public List<Map<String, Object>> isNeedInspectForApi(List<Map<String, Object>> data) {
        Map<String, Map> reqMap = data.stream().collect(Collectors.toMap(x -> String.valueOf(x.get("id")), x -> x));
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id,number", (QFilter[])new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").toArray());
        Map<Object, Object> bizMap = bizTypes.stream().collect(Collectors.toMap(x -> x.get("id"), x -> x.get("number")));
        HashMap<String, JSONObject> requestMap = new HashMap<String, JSONObject>(16);
        reqMap.forEach((key, value) -> {
            JSONObject jsonObject = new JSONObject();
            requestMap.put((String)key, jsonObject);
            value.forEach((arg_0, arg_1) -> ((JSONObject)jsonObject).put(arg_0, arg_1));
            if (jsonObject.containsKey((Object)"bizType")) {
                jsonObject.put("bizType", bizMap.get(jsonObject.get((Object)"bizType")));
            }
        });
        LinkedList<Map<String, Object>> resultList = new LinkedList<Map<String, Object>>();
        Map<String, JSONObject> resultMap = this.isNeedInspectBat(requestMap);
        resultMap.forEach((key, jsonObj) -> {
            jsonObj.put("id", key);
            resultList.add((Map<String, Object>)jsonObj);
        });
        return resultList;
    }

    public Map<String, JSONObject> isNeedInspectBat(Map<String, JSONObject> reqMap) {
        List entryObjList;
        Map isNeedInspectMap;
        if (null == reqMap || 0 == reqMap.size()) {
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>(1);
            JSONObject result = new JSONObject();
            result.put("respCode", (Object)"9999");
            result.put("respMsg", (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"MaterialInspectServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
            resultMap.put("0-0-0-0", result);
            return resultMap;
        }
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>(reqMap.size());
        HashSet invalidKey = new HashSet(reqMap.size());
        reqMap.forEach((id, reqObj) -> {
            String errMsg = this.isParamInvalid((JSONObject)reqObj);
            if (errMsg.length() > 0) {
                JSONObject retObj = new JSONObject();
                retObj.put("respCode", (Object)"9999");
                retObj.put("respMsg", (Object)errMsg);
                resultMap.put((String)id, retObj);
                invalidKey.add(id);
            }
        });
        if (invalidKey.size() == reqMap.size()) {
            return resultMap;
        }
        for (String id2 : invalidKey) {
            reqMap.remove(id2);
        }
        Map<String, DynamicObjectCollection> matInspectInfoMap = this.getMatInspectInfo(reqMap);
        this.formatRetData(reqMap, resultMap, matInspectInfoMap);
        HashMap map = new HashMap(16);
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            String id3 = (String)resultEntry.getKey();
            JSONObject retObj = (JSONObject)resultEntry.getValue();
            if (!reqMap.containsKey(id3)) continue;
            JSONObject reqJsonObject = reqMap.get(id3);
            String bizType = reqJsonObject.getString("bizType");
            String materialId = reqJsonObject.getString("materialId");
            String inspectOrgId = reqJsonObject.getString("inspectOrgId");
            paramMap.put("materialId", materialId);
            paramMap.put("inspectOrgId", inspectOrgId);
            paramMap.put("isNeedInspect", retObj.getBoolean("isNeedInspect"));
            paramMap.put("bizType", bizType);
            DynamicObjectCollection matInspectInfos = matInspectInfoMap.get(bizType + inspectOrgId);
            List matInspectInfoList = matInspectInfos.stream().filter(f -> materialId.equals(f.getString("masterid"))).collect(Collectors.toList());
            if (matInspectInfoList.isEmpty()) continue;
            map.put(((DynamicObject)matInspectInfoList.get(0)).getLong("id"), paramMap);
        }
        if (map.isEmpty()) {
            return resultMap;
        }
        PluginProxy<IMaterialInspectSubPlugin> pluginProxy = MaterialInspectServiceImpl.getDimensPluginProxy(null);
        if (!CollectionUtils.isEmpty((Collection)pluginProxy.getPlugins()) && (isNeedInspectMap = (Map)(entryObjList = pluginProxy.callReplace(p -> p.afterIsNeedInspect((Map)map))).get(0)) != null) {
            for (Map.Entry isNeedInspectEntry : isNeedInspectMap.entrySet()) {
                Long id4 = (Long)isNeedInspectEntry.getKey();
                Boolean isNeedInspect = (Boolean)isNeedInspectEntry.getValue();
                for (Map.Entry<String, JSONObject> reqEntry : reqMap.entrySet()) {
                    JSONObject reqJsonObject = reqEntry.getValue();
                    String materialId = reqJsonObject.getString("materialId");
                    String inspectOrgId = reqJsonObject.getString("inspectOrgId");
                    String bizType = reqJsonObject.getString("bizType");
                    DynamicObjectCollection matInspectInfos = matInspectInfoMap.get(bizType + inspectOrgId);
                    List matInspectInfoList = matInspectInfos.stream().filter(f -> materialId.equals(f.getString("masterid"))).collect(Collectors.toList());
                    if (matInspectInfoList.isEmpty() || ((DynamicObject)matInspectInfoList.get(0)).getLong("id") != id4.longValue()) continue;
                    JSONObject jsonObject = (JSONObject)resultMap.get(reqEntry.getKey());
                    jsonObject.put("isNeedInspect", (Object)(isNeedInspect == null ? Boolean.FALSE : isNeedInspect));
                }
            }
        }
        return resultMap;
    }

    public Map<String, JSONObject> ckInspectInfoBatch(List<JSONObject> reqObjs) {
        HashMap<String, JSONObject> reResult = new HashMap<String, JSONObject>(16);
        if (reqObjs.size() <= 0) {
            return reResult;
        }
        CkInspectInfoHelper ckHelper = new CkInspectInfoHelper();
        ckHelper.iniResReqObjs(reqObjs, reResult);
        Map mapReqObjsOrg = ckHelper.getReqObjsByOrg(reqObjs);
        for (Map.Entry entry : mapReqObjsOrg.entrySet()) {
            List lstReqObj = (List)entry.getValue();
            if (lstReqObj == null || lstReqObj.size() <= 0) continue;
            ckHelper.setSingleInspectInfo(reResult, lstReqObj);
        }
        ckHelper.updateResult(reResult, reqObjs);
        return reResult;
    }

    public JSONObject ckInspectInfo(JSONObject reqObj) {
        ArrayList<JSONObject> reqObjs = new ArrayList<JSONObject>();
        reqObjs.add(reqObj);
        Map<String, JSONObject> reResultMap = this.ckInspectInfoBatch(reqObjs);
        JSONObject reResultObj = null;
        for (Map.Entry<String, JSONObject> entry : reResultMap.entrySet()) {
            reResultObj = entry.getValue();
        }
        return reResultObj;
    }

    private Map<String, DynamicObjectCollection> getMatInspectInfo(Map<String, JSONObject> reqMap) {
        Map<String, List<JSONObject>> inspMatMap = reqMap.values().stream().collect(Collectors.groupingBy(x -> x.getString("bizType") + x.getLong("inspectOrgId")));
        HashMap<String, DynamicObjectCollection> matInspectInfoMap = new HashMap<String, DynamicObjectCollection>(inspMatMap.size());
        inspMatMap.forEach((orgId, reqObjList) -> {
            JSONObject reqObjFst = (JSONObject)reqObjList.get(0);
            String bizType = reqObjFst.getString("bizType");
            Long inspectOrgId = reqObjFst.getLong("inspectOrgId");
            QFilter[] qFilters = MaterialInspectUtil.buildInspectQfilter((Object)bizType, (Long)inspectOrgId);
            qFilters[0].and(new QFilter("masterid", "in", reqObjList.stream().map(x -> x.getLong("materialId")).collect(Collectors.toSet())));
            DynamicObjectCollection matInspectInfo = MaterialInspectUtil.queryInspectMaterial((QFilter[])qFilters);
            matInspectInfoMap.put(bizType + inspectOrgId, matInspectInfo);
        });
        return matInspectInfoMap;
    }

    private String isParamInvalid(JSONObject reqObj) {
        StringBuffer errMsgSb = new StringBuffer();
        this.checkParam(errMsgSb, reqObj, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"MaterialInspectServiceImpl_1", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
        if (null != reqObj) {
            this.checkLongParam(errMsgSb, reqObj.get((Object)"materialId"), ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801materialId", (String)"MaterialInspectServiceImpl_2", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
            this.checkLongParam(errMsgSb, reqObj.get((Object)"inspectOrgId"), ResManager.loadKDString((String)"\u8d28\u68c0\u7ec4\u7ec7inspectOrgId", (String)"MaterialInspectServiceImpl_3", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
            this.checkParam(errMsgSb, reqObj.get((Object)"bizType"), ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578bbizType", (String)"MaterialInspectServiceImpl_4", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
        }
        if (errMsgSb.length() > 0) {
            errMsgSb.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\uff1a", (String)"MaterialInspectServiceImpl_5", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
            return errMsgSb.toString();
        }
        return "";
    }

    private void checkLongParam(StringBuffer errMsgSb, Object param, String errMsg) {
        if (null == param) {
            errMsgSb.append(errMsg);
            errMsgSb.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a;", (String)"MaterialInspectServiceImpl_6", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
        } else if (!(param instanceof Long)) {
            errMsgSb.append(errMsg);
            errMsgSb.append(ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u957f\u6574\u578b;", (String)"MaterialInspectServiceImpl_7", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
        }
    }

    private void checkParam(StringBuffer errMsgSb, Object param, String errMsg) {
        if (null == param) {
            errMsgSb.append(errMsg);
            errMsgSb.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a;", (String)"MaterialInspectServiceImpl_6", (String)"qmc-qcbd-mservice", (Object[])new Object[0]));
        }
    }

    private Boolean inspectQuery(JSONObject reqObj, DynamicObjectCollection inspectInfos) {
        Boolean isNeedInspect = Boolean.FALSE;
        if (!inspectInfos.isEmpty()) {
            Object supplierId = reqObj.get((Object)"supplierId");
            isNeedInspect = "qcp-001".equals(reqObj.get((Object)"bizType")) && supplierId instanceof Long ? Boolean.valueOf(inspectInfos.stream().noneMatch(x -> x.getBoolean("entryentity.nocheckflag") && supplierId.equals(x.get("entryqcp.supplier.id")))) : Boolean.TRUE;
        }
        return isNeedInspect;
    }

    private void formatRetData(Map<String, JSONObject> reqMap, Map<String, JSONObject> resultMap, Map<String, DynamicObjectCollection> matInspectInfoMap) {
        reqMap.forEach((id, reqObj) -> {
            String bizType = reqObj.getString("bizType");
            Long inspectOrgId = reqObj.getLong("inspectOrgId");
            DynamicObjectCollection matInspectInfo = (DynamicObjectCollection)matInspectInfoMap.get(bizType + inspectOrgId);
            Boolean isNeedInspect = this.isNeedInspect((JSONObject)reqObj, bizType, matInspectInfo);
            JSONObject retObj = new JSONObject();
            retObj.put("respCode", (Object)"0000");
            retObj.put("isNeedInspect", (Object)isNeedInspect);
            resultMap.put((String)id, retObj);
        });
    }

    private Boolean isNeedInspect(JSONObject reqObj, String bizType, DynamicObjectCollection matInspectInfo) {
        Boolean isNeedInspect = Boolean.FALSE;
        Long materialId = reqObj.getLong("materialId");
        if (matInspectInfo.isEmpty() || matInspectInfo.stream().noneMatch(x -> materialId.longValue() == x.getLong("masterid"))) {
            return false;
        }
        if ("qcp-001".equals(bizType)) {
            Object supplierId = reqObj.get((Object)"supplierId");
            if (null == supplierId) {
                isNeedInspect = Boolean.TRUE;
            } else {
                Set supplierIdSet = matInspectInfo.stream().filter(x -> materialId.longValue() == x.getLong("masterid") && x.getBoolean("entryentity.nocheckflag")).map(x -> x.get("entryqcp.supplier.id")).collect(Collectors.toSet());
                if (!supplierIdSet.contains(supplierId)) {
                    isNeedInspect = Boolean.TRUE;
                }
            }
        } else {
            isNeedInspect = Boolean.TRUE;
        }
        return isNeedInspect;
    }

    public static PluginProxy<IMaterialInspectSubPlugin> getDimensPluginProxy(IMaterialInspectSubPlugin customDeal) {
        PluginProxy pluginProxy = PluginProxy.create(IMaterialInspectSubPlugin.class, (String)"QMC_QCBD_MATERIALINSPECT");
        if (null != customDeal) {
            pluginProxy = PluginProxy.create((Object)customDeal, IMaterialInspectSubPlugin.class, (String)"QMC_QCBD_MATERIALINSPECT", null);
        }
        return pluginProxy;
    }
}

