/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.mservice.api.QualityOrgManualMigrationService;
import org.apache.commons.collections4.ListUtils;

public class QualityOrgDataMigrationServiceImpl
implements IUpgradeService,
QualityOrgManualMigrationService {
    private static final Log logger = LogFactory.getLog(QualityOrgDataMigrationServiceImpl.class);
    private static final String ROUTEKEY_QMC = "qmc";
    private static final String ROUTEKEY_SYS = "sys";
    private static final int count = 100;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"PomProcessReportUpgradeServiceImpl", () -> {
            try {
                ArrayList<Long> qualityIdList = new ArrayList<Long>(16);
                String qualityOrgSql = "SELECT FID FROM T_QCBD_QUALITYORGTPL WHERE FSTATUS = 'C' AND FSRCID = 0";
                try (DataSet qualityOrgDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)ROUTEKEY_QMC), (String)qualityOrgSql);){
                    qualityOrgDataSet.forEach(f -> qualityIdList.add(f.getLong("FID")));
                }
                logger.info("\u5f00\u59cb\u8fc1\u79fb\u6570\u636e\u3002");
                this.dataMigration(qualityIdList);
                logger.info("\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\u3002");
            }
            catch (Exception e) {
                logger.error("\u6570\u636e\u8fc1\u79fb\u5931\u8d25\u3002", (Throwable)e);
            }
        });
        return new UpgradeResult();
    }

    public void migration(List<Long> qualityIdList) {
        try {
            logger.info("\u5f00\u59cb\u8fc1\u79fb\u6570\u636e\u3002");
            this.dataMigration(qualityIdList);
            logger.info("\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\u3002");
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8fc1\u79fb\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    private void dataMigration(List<Long> qualityIdList) {
        HashSet<String> qualityNumOrgSet = new HashSet<String>(16);
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        this.getData(qualityNumOrgSet, idSet, entryIdSet);
        List qualityIdSplitList = ListUtils.partition(qualityIdList, (int)100);
        logger.info("\u8d28\u68c0\u4e1a\u52a1\u7ec4\u6570\u636e\u5206\u7ec4\u6570" + qualityIdSplitList.size());
        for (List qualityIdBatchList : qualityIdSplitList) {
            this.batchInsertData(qualityNumOrgSet, idSet, entryIdSet, qualityIdBatchList);
        }
    }

    private void batchInsertData(HashSet<String> qualityNumOrgSet, HashSet<Long> idSet, HashSet<Long> entryIdSet, List<Long> qualityIdList) {
        HashSet<Long> qualityEntryIdSet = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FENTRYID FROM T_QCBD_QUALITYORGENTRY WHERE", new Object[0]).appendIn("FID", qualityIdList.toArray());
        try (DataSet qualityEntryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)ROUTEKEY_QMC), (SqlBuilder)sqlBuilder);){
            qualityEntryDataSet.forEach(f -> qualityEntryIdSet.add(f.getLong("FENTRYID")));
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u67e5\u8be2\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5df2\u5ba1\u6838\u5206\u5f55\u6570\u636e\u5931\u8d25\u3002", (String)"QualityOrgDataMigrationServiceImpl_1", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), e);
        }
        logger.info("\u67e5\u8be2\u5230\u8d28\u68c0\u4e1a\u52a1\u7ec4\u5df2\u5ba1\u6838\u5206\u5f55\u6570\uff1a" + qualityEntryIdSet.size());
        idSet.retainAll(qualityIdList);
        entryIdSet.retainAll(qualityEntryIdSet);
        HashMap<String, HashMap<Long, Long>> frontBackIdMap = new HashMap(16);
        try (TXHandle h1 = TX.requiresNew();){
            try {
                frontBackIdMap = this.updateSrcId(qualityIdList, idSet, qualityEntryIdSet, entryIdSet);
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        logger.info("\u5c06\u6570\u636e\u63d2\u5165\u5230\u4e1a\u52a1\u7ec4\u4e2d\u3002");
        this.insertIntoOrg(qualityIdList, qualityEntryIdSet, frontBackIdMap, qualityNumOrgSet);
        logger.info("\u6570\u636e\u63d2\u5165\u4e1a\u52a1\u7ec4\u6210\u529f\u3002");
    }

    private void insertIntoOrg(List<Long> qualityIdList, HashSet<Long> qualityEntryIdSet, HashMap<String, HashMap<Long, Long>> frontBackIdMap, HashSet<String> qualityNumOrgSet) {
        Object glPkId;
        Object qualityNumOrg;
        HashMap<Long, Long> idMap = frontBackIdMap.get("id");
        HashMap<Long, Long> entryIdMap = frontBackIdMap.get("entryId");
        String qualityField = "FID,FNUMBER,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FCREATEORGID,FORGID,FCTRLSTRATEGY,FOPERATORGROUPTYPE,FDESCRIPTION,FNAME,FSRCCREATEORGID,FSRCID";
        String orgInsertField = "FID,FNUMBER,FOPERATORGROUPTYPE,FORGID,FENABLE,FSTATUS,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FMASTERID,FCTRLSTRATEGY,FCREATEORGID,FNAME,FDESCRIPTION,FSRCCREATEORGID,FGROUPDATASHARE";
        SqlBuilder qualitySql = new SqlBuilder();
        qualitySql.append(String.format("SELECT %s FROM T_QCBD_QUALITYORGTPL WHERE", qualityField), new Object[0]).appendIn("FID", qualityIdList.toArray());
        SqlBuilder sql = new SqlBuilder();
        try (DataSet qualityDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(ROUTEKEY_QMC), (SqlBuilder)qualitySql);){
            if (!qualityDataSet.isEmpty()) {
                while (qualityDataSet.hasNext()) {
                    Row row = qualityDataSet.next();
                    String number = row.getString("FNUMBER");
                    qualityNumOrg = row.getString("FNUMBER") + "_" + row.getLong("FCREATEORGID");
                    if (qualityNumOrgSet.contains(qualityNumOrg)) {
                        number = "QMC_" + number;
                    }
                    sql.append(String.format("INSERT INTO T_BD_OPERATORGROUP (%s) VALUES", orgInsertField), new Object[0]);
                    sql.append("(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);", new Object[]{row.get("FSRCID"), number, row.get("FOPERATORGROUPTYPE"), row.get("FORGID"), row.get("FENABLE"), row.get("FSTATUS"), row.get("FCREATORID"), row.get("FCREATETIME"), row.get("FMODIFIERID"), row.get("FMODIFYTIME"), row.get("FMASTERID"), row.get("FCTRLSTRATEGY"), row.get("FCREATEORGID"), row.get("FNAME"), row.get("FDESCRIPTION"), row.get("FSRCCREATEORGID"), Character.valueOf('0')});
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!qualityEntryIdSet.isEmpty()) {
            String selectEntryField = "FID,FENTRYID,FSEQ,FOPERATORID,FOPERATORNUMBER,FOPERATORNAME,FOPERGRPNUMBER,FOPERGRPNAME,FOPERGRPTYPE,FINVALID,FSRCENTRYID";
            String orgInsertEntryField = "FID,FENTRYID,FSEQ,FOPERATORID,FOPERATORNUMBER,FOPERGRPNUMBER,FOPERGRPTYPE,FOPERATORNAME,FOPERGRPNAME,FINVALID,FCHARGE";
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(String.format("SELECT %s FROM T_QCBD_QUALITYORGENTRY WHERE", selectEntryField), new Object[0]).appendIn("FENTRYID", qualityEntryIdSet.toArray());
            try {
                DataSet qualityEntryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)ROUTEKEY_QMC), (SqlBuilder)sqlBuilder);
                qualityNumOrg = null;
                try {
                    if (!qualityEntryDataSet.isEmpty()) {
                        while (qualityEntryDataSet.hasNext()) {
                            Row row = qualityEntryDataSet.next();
                            Object fid = row.get("FID");
                            if (idMap.containsKey(row.get("FID"))) {
                                fid = idMap.get(row.get("FID"));
                            }
                            sql.append(String.format("INSERT INTO T_BD_OPERATORGROUPENTRY (%s) VALUES ", orgInsertEntryField), new Object[0]);
                            sql.append("(?,?,?,?,?,?,?,?,?,?,?);", new Object[]{fid, row.get("FSRCENTRYID"), row.get("FSEQ"), row.get("FOPERATORID"), row.get("FOPERATORNUMBER"), row.get("FOPERGRPNUMBER"), row.get("FOPERGRPTYPE"), row.get("FOPERATORNAME"), row.get("FOPERGRPNAME"), row.get("FINVALID"), Character.valueOf('0')});
                        }
                    }
                }
                catch (Throwable row) {
                    qualityNumOrg = row;
                    throw row;
                }
                finally {
                    if (qualityEntryDataSet != null) {
                        if (qualityNumOrg != null) {
                            try {
                                qualityEntryDataSet.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)qualityNumOrg).addSuppressed(row);
                            }
                        } else {
                            qualityEntryDataSet.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String gl = "FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION";
        SqlBuilder glSql = new SqlBuilder();
        glSql.append(String.format("SELECT %s FROM T_QCBD_QUALITYORGTPL_L WHERE", gl), new Object[0]).appendIn("FID", qualityIdList.toArray());
        try (DataSet glDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(ROUTEKEY_QMC), (SqlBuilder)glSql);){
            if (!glDataSet.isEmpty()) {
                DataSet copyGLDataSet = glDataSet.copy();
                glPkId = DB.genStringIds((String)"T_BD_OPERATORGROUP_L", (int)copyGLDataSet.count("FPKID", false));
                copyGLDataSet.close();
                int i = 0;
                while (glDataSet.hasNext()) {
                    Row row = glDataSet.next();
                    Object fid = row.get("FID");
                    if (idMap.containsKey(row.get("FID"))) {
                        fid = idMap.get(row.get("FID"));
                    }
                    sql.append(String.format("INSERT INTO T_BD_OPERATORGROUP_L (%s) VALUES ", gl), new Object[0]);
                    sql.append("(?,?,?,?,?);", new Object[]{glPkId[i], fid, row.get("FLOCALEID"), row.get("FNAME"), row.get("FDESCRIPTION")});
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!qualityEntryIdSet.isEmpty()) {
            String entryGL = "FPKID,FENTRYID,FLOCALEID,FOPERATORNAME,FOPERGRPNAME";
            SqlBuilder entryGLSql = new SqlBuilder();
            entryGLSql.append(String.format("SELECT %s FROM T_QCBD_QUALITYORGENTRY_L WHERE", entryGL), new Object[0]).appendIn("FENTRYID", qualityEntryIdSet.toArray());
            try {
                DataSet entryGLDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(ROUTEKEY_QMC), (SqlBuilder)entryGLSql);
                glPkId = null;
                try {
                    if (!entryGLDataSet.isEmpty()) {
                        DataSet copyEntryGLDataSet = entryGLDataSet.copy();
                        String[] entryGLPkId = DB.genStringIds((String)"T_BD_OPERATORGROUPENTRY_L", (int)copyEntryGLDataSet.count("FPKID", false));
                        copyEntryGLDataSet.close();
                        int i = 0;
                        while (entryGLDataSet.hasNext()) {
                            Row row = entryGLDataSet.next();
                            Object fentryId = row.get("FENTRYID");
                            if (entryIdMap.containsKey(row.get("FENTRYID"))) {
                                fentryId = entryIdMap.get(row.get("FENTRYID"));
                            }
                            sql.append(String.format("INSERT INTO T_BD_OPERATORGROUPENTRY_L (%s) VALUES ", entryGL), new Object[0]);
                            sql.append("(?,?,?,?,?);", new Object[]{entryGLPkId[i], fentryId, row.get("FLOCALEID"), row.get("FOPERATORNAME"), row.get("FOPERGRPNAME")});
                            ++i;
                        }
                    }
                }
                catch (Throwable copyEntryGLDataSet) {
                    glPkId = copyEntryGLDataSet;
                    throw copyEntryGLDataSet;
                }
                finally {
                    if (entryGLDataSet != null) {
                        if (glPkId != null) {
                            try {
                                entryGLDataSet.close();
                            }
                            catch (Throwable copyEntryGLDataSet) {
                                ((Throwable)glPkId).addSuppressed(copyEntryGLDataSet);
                            }
                        } else {
                            entryGLDataSet.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        DB.execute((DBRoute)new DBRoute(ROUTEKEY_SYS), (SqlBuilder)sql);
        HashSet<Long> repairId = new HashSet<Long>(16);
        for (Long qualityId : qualityIdList) {
            if (idMap.containsKey(qualityId)) {
                repairId.add(idMap.get(qualityId));
                continue;
            }
            repairId.add(qualityId);
        }
        if (!repairId.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", repairId);
            qFilter.and("ctrlstrategy", "!=", (Object)"5");
            DynamicObject[] operatorGroup = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)"id,ctrlstrategy,createorg", (QFilter[])new QFilter[]{qFilter});
            String entity = "bd_operatorgroup";
            String tableName = "T_BD_OPERATORGROUP";
            HashMap dataOrgMap = new HashMap(16);
            Arrays.stream(operatorGroup).forEach(f -> dataOrgMap.put(f.getLong("id"), f.getLong("createorg_id")));
            boolean isTreeType = false;
            BaseDataServiceHelper.presetCtrlOrgUseRangData((String)ROUTEKEY_SYS, (String)entity, (String)tableName, dataOrgMap, (boolean)isTreeType);
        }
    }

    private HashMap<String, HashMap<Long, Long>> updateSrcId(List<Long> qualityIdList, HashSet<Long> idSet, HashSet<Long> qualityEntryIdSet, HashSet<Long> entryIdSet) {
        int i;
        HashMap<String, HashMap<Long, Long>> frontBackIdMap = new HashMap<String, HashMap<Long, Long>>(16);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(16);
        qualityIdList.removeAll(idSet);
        qualityEntryIdSet.removeAll(entryIdSet);
        if (!qualityIdList.isEmpty()) {
            SqlBuilder qmcSql = new SqlBuilder();
            qmcSql.append("UPDATE T_QCBD_QUALITYORGTPL SET FSRCID = FID WHERE", new Object[0]).appendIn("FID", qualityIdList.toArray());
            DB.execute((DBRoute)new DBRoute(ROUTEKEY_QMC), (SqlBuilder)qmcSql);
        }
        if (!qualityEntryIdSet.isEmpty()) {
            SqlBuilder qmcEntrySql = new SqlBuilder();
            qmcEntrySql.append("UPDATE T_QCBD_QUALITYORGENTRY SET FSRCENTRYID = FENTRYID WHERE", new Object[0]).appendIn("FENTRYID", qualityEntryIdSet.toArray());
            DB.execute((DBRoute)new DBRoute(ROUTEKEY_QMC), (SqlBuilder)qmcEntrySql);
        }
        if (!idSet.isEmpty()) {
            long[] newIds = DB.genLongIds((String)"T_BD_OPERATORGROUP", (int)idSet.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(idSet.size());
            String repetition = "UPDATE T_QCBD_QUALITYORGTPL SET FSRCID = ? WHERE FID = ?";
            i = 0;
            for (Long id : idSet) {
                params.add(new Object[]{newIds[i], id});
                idMap.put(id, newIds[i]);
                ++i;
            }
            DB.executeBatch((DBRoute)new DBRoute(ROUTEKEY_QMC), (String)repetition, params);
        }
        if (!entryIdSet.isEmpty()) {
            long[] newEntryIds = DB.genLongIds((String)"T_BD_OPERATORGROUPENTRY", (int)entryIdSet.size());
            ArrayList<Object[]> entryParams = new ArrayList<Object[]>(entryIdSet.size());
            String entryRepetition = "UPDATE T_QCBD_QUALITYORGENTRY SET FSRCENTRYID = ? WHERE FENTRYID = ?";
            i = 0;
            for (long entryId : entryIdSet) {
                entryParams.add(new Object[]{newEntryIds[i], entryId});
                entryIdMap.put(entryId, newEntryIds[i]);
                ++i;
            }
            DB.executeBatch((DBRoute)new DBRoute(ROUTEKEY_QMC), (String)entryRepetition, entryParams);
        }
        qualityIdList.addAll(idSet);
        qualityEntryIdSet.addAll(entryIdSet);
        frontBackIdMap.put("id", idMap);
        frontBackIdMap.put("entryId", entryIdMap);
        return frontBackIdMap;
    }

    private void getData(HashSet<String> qualityNumOrgSet, HashSet<Long> idSet, HashSet<Long> entryIdSet) {
        String orgSql = "SELECT FID,FNUMBER,FCREATEORGID FROM T_BD_OPERATORGROUP";
        try (DataSet orgDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)ROUTEKEY_SYS), (String)orgSql);){
            orgDataSet.forEach(f -> {
                idSet.add(f.getLong("FID"));
                qualityNumOrgSet.add(f.getString("FNUMBER") + "_" + f.getLong("FCREATEORGID"));
            });
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u7ec4\u5df2\u5ba1\u6838\u6570\u636e\u5931\u8d25\u3002", (String)"QualityOrgDataMigrationServiceImpl_2", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), e);
        }
        String orgEntrySql = "SELECT FENTRYID FROM T_BD_OPERATORGROUPENTRY";
        try (DataSet orgEntryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)ROUTEKEY_SYS), (String)orgEntrySql);){
            orgEntryDataSet.forEach(f -> entryIdSet.add(f.getLong("FENTRYID")));
        }
        catch (Exception e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u7ec4\u5206\u5f55\u6570\u636e\u5931\u8d25\u3002", (String)"QualityOrgDataMigrationServiceImpl_3", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), e);
        }
    }
}

