/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.mservice.api.ISampleSchemService;

public class SampleSchemServiceImpl
implements ISampleSchemService {
    private static final Log logger = LogFactory.getLog(SampleSchemServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getTransSampleQty(Map<String, Object> params) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        JSONObject resObj = null;
        try {
            logger.info("transample paras begin:" + JSONObject.toJSONString(params));
            String errMsg = this.getValidMessage(params);
            if (errMsg.length() > 0) {
                throw new KDBizException(errMsg);
            }
            Long materialid = (Long)params.get("materialid");
            BigDecimal materialqty = (BigDecimal)params.get("materialqty");
            Long srcunitid = (Long)params.get("srcunitid");
            Long tranunitid = (Long)params.get("tranunitid");
            Long sampleid = (Long)params.get("sampleid");
            String rule = "A";
            if (params.containsKey("rule")) {
                rule = String.valueOf(params.get("rule"));
            }
            DynamicObject sampSchemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)sampleid, (String)"qcbd_sampscheme");
            DynamicObject tranunitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)tranunitid, (String)"bd_measureunits");
            BigDecimal tranqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialid, (Long)srcunitid, (BigDecimal)materialqty, (DynamicObject)tranunitObj);
            logger.info("transample tranqty:" + tranqty);
            CkSampleCaleModel sampleModel = new CkSampleCaleModel(sampSchemeObj, tranqty, tranunitObj, rule);
            CkSampleCaleResModel resModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
            if (resModel != null) {
                logger.info("transample resModel:" + resModel);
                result.setData((Object)resModel.getRinsQty());
            }
        }
        catch (Exception ex) {
            result = MserviceResult.newFailInstance();
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            result.setRetMsg(errMsg);
            logger.error("transample  error:" + errMsg);
        }
        finally {
            resObj = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)result), JSONObject.class);
        }
        return resObj;
    }

    private String getValidMessage(Map<String, Object> params) {
        String errMsg = "";
        if (!(params.get("materialid") instanceof Long)) {
            errMsg = "The materialid is not a long  type";
        } else if (!(params.get("materialqty") instanceof BigDecimal)) {
            errMsg = "The materialqty is not a bigDecimal  type";
        } else if (!(params.get("srcunitid") instanceof Long)) {
            errMsg = "The srcunit is not a long  type";
        } else if (!(params.get("tranunitid") instanceof Long)) {
            errMsg = "The tranunit is not a long  type";
        } else if (!(params.get("sampleid") instanceof Long)) {
            errMsg = "The sampleid is not a long  type";
        }
        return errMsg;
    }
}

