/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.measure;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.mservice.api.IInspectJudgeMeasureService;
import kd.qmc.qcbd.mservice.dto.JudgeMeasureReq;
import kd.qmc.qcbd.mservice.dto.JudgeMeasureRes;

public class InspectJudgeMeasureServiceImpl
implements IInspectJudgeMeasureService {
    public String judgeMeasureValResult(String reqObj) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        try {
            List judgeMeasureReqList = JSON.parseArray((String)reqObj, JudgeMeasureReq.class);
            List<JudgeMeasureRes> resList = InspectJudgeMeasureServiceImpl.judgeMeasureValRes(judgeMeasureReqList);
            result.setData(resList);
        }
        catch (Exception e) {
            result.setRetCode("-1");
            String errMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u5b9e\u6d4b\u503c\u5931\u8d25\uff1a%s", (String)"InspectJudgeMeasureServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]);
            result.setRetMsg(String.format(errMsg, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return JSON.toJSONString((Object)result);
    }

    public static final List<JudgeMeasureRes> judgeMeasureValRes(List<JudgeMeasureReq> judgeMeasureReqList) {
        ArrayList<JudgeMeasureRes> resList = new ArrayList<JudgeMeasureRes>(10);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection matflgeDyos = QueryServiceHelper.query((String)"qcbd_matchflag", (String)"id,number", (QFilter[])qFilter.toArray());
        Map<Long, String> matFlagMap = matflgeDyos.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("number"), (a, b) -> a));
        for (JudgeMeasureReq judgeMeasureReq : judgeMeasureReqList) {
            String normtype = judgeMeasureReq.getNormtype();
            String matchflag = matFlagMap.get(judgeMeasureReq.getMatchflag());
            CheckProjectCaleModel model = new CheckProjectCaleModel();
            model.setNormtype(normtype);
            model.setMatchflag(matchflag);
            model.setSpecvalue(judgeMeasureReq.getSpecvalue());
            model.setTopvalue(judgeMeasureReq.getTopvalue());
            model.setDownvalue(judgeMeasureReq.getDownvalue());
            model.setMeasuredValDeter(judgeMeasureReq.getMeasuredValDeter());
            model.setMeasuredValRat(judgeMeasureReq.getMeasuredValRat());
            JudgeMeasureRes res = new JudgeMeasureRes();
            res.setProjUuid(judgeMeasureReq.getProjUuid());
            res.setSampleId(judgeMeasureReq.getSampleId());
            ICheckProjectCaleStrategy ckProjectStrategy = CheckProjectCaleFactory.getInstance().getCkProjectStrategy(matchflag, normtype);
            if (Objects.nonNull(ckProjectStrategy)) {
                String measureRes = ckProjectStrategy.judgmentResultMain(model);
                res.setMeasureResult(measureRes);
            } else {
                res.setMeasureResult("");
            }
            resList.add(res);
        }
        return resList;
    }
}

