/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.measure;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectServiceHelper;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.constant.basedata.inspectstd.InspectstdConst;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;

public class MeasuredValServiceImpl {
    private static final int BATCH_SIZE = 10;
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String DATA = "data";
    private static final String BILLID = "billid";
    private static final String ENTRYID = "entryid";
    private static final String PROJECTID = "projectid";
    private static final String SAMPLENUMID = "samplenumid";
    private static final String MEASUREDVAL = "measuredval";
    public static final String SYSTEM_TYPE = "qmc-qcbd-mservice";
    public static final List<String> MEASUREVAL_DETER_LIST = Arrays.asList("Y", "N");

    public MserviceResult saveMeasuredValInfo(Map<String, Object> reqObj) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        try {
            String errMsg = this.validRequestObj(reqObj);
            if (StringUtils.isNotEmpty((String)errMsg)) {
                result.setRetCode("-1");
                result.setRetMsg(errMsg);
                return result;
            }
            String entitynumber = (String)reqObj.get(ENTITYNUMBER);
            List data = (List)reqObj.get(DATA);
            Map<Long, List<Map<String, Object>>> billReqGroup = data.stream().collect(Collectors.groupingBy(x -> (Long)x.get(BILLID)));
            if (billReqGroup.size() > 10) {
                Set<Long> billIdSet = billReqGroup.keySet();
                HashSet<Long> billIdBatchSet = new HashSet<Long>(16);
                for (Long billId : billIdSet) {
                    billIdBatchSet.add(billId);
                    if (10 != billIdBatchSet.size()) continue;
                    this.batchSaveBillMeasureVal(entitynumber, billIdBatchSet, billReqGroup);
                    billIdBatchSet.clear();
                }
            } else {
                this.batchSaveBillMeasureVal(entitynumber, billReqGroup.keySet(), billReqGroup);
            }
        }
        catch (Exception e) {
            result.setRetCode("-1");
            String errMsg = ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MeasuredValServiceImpl_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            result.setRetMsg(String.format(errMsg, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return result;
    }

    private void batchSaveBillMeasureVal(String entitynumber, Set<Long> billIdSet, Map<Long, List<Map<String, Object>>> billReqGroup) {
        if (billIdSet.isEmpty()) {
            return;
        }
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((Object[])billIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entitynumber));
        Set ilegalBillIdSet = Arrays.stream(billObjs).filter(x -> "A".equals(x.getString("billstatus"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        if (billIdSet.size() > ilegalBillIdSet.size()) {
            billIdSet.removeAll(ilegalBillIdSet);
            Set billIdStrSet = billIdSet.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0bbillid\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e\u6216\u5355\u636e\u4e0d\u4e3a\u6682\u5b58\u72b6\u6001\uff1a%s\u3002", (String)"MeasuredValServiceImpl_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", billIdStrSet)));
        }
        for (DynamicObject billObj : billObjs) {
            long billId = billObj.getLong("id");
            List<Map<String, Object>> billReqList = billReqGroup.get(billId);
            Map<Long, List<Map>> entryReqGroup = billReqList.stream().collect(Collectors.groupingBy(x -> (Long)x.get(ENTRYID)));
            Set<Map.Entry<Long, List<Map>>> entryReqGroupSet = entryReqGroup.entrySet();
            DynamicObjectCollection matIntoEntry = billObj.getDynamicObjectCollection("matintoentity");
            for (Map.Entry<Long, List<Map>> entryReqGroupEntry : entryReqGroupSet) {
                Long entryId = entryReqGroupEntry.getKey();
                List<Map<String, Object>> entryInfoList = entryReqGroupEntry.getValue();
                Optional<DynamicObject> findAnyRow = matIntoEntry.stream().filter(x -> x.getPkValue().equals(entryId)).findAny();
                if (!findAnyRow.isPresent()) continue;
                DynamicObject matRow = findAnyRow.get();
                this.formatMatRow(matRow, entryInfoList);
            }
        }
        SaveServiceHelper.save((DynamicObject[])billObjs);
    }

    private void formatMatRow(DynamicObject matRow, List<Map<String, Object>> entryInfoList) {
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        DynamicObjectCollection subSampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        DynamicObjectCollection subMeasureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
        this.buildMeasureValEntry(inspSubEntry, subMeasureEntry, entryInfoList);
        InspectCkvalHelper.dealSampEntry((boolean)true, (DynamicObjectCollection)subMeasureEntry, (DynamicObjectCollection)subSampEntry, (int)inspSubEntry.size());
        InspectCkvalHelper.dealProjEntry((boolean)true, (DynamicObjectCollection)subMeasureEntry, (int)subSampEntry.size(), (DynamicObjectCollection)inspSubEntry, (boolean)true);
        if (matRow.containsProperty("acstr")) {
            InspectServiceHelper.refreshMatRow((DynamicObject)matRow, (DynamicObjectCollection)subSampEntry);
        }
    }

    private void buildMeasureValEntry(DynamicObjectCollection inspSubEntry, DynamicObjectCollection subMeasureEntry, List<Map<String, Object>> entryInfoList) {
        List sortedList = entryInfoList.stream().sorted(Comparator.comparing(a -> String.format("%s-%s", a.get(PROJECTID), a.get(SAMPLENUMID)))).collect(Collectors.toList());
        Map<String, DynamicObject> inspSubMap = inspSubEntry.stream().collect(Collectors.toMap(x -> x.getString("uquuid"), x -> x));
        int projSampSeq = 1;
        int seq = 1;
        String lastProjUUid = "";
        for (Map subMeasureValMap : sortedList) {
            String projUuid = (String)subMeasureValMap.get(PROJECTID);
            DynamicObject inspItemInfo = inspSubMap.get(projUuid);
            if (null == inspItemInfo) continue;
            if (inspItemInfo.getBoolean("isjoininspect") && inspItemInfo.containsProperty("joininspectstatus") && StringUtils.isNotEmpty((String)inspItemInfo.getString("joininspectstatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u542f\u7528\u8054\u5408\u68c0\u9a8c\u7684\u68c0\u9a8c\u5355\u4e0d\u5141\u8bb8\u5f55\u5165\u8054\u5408\u68c0\u9a8c\u9879\u7684\u5b9e\u6d4b\u503c\uff0c\u8054\u5408\u68c0\u9a8c\u9879\u552f\u4e00\u6807\u8bc6\uff1a%s\u3002", (String)"MeasuredValServiceImpl_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), inspItemInfo.getString("uquuid")));
            }
            projSampSeq = lastProjUUid.equals(projUuid) ? ++projSampSeq : 1;
            lastProjUUid = projUuid;
            this.buildSingleJudgeMeasureRow(subMeasureEntry, projSampSeq, ++seq, subMeasureValMap, projUuid, inspItemInfo);
        }
    }

    private void buildSingleJudgeMeasureRow(DynamicObjectCollection subMeasureEntry, int projSampSeq, int seq, Map<String, Object> subMeasureValMap, String projUuid, DynamicObject inspItemInfo) {
        Long sampleNumid = (Long)subMeasureValMap.get(SAMPLENUMID);
        Optional<DynamicObject> optional = subMeasureEntry.stream().filter(x -> x.getString("projuuid").equals(projUuid) && x.getLong("exmapleid") == sampleNumid.longValue()).findAny();
        DynamicObject subMeasureRow = null;
        if (!optional.isPresent()) {
            subMeasureRow = subMeasureEntry.addNew();
            subMeasureRow.set("projuuid", (Object)projUuid);
            subMeasureRow.set("exmapleid", (Object)sampleNumid);
        } else {
            subMeasureRow = optional.get();
        }
        subMeasureRow.set("seq", (Object)seq);
        subMeasureRow.set("samp_seq", (Object)projSampSeq);
        String measuredval = (String)subMeasureValMap.get(MEASUREDVAL);
        String normType = inspItemInfo.getString("normtype");
        if (InspectstdConst.NORMTYPEENUM.B.name().equals(normType)) {
            if (StringUtils.isNotEmpty((String)measuredval) && !MEASUREVAL_DETER_LIST.contains(measuredval)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u6027\u65f6\uff0c\u5b9e\u6d4b\u503c\u5e94\u8be5\u4e3aY\u3001N\uff0c\u5f53\u524d\u5b9e\u6d4b\u503c\u4e3a%s\u3002", (String)"MeasuredValServiceImpl_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), measuredval));
            }
            subMeasureRow.set("measuredval_deter", (Object)measuredval);
        } else {
            if (StringUtils.isNotEmpty((String)measuredval) && !StringUtils.isNumeric((String)measuredval.replaceFirst("-", ""))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u91cf\u65f6\uff0c\u5b9e\u6d4b\u503c\u5e94\u8be5\u4e3a\u6570\u503c\uff0c\u5f53\u524d\u5b9e\u6d4b\u503c\u4e3a%s\u3002", (String)"MeasuredValServiceImpl_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), measuredval));
            }
            subMeasureRow.set("measuredval_rat", (Object)measuredval);
        }
        if (StringUtils.isNotEmpty((String)measuredval)) {
            DynamicObject matchFlagObj = inspItemInfo.getDynamicObject("matchflag");
            String matchFlag = null == matchFlagObj ? " " : matchFlagObj.getString("number");
            ICheckProjectCaleStrategy ckProjectStrategy = CheckProjectCaleFactory.getInstance().getCkProjectStrategy(matchFlag, normType);
            CheckProjectCaleModel model = new CheckProjectCaleModel();
            model.setNormtype(normType);
            model.setMatchflag(matchFlag);
            model.setSpecvalue(inspItemInfo.getString("specvalue"));
            model.setTopvalue(inspItemInfo.getBigDecimal("topvalue"));
            model.setDownvalue(inspItemInfo.getBigDecimal("downvalue"));
            model.setMeasuredValDeter(subMeasureRow.getString("measuredval_deter"));
            String measureValRat = subMeasureRow.getString("measuredval_rat");
            if (StringUtils.isNotEmpty((String)measureValRat) && StringUtils.isNumeric((String)measureValRat)) {
                model.setMeasuredValRat(new BigDecimal(measureValRat));
            }
            String measureRes = null == ckProjectStrategy ? " " : ckProjectStrategy.judgmentResultMain(model);
            subMeasureRow.set("measuredval_judge", (Object)measureRes);
        } else {
            subMeasureRow.set("measuredval_judge", (Object)"");
        }
    }

    private String validRequestObj(Map<String, Object> reqObj) {
        if (null == reqObj || reqObj.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a\u3002", (String)"MeasuredValServiceImpl_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        Object entitynumber = reqObj.get(ENTITYNUMBER);
        if (null == entitynumber || StringUtils.isEmpty((String)entitynumber.toString())) {
            return this.getErrMsg(ENTITYNUMBER);
        }
        Object dataObj = reqObj.get(DATA);
        if (!(dataObj instanceof List)) {
            return this.getErrMsg(DATA);
        }
        List data = (List)dataObj;
        if (this.validList(data, BILLID)) {
            return this.getErrMsg(BILLID);
        }
        if (this.validList(data, ENTRYID)) {
            return this.getErrMsg(ENTRYID);
        }
        if (this.validList(data, SAMPLENUMID)) {
            return this.getErrMsg(SAMPLENUMID);
        }
        if (data.stream().anyMatch(x -> null == x.get(PROJECTID) || StringUtils.isEmpty((String)x.get(PROJECTID).toString()))) {
            return this.getErrMsg(PROJECTID);
        }
        if (data.stream().anyMatch(x -> null == x.get(MEASUREDVAL))) {
            return this.getErrMsg(MEASUREDVAL);
        }
        return "";
    }

    private boolean validList(List<Map<String, Object>> data, String keyId) {
        return data.stream().anyMatch(x -> !(x.get(keyId) instanceof Long));
    }

    private String getErrMsg(String entitynumber) {
        return String.format(ResManager.loadKDString((String)"%s\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u6570\u636e\u6821\u9a8c\u4e0d\u5408\u6cd5\u3002", (String)"MeasuredValServiceImpl_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), entitynumber);
    }
}

