/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.qualitycheck;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.commonmodel.mservice.MserviceResult;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.util.mathformaul.MathCalculatorUtil;
import kd.qmc.qcbd.mservice.businessobject.QualityCheckResultBo;
import kd.qmc.qcbd.mservice.businessobject.QualityCheckResultEntryBo;

public class InspectUnauditCheckImpl {
    private String entryKey = "";
    private String baseQtyKey = "";
    private final String typeInspect = "inspectbill";
    private static final Log logger = LogFactory.getLog(InspectUnauditCheckImpl.class);

    public MserviceResult<JSONArray> getUnauditAuthority(String appId, List<DynamicObject> billDyoList, Map<String, String> qmcSystemPropMap) {
        MserviceResult result = MserviceResult.newSuccessInstance();
        JSONArray jsonArrayResult = new JSONArray();
        ArrayList<QualityCheckResultEntryBo> qualityCheckResultEntryBoList = new ArrayList<QualityCheckResultEntryBo>();
        try {
            Set<String> billIds = billDyoList.stream().map(o -> o.getString("id")).collect(Collectors.toSet());
            DynamicObjectCollection inspectObjCol = this.getInspectObjCol(appId, billIds);
            Map<Long, DynamicObject> billDyoSelfMap = billDyoList.stream().collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (a, b) -> a));
            Map<String, List<DynamicObject>> srcEntityNumberGroup = inspectObjCol.stream().collect(Collectors.groupingBy(o -> o.getString("srcentitynumber")));
            for (Map.Entry<String, List<DynamicObject>> entityInspectObj : srcEntityNumberGroup.entrySet()) {
                String srcEntityNumber = entityInspectObj.getKey();
                List<DynamicObject> inspectObjList = entityInspectObj.getValue();
                String jsonParamStr = qmcSystemPropMap.get(srcEntityNumber + "||" + billDyoList.get(0).getDataEntityType().getName());
                if (StringUtils.isBlank((CharSequence)jsonParamStr)) continue;
                JSONObject paramJson = JSON.parseObject((String)jsonParamStr);
                this.setFieldKey(paramJson.getString("type"));
                Map<String, Object> sendInspResult = this.getSendInspResult(appId, srcEntityNumber, inspectObjList);
                List resultMapList = (List)sendInspResult.get("data");
                Map<Object, Map<String, Object>> srcEntryidResultMap = resultMapList.stream().collect(Collectors.toMap(o -> o.get("call_entryid"), o -> o, (a, b) -> a));
                String linkEntryIdKey = StringUtils.isNotBlank((CharSequence)paramJson.getString("linkentrynum")) ? paramJson.getString("linkentrynum") + ".id" : "id";
                DynamicObjectCollection businessCol = this.getBusinessCol(paramJson, inspectObjList, srcEntityNumber);
                Map<Long, DynamicObject> businessDyoSelfMap = businessCol.stream().collect(Collectors.toMap(o -> o.getLong(linkEntryIdKey), o -> o, (a, b) -> a));
                qualityCheckResultEntryBoList.addAll(this.judgeResult(billDyoSelfMap, srcEntryidResultMap, inspectObjList, businessDyoSelfMap, paramJson));
            }
            Map<Long, List<QualityCheckResultEntryBo>> checkResultGroupByBillId = qualityCheckResultEntryBoList.stream().collect(Collectors.groupingBy(o -> o.getBillId()));
            for (Map.Entry<Long, List<QualityCheckResultEntryBo>> checkResultEntry : checkResultGroupByBillId.entrySet()) {
                QualityCheckResultBo qualityCheckResultBo = new QualityCheckResultBo();
                qualityCheckResultBo.setBillId(checkResultEntry.getKey());
                List<QualityCheckResultEntryBo> QualityCheckResultEntryBos = checkResultEntry.getValue();
                qualityCheckResultBo.setEntryDetail(QualityCheckResultEntryBos);
                qualityCheckResultBo.setCanUnAudit(QualityCheckResultEntryBos.stream().anyMatch(o -> o.getCanUnAudit() == false) ? Boolean.FALSE : Boolean.TRUE);
                jsonArrayResult.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)qualityCheckResultBo)));
            }
            result.setData((Object)jsonArrayResult);
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(exceptionStackTraceMessage);
            result.setRetCode("-1");
            result.setRetMsg(exceptionStackTraceMessage);
        }
        return result;
    }

    private List<QualityCheckResultEntryBo> judgeResult(Map<Long, DynamicObject> billDyoSelfMap, Map<Object, Map<String, Object>> srcEntryidResultMap, List<DynamicObject> inspectObjList, Map<Long, DynamicObject> businessDyoSelfMap, JSONObject paramJson) {
        ArrayList<QualityCheckResultEntryBo> resultList = new ArrayList<QualityCheckResultEntryBo>(10);
        String[] propArray = paramJson.getString("prop").split(",");
        JSONArray caluseJsonArray = paramJson.getJSONArray("caluse");
        for (DynamicObject inspectObj : inspectObjList) {
            Optional<DynamicObject> entryObjOpt;
            DynamicObject billObj;
            DynamicObject srcEntry;
            BigDecimal judgeQty;
            long billid = inspectObj.getLong("billid");
            long srcentryid = inspectObj.getLong("srcentryid");
            boolean isMergeRbjs = false;
            String type = paramJson.getString("type");
            String caluseQtyStr = "";
            HashSet handModeSet = new HashSet(16);
            String handModeId = inspectObj.getString("handmode");
            for (Object obj : caluseJsonArray) {
                JSONObject caluse = (JSONObject)obj;
                Object[] handModeIds = caluse.getString("handmodeid").split(",");
                String mergeRbjs = "merge_rbjs";
                isMergeRbjs = StringUtils.equals((CharSequence)mergeRbjs, (CharSequence)caluse.getString("caluseqty_type"));
                if (handModeIds.length > 0 && StringUtils.isNotBlank((CharSequence)handModeIds[0])) {
                    if (!ArrayUtils.contains((Object[])handModeIds, (Object)handModeId) && !isMergeRbjs) continue;
                    caluseQtyStr = caluse.getString("caluseqty");
                    handModeSet.addAll(Arrays.stream(handModeIds).map(Long::parseLong).collect(Collectors.toSet()));
                    break;
                }
                caluseQtyStr = caluse.getString("caluseqty");
            }
            Map<String, Object> inspResultMap = srcEntryidResultMap.get(srcentryid);
            BigDecimal qualifiedBaseqty = BigDecimal.ZERO;
            Object qualified_baseqty = inspResultMap.get("qualified_baseqty");
            if (Objects.nonNull(qualified_baseqty)) {
                qualifiedBaseqty = new BigDecimal(qualified_baseqty.toString());
            }
            BigDecimal unqualifiedBaseqty = BigDecimal.ZERO;
            List unqualifiedInfos = (List)inspResultMap.get("unqualified_info");
            Optional<BigDecimal> unqualifiedBaseqtyOpt = unqualifiedInfos.stream().filter(o -> handModeSet.contains(o.get("handmodeid"))).map(o -> new BigDecimal(o.get("unqualified_baseqty").toString())).reduce(BigDecimal::add);
            if (unqualifiedBaseqtyOpt.isPresent()) {
                unqualifiedBaseqty = unqualifiedBaseqtyOpt.get();
            }
            BigDecimal bigDecimal = judgeQty = StringUtils.equals((CharSequence)"inspectbill", (CharSequence)type) ? qualifiedBaseqty : unqualifiedBaseqty;
            if (isMergeRbjs) {
                judgeQty = qualifiedBaseqty.add(unqualifiedBaseqty);
            }
            if (Objects.nonNull(srcEntry = businessDyoSelfMap.get(inspectObj.getLong("srcentryid")))) {
                for (String prop : propArray) {
                    caluseQtyStr = caluseQtyStr.replace(prop, srcEntry.getBigDecimal(prop).stripTrailingZeros().toPlainString());
                }
                try {
                    judgeQty = judgeQty.subtract(MathCalculatorUtil.calculator((String)caluseQtyStr));
                }
                catch (Exception e) {
                    String errInfo = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6570\u91cf\u6821\u9a8c\uff0c\u6839\u636e\u516c\u5f0f\u81ea\u52a8\u8ba1\u7b97\u5f02\u5e38\uff1a%s\u3002", (String)"InspectUnauditCheckImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    logger.error(errInfo);
                    throw new KDBizException(errInfo);
                }
            }
            if (Objects.nonNull(billObj = billDyoSelfMap.get(billid)) && (entryObjOpt = billObj.getDynamicObjectCollection(this.entryKey).stream().filter(entry -> entry.getLong("id") == inspectObj.getLong("billentryid")).findFirst()).isPresent()) {
                judgeQty = judgeQty.subtract(entryObjOpt.get().getBigDecimal(this.baseQtyKey));
            }
            QualityCheckResultEntryBo qualityCheckResultEntryBo = new QualityCheckResultEntryBo();
            qualityCheckResultEntryBo.setBillId(billid);
            qualityCheckResultEntryBo.setEntryId(inspectObj.getLong("billentryid"));
            qualityCheckResultEntryBo.setEntrySeq(inspectObj.getInt("billentryseq"));
            if (BigDecimal.ZERO.compareTo(judgeQty) > 0) {
                qualityCheckResultEntryBo.setCanUnAudit(Boolean.FALSE);
            } else {
                qualityCheckResultEntryBo.setCanUnAudit(Boolean.TRUE);
            }
            resultList.add(qualityCheckResultEntryBo);
        }
        return resultList;
    }

    private DynamicObjectCollection getInspectObjCol(String appId, Set<String> billIds) {
        String entityNameInspObj = InspObjectHelper.getInspObjEntityNumberByAppid((String)appId);
        String selectFields = "srcentitynumber,srcbillid,srcentryid,entryentity.ass_billid billid,entryentity.ass_billentryid billentryid,entryentity.ass_billentryseq billentryseq,entryentity.ass_newhandmode handmode";
        return QueryServiceHelper.query((String)entityNameInspObj, (String)selectFields, (QFilter[])new QFilter("entryentity.ass_billid", "in", billIds).toArray());
    }

    private Map<String, Object> getSendInspResult(String appId, String srcEntityNumber, List<DynamicObject> inspectObjList) {
        HashMap<String, Object> postParam = new HashMap<String, Object>(16);
        postParam.put("call_entitynumber", srcEntityNumber);
        LinkedList<String> appNumbers = new LinkedList<String>();
        appNumbers.add(appId);
        LinkedList sendData = new LinkedList();
        for (DynamicObject inspectObj : inspectObjList) {
            HashMap<String, Long> dataMap = new HashMap<String, Long>(16);
            dataMap.put("call_billid", inspectObj.getLong("srcbillid"));
            dataMap.put("call_entryid", inspectObj.getLong("srcentryid"));
            sendData.add(dataMap);
        }
        postParam.put("send_data", sendData);
        postParam.put("inspect_appnumbers", appNumbers);
        LinkedList<String> sendEntitys = new LinkedList<String>();
        sendEntitys.add(srcEntityNumber);
        postParam.put("send_entitys", sendEntitys);
        return (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"InspectResultService", (String)"getInspectResult", (Object[])new Object[]{postParam});
    }

    private DynamicObjectCollection getBusinessCol(JSONObject paramJson, List<DynamicObject> inspectObjList, String srcEntityNumber) {
        QFilter qFilter;
        if (Objects.isNull(paramJson)) {
            return new DynamicObjectCollection();
        }
        String linkEntryNum = paramJson.getString("linkentrynum");
        String linkEntryIdKey = "id";
        if (StringUtils.isNotBlank((CharSequence)linkEntryNum)) {
            linkEntryIdKey = linkEntryNum + ".id";
            qFilter = new QFilter(linkEntryIdKey, "in", inspectObjList.stream().map(o -> o.getLong("srcentryid")).collect(Collectors.toSet()));
        } else {
            qFilter = new QFilter("id", "in", inspectObjList.stream().map(o -> o.getLong("srcbillid")).collect(Collectors.toSet()));
        }
        return QueryServiceHelper.query((String)srcEntityNumber, (String)(linkEntryIdKey + "," + paramJson.getString("prop")), (QFilter[])qFilter.toArray());
    }

    private void setFieldKey(String type) {
        if (StringUtils.equals((CharSequence)"inspectbill", (CharSequence)type)) {
            this.entryKey = "matintoentity";
            this.baseQtyKey = "basequaliqty";
        } else {
            this.entryKey = "materialentry";
            this.baseQtyKey = "baseqty";
        }
    }
}

