/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class BizTypeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BizTypeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        return this.repaireBizType(null);
    }

    public UpgradeResult repaireBizType(Map<String, Object> params) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        this.repaireLogic(params, result);
        if (result.isSuccess()) {
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"biztype_updata", (String)"1");
        } else {
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"biztype_updata", (String)"0");
        }
        return result;
    }

    private void repaireLogic(Map<String, Object> params, UpgradeResult result) {
        try {
            DynamicObjectCollection qcbdBizTypeIds;
            Object dataidTag;
            QFilter filter = new QFilter("number", "=", (Object)"qcbd_biztype");
            boolean containEntity = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{filter});
            if (!containEntity) {
                return;
            }
            boolean newCustomer = UpgradeSqlUtil.isNewCustomer((String)this.getClass().getName());
            if (newCustomer) {
                return;
            }
            QFilter[] bdBizFilters = new QFilter("domain", "=", (Object)"8").and("status", "=", (Object)"C").and("enable", "=", (Object)"1").toArray();
            DynamicObjectCollection bdBizTypeIds = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])bdBizFilters);
            QFilter qcbdBizFilter = new QFilter("id", "not in", bdBizTypeIds.stream().map(x -> x.getLong("id")).collect(Collectors.toSet())).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            if (null != params && null != (dataidTag = params.get("dataid_tag")) && StringUtils.isNotEmpty((String)dataidTag.toString())) {
                String[] dataidArr = dataidTag.toString().split(",");
                qcbdBizFilter.and("id", "in", Arrays.stream(dataidArr).map(x -> Long.parseLong(x)).collect(Collectors.toSet()));
            }
            if ((qcbdBizTypeIds = QueryServiceHelper.query((String)"qcbd_biztype", (String)"id", (QFilter[])qcbdBizFilter.toArray())).isEmpty()) {
                return;
            }
            MainEntityType bdBizEntity = EntityMetadataCache.getDataEntityType((String)"bd_biztype");
            Set qcbdBizTypeIdSet = qcbdBizTypeIds.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] biztypes = BusinessDataServiceHelper.load((Object[])qcbdBizTypeIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"qcbd_biztype"));
            DynamicObject[] bdBizObjArr = new DynamicObject[qcbdBizTypeIdSet.size()];
            int index = 0;
            for (DynamicObject bizType : biztypes) {
                DynamicObject bdBizObj = new DynamicObject((DynamicObjectType)bdBizEntity);
                this.copyData(bdBizObj, bizType, "id", "masterid", "number", "name", "status", "enable", "creator", "createtime", "modifier", "modifytime");
                bdBizObj.set("domain", (Object)"8");
                bdBizObjArr[index++] = bdBizObj;
            }
            SaveServiceHelper.save((DynamicObject[])bdBizObjArr);
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
    }

    private void copyData(DynamicObject bdBizObj, DynamicObject qcbdBizObj, String ... props) {
        for (String prop : props) {
            bdBizObj.set(prop, qcbdBizObj.get(prop));
        }
    }
}

