/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterLocalCache;
import kd.bos.param.ParameterUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class BllTypeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BllTypeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        return this.repaireBillType(null);
    }

    public UpgradeResult repaireBillType(Map<String, Object> params) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        this.repaireLogic(params, result);
        if (result.isSuccess()) {
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"billtype_updata", (String)"1");
        } else {
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"billtype_updata", (String)"0");
        }
        return result;
    }

    private void repaireLogic(Map<String, Object> params, UpgradeResult result) {
        try {
            QFilter filter = new QFilter("number", "=", (Object)"qcbd_biztype");
            boolean containEntity = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{filter});
            if (!containEntity) {
                return;
            }
            boolean newCustomer = UpgradeSqlUtil.isNewCustomer((String)this.getClass().getName());
            if (newCustomer) {
                return;
            }
            String billTypeIdStr = null == params ? "" : (null == params.get("dataid_tag") ? "" : params.get("dataid_tag").toString());
            DynamicObject[] billTypeArr = BusinessDataServiceHelper.load((Object[])this.getBllTypeId("1", "1", billTypeIdStr).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_billtype"));
            DynamicObject[] custBizInfos = this.getBizInfos("0");
            this.saveParameter(billTypeArr, custBizInfos);
            DynamicObject[] custBillTypeArr = BusinessDataServiceHelper.load((Object[])this.getBllTypeId("0", null, billTypeIdStr).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_billtype"));
            DynamicObject[] bizInfos = this.getBizInfos(null);
            this.saveParameter(custBillTypeArr, bizInfos);
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
    }

    private void saveParameter(DynamicObject[] custBillTypeArr, DynamicObject[] sumBizInfos) {
        for (DynamicObject custBillTypeObj : custBillTypeArr) {
            String formId = custBillTypeObj.getDynamicObject("billformid").getString("id");
            String billTypePara = "qcbd_billtypeparameter";
            long billTypeId = custBillTypeObj.getLong("id");
            DynamicObject billTypeParamObj = BllTypeServiceImpl.getBillTypeParameter(formId, billTypeId);
            if (billTypeParamObj == null || !billTypeParamObj.containsProperty("entryentity")) continue;
            DynamicObjectCollection entryentity = billTypeParamObj.getDynamicObjectCollection("entryentity");
            int seq = 0;
            for (DynamicObject bizInfo : sumBizInfos) {
                DynamicObjectCollection billentity = bizInfo.getDynamicObjectCollection("billentity");
                if (billentity.stream().filter(x -> null != x.getDynamicObject("billform")).noneMatch(x -> x.getDynamicObject("billform").getString("number").equalsIgnoreCase(formId))) continue;
                seq = this.appendBizRow(entryentity, seq, bizInfo);
            }
            this.saveParameter(formId, billTypeId, EntityMetadataCache.getDataEntityType((String)billTypePara), billTypeParamObj);
        }
    }

    private int appendBizRow(DynamicObjectCollection entryentity, int seq, DynamicObject bizInfo) {
        if (entryentity.stream().anyMatch(x -> bizInfo.getLong("id") == x.getDynamicObject("biztypenumber").getLong("id"))) {
            return seq;
        }
        DynamicObject newEntry = entryentity.addNew();
        newEntry.set("biztypenumber", (Object)bizInfo);
        newEntry.set("seq", (Object)(++seq));
        return seq;
    }

    private DynamicObject[] getBizInfos(String isPreset) {
        QFilter[] filters = null;
        filters = kd.bos.util.StringUtils.isEmpty((String)isPreset) ? new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").toArray() : new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("ispreset", "=", (Object)isPreset).toArray();
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"qcbd_biztype", (String)"id", (QFilter[])filters);
        Set idSet = ids.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        return BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"qcbd_biztype"));
    }

    private Set<Long> getBllTypeId(String fissyspreset, String fisdefault, String billTypeidStr) {
        HashSet entitySet = new HashSet(16);
        Map entityRefelx = ParameterUtil.getQmcSystemPropMap((String)"entity_torepaire_S");
        Set entityEntrySet = entityRefelx.entrySet();
        for (Map.Entry entry : entityEntrySet) {
            if (!"true".equalsIgnoreCase((String)entry.getValue())) continue;
            entitySet.add(entry.getKey());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_bas_billtype where fbillformid in (");
        for (String entity : entitySet) {
            sb.append("'");
            sb.append(entity);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") and fstatus = 'C' and fenable = '1' and fissyspreset = '");
        sb.append(fissyspreset);
        sb.append("'");
        if (kd.bos.util.StringUtils.isNotEmpty((String)fisdefault)) {
            sb.append(" and fisdefault = '");
            sb.append(fisdefault);
            sb.append("'");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)billTypeidStr)) {
            sb.append(" and fid in ( ");
            sb.append(billTypeidStr);
            sb.append(" )");
        }
        DBRoute metaRoute = new DBRoute("sys");
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)metaRoute, (String)sb.toString());
        HashSet<Long> billTypeIdSet = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            billTypeIdSet.add(dataSet.next().getLong("fid"));
        }
        return billTypeIdSet;
    }

    private void saveParameter(String formId, long billTypeId, MainEntityType entityType, DynamicObject dataEntity) {
        logger.info("------------\u5f00\u59cb\u4fdd\u5b58\u6570\u636e------------");
        logger.info("------------formId------------" + formId);
        logger.info("------------billTypeId------------" + billTypeId);
        logger.info("------------entityType------------" + entityType.getName());
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject defaultDataEntity = (DynamicObject)entityType.createInstance();
        ParameterUtils.createDefaultEntity((MainEntityType)entityType, (DynamicObject)defaultDataEntity);
        jser.setCallUpdateFuncWhenCreated(false);
        String jsonString = jser.serializeToString((Object)dataEntity, (Object)defaultDataEntity);
        logger.info("------------jsonString------------" + jsonString);
        BllTypeServiceImpl.saveBillTypeParameter(formId, billTypeId, jsonString);
    }

    private static DynamicObject getBillTypeParameter(String formId, long billTypeId) {
        MainEntityType entityType;
        String paramFormId = "qcbd_billtypeparameter";
        DynamicObject object = null;
        String sql = " SELECT FDATA FROM T_BAS_BILLTYPEPARAMETER WHERE FFORMID=? AND FBILLTYPEID=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FFORMID", 12, (Object)formId));
        params.add(new SqlParameter(":FBILLTYPEID", -5, (Object)billTypeId));
        DynamicObjectCollection existData = SingleORM.query((DynamicObjectType)null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        logger.info("----------query formId--------" + formId);
        logger.info("----------query paramFormId--------" + paramFormId);
        logger.info("----------query billTypeId--------" + billTypeId);
        logger.info("----------query existData--------" + existData);
        if (StringUtils.isNotBlank((CharSequence)formId) && (entityType = EntityMetadataCache.getDataEntityType((String)formId)) instanceof BillEntityType) {
            object = ParameterUtils.serializeToDataEntity((DynamicObjectCollection)existData, (String)paramFormId);
        }
        return object;
    }

    private static void saveBillTypeParameter(String formId, long billTypeId, String jsonData) {
        if (billTypeId != 0L) {
            String sql = " SELECT count(1) FROM T_BAS_BILLTYPEPARAMETER WHERE FFORMID=? AND FBILLTYPEID=? ";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter(":FFORMID", 12, (Object)formId));
            params.add(new SqlParameter(":FBILLTYPEID", 12, (Object)billTypeId));
            DynamicObjectCollection count = SingleORM.query((DynamicObjectType)null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            if (count != null && !count.isEmpty() && ((DynamicObject)count.get(0)).getLong(0) != 0L) {
                sql = "UPDATE T_BAS_BILLTYPEPARAMETER SET FDATA = ? WHERE FFORMID=? AND FBILLTYPEID=? ";
                params.add(0, new SqlParameter(":FDATA", 12, (Object)jsonData));
                ParameterUtils.saveOrUpdateParam(params, (String)sql, (boolean)true);
            } else {
                sql = "INSERT INTO T_BAS_BILLTYPEPARAMETER (FFORMID, FBILLTYPEID, FDATA) VALUES (?, ?, ?)";
                params.add(new SqlParameter(":FDATA", 12, (Object)jsonData));
                ParameterUtils.saveOrUpdateParam(params, (String)sql, (boolean)false);
            }
            try {
                ParameterLocalCache.removeBillTypeParameter((String)formId, (Long)billTypeId);
                ParameterCache.removeBillTypeParamCache((String)formId, (Long)billTypeId);
            }
            catch (Exception e) {
                logger.info("\u5237\u65b0\u5355\u636e\u7c7b\u578b\u53c2\u6570\u7f13\u5b58\u5f02\u5e38");
            }
        }
    }
}

