/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class HandModeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(HandModeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        return this.repaireHandmode();
    }

    public UpgradeResult repaireHandmode() {
        UpgradeResult result = new UpgradeResult();
        try {
            QFilter filter = new QFilter("number", "=", (Object)"qcbd_badhandmode");
            boolean containEntity = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{filter});
            if (!containEntity) {
                return result;
            }
            boolean newCustomer = UpgradeSqlUtil.isNewCustomer((String)this.getClass().getName());
            if (newCustomer) {
                return result;
            }
            Map<Long, Long[]> billTypeReflex = this.getBillTypeReflex();
            QFilter[] filters = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("ispreset", "=", (Object)Character.valueOf('0')).toArray();
            DynamicObject[] handModeObjs = BusinessDataServiceHelper.load((String)"qcbd_badhandmode", (String)"entryentity.seq, billform,modebilltype,isshow", (QFilter[])filters);
            logger.info("handModeObjs.length" + handModeObjs.length);
            for (DynamicObject handModeObj : handModeObjs) {
                logger.info("handModeObj.getPkValue()" + handModeObj.getPkValue());
                DynamicObjectCollection entryentity = handModeObj.getDynamicObjectCollection("entryentity");
                LinkedList tempList = new LinkedList(entryentity);
                logger.info("tempList" + tempList);
                Set billTypeIdSet = tempList.stream().filter(x -> null != x.getDynamicObject("modebilltype")).map(x -> x.getDynamicObject("modebilltype").getLong("id")).collect(Collectors.toSet());
                logger.info("billTypeIdSet" + billTypeIdSet);
                for (DynamicObject tempObj : tempList) {
                    DynamicObject billTypeObj = tempObj.getDynamicObject("modebilltype");
                    if (null == billTypeObj) continue;
                    logger.info("billTypeObj" + billTypeObj.getPkValue());
                    Long billTypeId = billTypeObj.getLong("id");
                    logger.info("billTypeId" + billTypeId);
                    if (!billTypeReflex.containsKey(billTypeId)) continue;
                    logger.info("billTypeReflex" + billTypeReflex);
                    DynamicObject billform = tempObj.getDynamicObject("billform");
                    Boolean isshow = tempObj.getBoolean("isshow");
                    Long[] reflexBillTypeIds = billTypeReflex.get(billTypeId);
                    Set newBillTypeIdSet = Arrays.stream(reflexBillTypeIds).filter(x -> !billTypeIdSet.contains(x)).collect(Collectors.toSet());
                    logger.info("newBillTypeIdSet" + newBillTypeIdSet);
                    for (Long billTypeIdTemp : newBillTypeIdSet) {
                        logger.info("billTypeIdTemp" + billTypeIdTemp);
                        DynamicObject rowTemp = entryentity.addNew();
                        rowTemp.set("seq", (Object)entryentity.size());
                        rowTemp.set("modebilltype", (Object)billTypeIdTemp);
                        rowTemp.set("billform", (Object)billform);
                        rowTemp.set("isshow", (Object)isshow);
                        billTypeIdSet.add(billTypeIdTemp);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])handModeObjs);
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
            DataRepairUpgradeHelper.updateDataStatusByDb((String)"handmode_updata", (String)"2");
        }
        DataRepairUpgradeHelper.updateDataStatusByDb((String)"handmode_updata", (String)"1");
        return result;
    }

    private Map<Long, Long[]> getBillTypeReflex() {
        HashMap<Long, Long[]> billTypeReflex = new HashMap<Long, Long[]>(16);
        Long[] idArrQcp = new Long[]{1570894272322863104L};
        billTypeReflex.put(954855398727483392L, idArrQcp);
        Long[] idArrQcpp = new Long[]{1570897606375113728L, 1570902839465608192L, 1570904348945285120L};
        billTypeReflex.put(980217244858723328L, idArrQcpp);
        Long[] idArrQcas = new Long[]{1570905273999032320L};
        billTypeReflex.put(1157799514862828544L, idArrQcas);
        return billTypeReflex;
    }
}

