/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.repairtool.DataRepairUpgradeHelper;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;

public class InspectProServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InspectProServiceImpl.class);
    private static final DBRoute dbRoute = new DBRoute("qmc");
    private static final Long[] dimenIdsWithSup = new Long[]{1615104834913007616L, 1599303399160004608L, 1599887438686307328L};
    private static final Long[] dimenIdsQroute = new Long[]{1615104834913007616L, 1599908243205898240L, 1599908442980597760L, 1599908959274254336L};
    private static final Long[] dimenIdsMat = new Long[]{1615104834913007616L, 1599303399160004608L};
    private static final Long[] DIMENIDS_QROUTEWITHMAT_E = new Long[]{1615104834913007616L, 1599908243205898240L, 1599908442980597760L, 1599908959274254336L, 1599303399160004608L};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        String className = this.getClass().getName();
        ThreadPools.executeOnce((String)className, () -> {
            UpgradeResult result = new UpgradeResult();
            try {
                String tableName = "t_qcbd_inspectpro";
                boolean exitsMainTable = DB.exitsTable((DBRoute)dbRoute, (String)tableName);
                if (!exitsMainTable || !UpgradeSqlUtil.existRecord((String)this.getClass().getName(), (DBRoute)dbRoute, (String)tableName)) {
                    DataRepairUpgradeHelper.updateDataStatusByDb((String)"insppro_biztype_updata", (String)"1");
                    return;
                }
                this.repairBiztypeValueExtend(result);
                this.repairDimen(result, "", null, null);
                this.repairProjEntryStdid(result);
                if (result.isSuccess()) {
                    DataRepairUpgradeHelper.updateDataStatusByDb((String)"insppro_biztype_updata", (String)"1");
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                logger.info(result.isSuccess() + "\uff1a" + result.getErrorInfo());
            }
        });
        return new UpgradeResult();
    }

    public UpgradeResult repairBiztypeValueExtend(UpgradeResult result) {
        try {
            String updateSql = "update t_qcbd_inspectpro set fbiztypeid = ? where fbizstypeid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(10);
            Map inspproBiztypeReflexE = ParameterUtil.getQmcSystemPropMap((String)"insppro_biztype_reflex_E");
            for (Map.Entry entry : inspproBiztypeReflexE.entrySet()) {
                Object[] param = new Object[2];
                Long newBizTypeId = Long.valueOf((String)entry.getValue());
                param[0] = newBizTypeId;
                String bizTypeComboValue = (String)entry.getKey();
                param[1] = bizTypeComboValue;
                paramsList.add(param);
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("bizTypeId", newBizTypeId);
                map.put("biztypeStr", bizTypeComboValue);
                map.put("biztypeName", " ");
                maps.add(map);
            }
            if (!CollectionUtils.isEmpty(paramsList)) {
                result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)updateSql, (DBRoute)dbRoute, paramsList);
            }
            InspectProServiceImpl.addBiztypeReflex(maps);
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
        return result;
    }

    public UpgradeResult repairProjEntryStdid(UpgradeResult result) {
        try {
            String projTableName = "t_qcbd_schemeproj";
            if (!DB.exitsTable((DBRoute)dbRoute, (String)projTableName)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u8868\u540d%s\u4e0d\u5b58\u5728\u3002", (String)"InspectProServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), projTableName);
                return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
            }
            boolean excuteStatus = true;
            ORMImpl orm = new ORMImpl();
            while (excuteStatus) {
                DynamicObjectCollection repariData = this.getRepariData(orm);
                if (repariData.size() <= 0) {
                    return result;
                }
                if (100000 > repariData.size()) {
                    excuteStatus = false;
                }
                DynamicObjectCollection stdEntryCollection = this.getStdEntryCollection(orm, repariData);
                Map<Long, List<DynamicObject>> stdEntryGroupByFid = stdEntryCollection.stream().collect(Collectors.groupingBy(o -> o.getLong("fid")));
                List assignList = AverageAssignUtil.getAssignListByMaxSize((List)repariData, (int)5000);
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("update t_qcbd_schemeproj set fstdentryid = ? where fdetailid = ?");
                for (List proEntrysOnce : assignList) {
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
                    for (DynamicObject proEntry : proEntrysOnce) {
                        Object[] param = new Object[2];
                        List<DynamicObject> stdEntrys = stdEntryGroupByFid.get(proEntry.getLong("finspectstdid"));
                        int seq = proEntry.getInt("fseq");
                        long checkItemId = proEntry.getLong("fcheckitemsid");
                        long detailId = proEntry.getLong("fdetailid");
                        String checkContent = proEntry.getString("fcheckcontent");
                        Optional<DynamicObject> stdEntryOpt = stdEntrys.stream().filter(o -> seq == o.getInt("fseq") && checkItemId == o.getLong("fcheckitems") && StringUtils.equals((CharSequence)checkContent, (CharSequence)o.getString("fcheckcontent"))).findFirst();
                        if (!stdEntryOpt.isPresent()) {
                            stdEntryOpt = stdEntrys.stream().filter(o -> checkItemId == o.getLong("fcheckitems") && StringUtils.equals((CharSequence)checkContent, (CharSequence)o.getString("fcheckcontent"))).findFirst();
                        }
                        if (!stdEntryOpt.isPresent()) continue;
                        param[0] = stdEntryOpt.get().getLong("fentryid");
                        param[1] = detailId;
                        paramsList.add(param);
                    }
                    if (CollectionUtils.isEmpty(paramsList)) continue;
                    result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)updateSql.toString(), (DBRoute)dbRoute, paramsList);
                }
            }
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
        return result;
    }

    public UpgradeResult repairDimen(UpgradeResult result, String oldBiztypeId, Long[] ids, Long[] dimenIds) {
        try {
            String dimenTableName = "t_qcbd_pro_mulpmd";
            if (!DB.exitsTable((DBRoute)dbRoute, (String)dimenTableName)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u8868\u540d%s\u4e0d\u5b58\u5728\u3002", (String)"InspectProServiceImpl_0", (String)"qmc-qcbd-mservice", (Object[])new Object[0]), dimenTableName);
                return UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
            }
            boolean excuteStatus = true;
            while (excuteStatus) {
                DynamicObjectCollection repariData = this.getRepariDimenData(oldBiztypeId, ids);
                if (100000 > repariData.size()) {
                    excuteStatus = false;
                }
                List assignList = AverageAssignUtil.getAssignListByMaxSize((List)repariData, (int)5000);
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("insert into t_qcbd_pro_mulpmd (fpkid,fid,fbasedataid) values (?,?,?)");
                for (List onceRepairBills : assignList) {
                    ArrayList<Long> pkIdList = new ArrayList<Long>(10000);
                    ORMImpl orm = new ORMImpl();
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
                    for (DynamicObject singleBill : onceRepairBills) {
                        String biztypeId = singleBill.getString("fbizstypeid");
                        Long[] dimenIdSingle = ArrayUtils.isEmpty((Object[])dimenIds) ? this.getDimenIdsByBiztype(biztypeId) : dimenIds;
                        for (Long dimenId : dimenIdSingle) {
                            Object[] param = new Object[]{InspectProServiceImpl.getPkid(pkIdList, (ORM)orm), singleBill.get("fid"), dimenId};
                            paramsList.add(param);
                        }
                    }
                    if (CollectionUtils.isEmpty(paramsList)) continue;
                    result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)insertSql.toString(), (DBRoute)dbRoute, paramsList);
                }
            }
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
        return result;
    }

    private DynamicObjectCollection getRepariDimenData(String oldBiztypeId, Long[] ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 100000 a.fid,a.fbizstypeid,b.fbasedataid from t_qcbd_inspectpro a left join t_qcbd_pro_mulpmd b on a.fid = b.fid where b.fid is null and a.fbizstypeid!=' '", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)oldBiztypeId)) {
            sql.append("and a.fbizstypeid = ?", new Object[]{oldBiztypeId});
        }
        if (!ArrayUtils.isEmpty((Object[])ids)) {
            sql.appendIn("and a.fid", (Object[])ids);
        }
        DynamicObjectCollection repariData = new ORMImpl().toPlainDynamicObjectCollection(DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)sql));
        return repariData;
    }

    private DynamicObjectCollection getRepariData(ORMImpl orm) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 100000 a.finspectstdid,b.fdetailid,b.fcheckcontent,b.fcheckitemsid,b.fseq from t_qcbd_inspro_ent a inner join t_qcbd_schemeproj b on a.fentryid = b.fentryid where b.fstdentryid = 0;", new Object[0]);
        DynamicObjectCollection repariData = orm.toPlainDynamicObjectCollection(DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)sql));
        return repariData;
    }

    private DynamicObjectCollection getStdEntryCollection(ORMImpl orm, DynamicObjectCollection repariData) {
        Set stdIds = repariData.stream().map(o -> o.getLong("finspectstdid")).collect(Collectors.toSet());
        SqlBuilder selectStdSql = new SqlBuilder();
        selectStdSql.append("select fid,fentryid,fcheckitems,fcheckcontent,fseq from t_qcbd_inspectionstdentry where", new Object[0]);
        selectStdSql.appendIn("fid", stdIds.toArray());
        DynamicObjectCollection stdEntryCollection = orm.toPlainDynamicObjectCollection(DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectStdSql));
        return stdEntryCollection;
    }

    private Long[] getDimenIdsByBiztype(String biztypeId) {
        Map inspectproMatchtypeE = ParameterUtil.getQmcSystemPropMap((String)"inspectpro_matchtype_E");
        if (!CollectionUtils.isEmpty((Map)inspectproMatchtypeE)) {
            Object[] bizMatWithSups = ((String)inspectproMatchtypeE.get("bizMatWithSup")).split(",");
            Object[] bizMatNoSups = ((String)inspectproMatchtypeE.get("bizMatNoSup")).split(",");
            Object[] bizTecs = ((String)inspectproMatchtypeE.get("bizTec")).split(",");
            if (ArrayUtils.contains((Object[])bizMatWithSups, (Object)biztypeId)) {
                return dimenIdsWithSup;
            }
            if (ArrayUtils.contains((Object[])bizMatNoSups, (Object)biztypeId)) {
                return dimenIdsMat;
            }
            if (ArrayUtils.contains((Object[])bizTecs, (Object)biztypeId)) {
                String inspectproDimenE = ParameterUtil.getQmcSystemProp((String)"inspectpro_dimen_E", (String)biztypeId);
                if (StringUtils.isNotBlank((CharSequence)inspectproDimenE) && ArrayUtils.contains((Object[])inspectproDimenE.split(","), (Object)"mat")) {
                    return DIMENIDS_QROUTEWITHMAT_E;
                }
                return dimenIdsQroute;
            }
        }
        switch (biztypeId) {
            case "0": 
            case "9": {
                return dimenIdsWithSup;
            }
            case "4": 
            case "5": 
            case "8": {
                return dimenIdsQroute;
            }
            case "1": 
            case "2": 
            case "3": 
            case "6": 
            case "7": {
                return dimenIdsMat;
            }
        }
        return new Long[0];
    }

    private static Long getPkid(List<Long> pkIdList, ORM orm) {
        if (CollectionUtils.isEmpty(pkIdList)) {
            long[] pkIdArray = orm.genLongIds("qcp_inspecpbill", 10000);
            for (int i = 0; i < pkIdArray.length; ++i) {
                pkIdList.add(pkIdArray[i]);
            }
        }
        Long pkId = pkIdList.get(0);
        pkIdList.remove(0);
        return pkId;
    }

    public static void addBiztypeReflex(List<Map<String, Object>> maps) {
        DynamicObject inspproBiztypeReflex = BusinessDataServiceHelper.loadSingleFromCache((Object)1597180334154288128L, (String)"qcbd_sysconfig");
        DynamicObjectCollection reflexEntrys = inspproBiztypeReflex.getDynamicObjectCollection("entryentity");
        for (Map<String, Object> map : maps) {
            Long bizTypeId = (Long)map.get("bizTypeId");
            String biztypeStr = map.get("biztypeStr").toString();
            String biztypeName = map.get("biztypeName").toString();
            if (!reflexEntrys.stream().noneMatch(o -> StringUtils.equals((CharSequence)biztypeStr, (CharSequence)o.getString("attrkey")))) continue;
            DynamicObject reflexEntry = reflexEntrys.addNew();
            reflexEntry.set("seq", (Object)(reflexEntrys.size() - 1));
            reflexEntry.set("attrkey", (Object)biztypeStr);
            reflexEntry.set("attrvalue", (Object)bizTypeId);
            reflexEntry.set("attrvalue_tag", (Object)bizTypeId);
            reflexEntry.set("attrkeycaption", (Object)biztypeName);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inspproBiztypeReflex});
    }
}

