/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.common.util.AverageAssignUtil;

public class InspectionItemsServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(InspectionItemsServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"InspectionItemsServiceImpl", () -> {
            try {
                this.repairDatas("t_qcbd_inspecitems_entry", "t_qcbd_inspectionitems");
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        });
        return new UpgradeResult();
    }

    private void repairDatas(String inspectTableName, String inspObjTableName) {
        String qmcRouteKey = "qmc";
        DBRoute dbRoute = new DBRoute(qmcRouteKey);
        if (!DB.exitsTable((DBRoute)dbRoute, (String)inspectTableName) || !DB.exitsTable((DBRoute)dbRoute, (String)inspObjTableName)) {
            return;
        }
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append(String.format("select fid from %s", inspObjTableName), new Object[0]);
        selectSql.append("where fitementryqty = 0", new Object[0]);
        DataSet dsBills = this.getRowsData(dbRoute, selectSql);
        DynamicObjectCollection billColls = new ORMImpl().toPlainDynamicObjectCollection(dsBills);
        List billIdSet = billColls.stream().map(p -> p.getLong("fid")).collect(Collectors.toList());
        if (billIdSet.isEmpty()) {
            return;
        }
        List billSetRows = AverageAssignUtil.getAssignShardList(billIdSet, (int)1000);
        for (List billSetRow : billSetRows) {
            SqlBuilder strSql = new SqlBuilder();
            strSql.append(String.format("select fid,count(fid) from %s", inspectTableName), new Object[0]);
            strSql.append("where", new Object[0]);
            strSql.appendIn("fid", billSetRow.toArray());
            strSql.append("group by fid ;", new Object[0]);
            DataSet rows = this.getRowsData(dbRoute, strSql);
            Throwable throwable = null;
            try {
                HashMap<Long, Integer> billIdMap = new HashMap<Long, Integer>(16);
                for (Row row : rows) {
                    billIdMap.put(row.getLong("fid"), row.getInteger("count(fid)"));
                }
                SqlBuilder updateSql = new SqlBuilder();
                for (Map.Entry entry : billIdMap.entrySet()) {
                    updateSql.append(String.format("update %s", inspObjTableName), new Object[0]);
                    updateSql.append("set fitementryqty = ?", new Object[]{entry.getValue()});
                    updateSql.append("where fid = ?", new Object[]{entry.getKey()});
                    updateSql.append(";", new Object[0]);
                }
                if (updateSql.isEmpty()) continue;
                this.updateSqls(dbRoute, updateSql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rows == null) continue;
                if (throwable != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rows.close();
            }
        }
    }

    private void updateSqls(DBRoute dbRoute, SqlBuilder updateSql) {
        DB.update((DBRoute)dbRoute, (SqlBuilder)updateSql);
    }

    private DataSet getRowsData(DBRoute dbRoute, SqlBuilder strSql) {
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)strSql);
    }
}

