/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class InspobjUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InspobjUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"InspobjUpgradeServiceImpl", () -> {
            try {
                this.repairDatas("t_qcp_inspentry", "t_qcbd_qcpo_entry", "qcp_incominginspct");
                this.repairDatas("t_qcpp_inspentry", "t_qcbd_qcppo_entry", "qcpp_manuinspec");
                this.repairDatas("t_qcas_inspentry", "t_qcbd_qcas_entry", "qcas_saleinspec");
                this.repairDatas("t_qcnp_inspentry", "t_qcbd_otho_entry", "qcnp_invbalinspec");
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        });
        return new UpgradeResult();
    }

    private void repairDatas(String inspectTableName, String inspObjTableName, String inspectEntityName) {
        String qmcRouteKey = "qmc";
        DBRoute dbRoute = new DBRoute(qmcRouteKey);
        if (!DB.exitsTable((DBRoute)dbRoute, (String)inspectTableName) || !DB.exitsTable((DBRoute)dbRoute, (String)inspObjTableName)) {
            return;
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)inspObjTableName);
        if (columnNames.stream().noneMatch(o -> StringUtils.equalsIgnoreCase((CharSequence)o, (CharSequence)"finspfirstentrykey"))) {
            return;
        }
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append(String.format("select fentryid from %s", inspectTableName), new Object[0]);
        selectSql.append("where fjoinqty = 0 and fsecondck = '0'", new Object[0]);
        DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)selectSql);
        ArrayList<String> entryIds = new ArrayList<String>();
        for (Row row : rows) {
            entryIds.add(row.getString("fentryid"));
        }
        rows.close();
        int entryIdsSize = entryIds.size();
        for (int i = 0; i <= entryIdsSize / 10000; ++i) {
            int endIndex = Math.min(entryIdsSize, (i + 1) * 10000);
            List<Object> onceIdList = entryIds.subList(i * 10000, endIndex);
            this.updateOnce(inspObjTableName, inspectEntityName, dbRoute, onceIdList);
        }
    }

    private void updateOnce(String inspObjTableName, String inspectEntityName, DBRoute dbRoute, List<Object> onceIdList) {
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append(String.format("update %s", inspObjTableName), new Object[0]);
        updateSql.append("set finspfirstentrykey = concat('matintoentity_', fbillentryid), fentrynumber = 'matintoentity' where fentitynumberid = ? and", new Object[]{inspectEntityName});
        updateSql.appendIn("fbillentryid", onceIdList);
        DB.update((DBRoute)dbRoute, (SqlBuilder)updateSql);
    }
}

